/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.map.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatIntPredicate;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;

/**
 * This file was automatically generated from template file immutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableFloatIntMap extends FloatIntMap
{
    ImmutableFloatIntMap select(FloatIntPredicate predicate);

    ImmutableFloatIntMap reject(FloatIntPredicate predicate);

    ImmutableIntCollection select(IntPredicate predicate);

    ImmutableIntCollection reject(IntPredicate predicate);

    <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function);

    ImmutableFloatIntMap newWithKeyValue(float key, int value);

    ImmutableFloatIntMap newWithoutKey(float key);

    ImmutableFloatIntMap newWithoutAllKeys(FloatIterable keys);
}
