/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.map.primitive;

import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction0;
import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectIntPredicate;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.MutableIntIterator;

/**
 * This file was automatically generated from template file mutableObjectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableObjectIntMap<K> extends ObjectIntMap<K>
{
    MutableIntIterator intIterator();

    void clear();

    void put(K key, int value);

    void putAll(ObjectIntMap<? extends K> map);

    void removeKey(K key);

    void remove(Object key);

    int removeKeyIfAbsent(K key, int value);

    int getIfAbsentPut(K key, int value);

    int getIfAbsentPut(K key, IntFunction0 function);

    int getIfAbsentPutWithKey(K key, IntFunction<? super K> function);

    <P> int getIfAbsentPutWith(K key, IntFunction<? super P> function, P parameter);

    int updateValue(K key, int initialValueIfAbsent, IntToIntFunction function);

    MutableObjectIntMap<K> select(ObjectIntPredicate<? super K> predicate);

    MutableObjectIntMap<K> reject(ObjectIntPredicate<? super K> predicate);

    MutableIntCollection select(IntPredicate predicate);

    MutableIntCollection reject(IntPredicate predicate);

    <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function);

    MutableObjectIntMap<K> withKeyValue(K key, int value);

    MutableObjectIntMap<K> withoutKey(K key);

    MutableObjectIntMap<K> withoutAllKeys(Iterable<? extends K> keys);

    MutableObjectIntMap<K> asUnmodifiable();

    MutableObjectIntMap<K> asSynchronized();


    int addToValue(K key, int toBeAdded);
}
