/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api;

import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;

/**
 * ByteIterable is an interface which is memory-optimized for byte primitives.
 * It is inspired by the interface RichIterable, and contains a subset of the internal iterator methods on RichIterable like collect, sum, etc.
 * The API also includes an external iterator method, which returns an ByteIterator. ByteIterator helps iterate over the ByteIterable without boxing the primitives.
 * This file was automatically generated from template file primitiveIterable.stg.
 */
public interface ByteIterable extends PrimitiveIterable
{
    ByteIterator byteIterator();

    byte[] toArray();

    boolean contains(byte value);

    boolean containsAll(byte... source);

    boolean containsAll(ByteIterable source);

    void forEach(ByteProcedure procedure);

    /**
     * @since 7.0.
     */
    void each(ByteProcedure procedure);

    ByteIterable select(BytePredicate predicate);

    ByteIterable reject(BytePredicate predicate);

    <V> RichIterable<V> collect(ByteToObjectFunction<? extends V> function);

    byte detectIfNone(BytePredicate predicate, byte ifNone);

    int count(BytePredicate predicate);

    boolean anySatisfy(BytePredicate predicate);

    boolean allSatisfy(BytePredicate predicate);

    boolean noneSatisfy(BytePredicate predicate);

    MutableByteList toList();

    MutableByteSet toSet();

    MutableByteBag toBag();

    LazyByteIterable asLazy();

    <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function);


    long sum();

    byte max();

    byte maxIfEmpty(byte defaultValue);

    byte min();

    byte minIfEmpty(byte defaultValue);

    double average();

    double median();

    byte[] toSortedArray();

    MutableByteList toSortedList();
}
