/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.map.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortDoublePredicate;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableDoubleCollection;

/**
 * This file was automatically generated from template file immutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableShortDoubleMap extends ShortDoubleMap
{
    ImmutableShortDoubleMap select(ShortDoublePredicate predicate);

    ImmutableShortDoubleMap reject(ShortDoublePredicate predicate);

    ImmutableDoubleCollection select(DoublePredicate predicate);

    ImmutableDoubleCollection reject(DoublePredicate predicate);

    <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function);

    ImmutableShortDoubleMap newWithKeyValue(short key, double value);

    ImmutableShortDoubleMap newWithoutKey(short key);

    ImmutableShortDoubleMap newWithoutAllKeys(ShortIterable keys);
}
