/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.tuple;

import java.util.Map;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.tuple.ImmutableEntry;

class PairImpl<T1, T2>
implements Pair<T1, T2> {
    private static final long serialVersionUID = 1L;
    private final T1 one;
    private final T2 two;

    PairImpl(T1 newOne, T2 newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    public T1 getOne() {
        return this.one;
    }

    public T2 getTwo() {
        return this.two;
    }

    public void put(Map<T1, T2> map) {
        map.put(this.one, this.two);
    }

    public PairImpl<T2, T1> swap() {
        return new PairImpl<T2, T1>(this.two, this.one);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair that = (Pair)o;
        return Comparators.nullSafeEquals(this.one, that.getOne()) && Comparators.nullSafeEquals(this.two, that.getTwo());
    }

    public int hashCode() {
        int result = this.one == null ? 0 : this.one.hashCode();
        result = 29 * result + (this.two == null ? 0 : this.two.hashCode());
        return result;
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    public Map.Entry<T1, T2> toEntry() {
        return ImmutableEntry.of(this.one, this.two);
    }

    public int compareTo(Pair<T1, T2> other) {
        int i = ((Comparable)this.one).compareTo(other.getOne());
        if (i != 0) {
            return i;
        }
        return ((Comparable)this.two).compareTo(other.getTwo());
    }
}

