/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.RemoteConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitRepository
extends RemoteConfig {
    static final String REMOTE_SECTION = "remote";
    static final String TARGET_DIR_KEY = "targetDir";
    private static final String DEFAULT_TARGET_DIR = "";
    private String relativeTargetDir;

    public GitRepository(Config config, String name) throws URISyntaxException {
        super(config, name);
        String val = config.getString(REMOTE_SECTION, name, TARGET_DIR_KEY);
        if (val == null) {
            val = DEFAULT_TARGET_DIR;
        }
        this.relativeTargetDir = val;
    }

    public static List<RemoteConfig> getAllGitRepositories(Config rc) throws URISyntaxException {
        ArrayList names = new ArrayList(rc.getSubsections(REMOTE_SECTION));
        Collections.sort(names);
        ArrayList<RemoteConfig> result = new ArrayList<RemoteConfig>(names.size());
        for (String name : names) {
            result.add(new GitRepository(rc, name));
        }
        return result;
    }

    public String getRelativeTargetDir() {
        return this.relativeTargetDir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GitRepository that = (GitRepository)((Object)o);
        if (!CollectionUtils.isEqualCollection((Collection)this.getFetchRefSpecs(), (Collection)that.getFetchRefSpecs())) {
            return false;
        }
        if (!CollectionUtils.isEqualCollection((Collection)this.getPushRefSpecs(), (Collection)that.getPushRefSpecs())) {
            return false;
        }
        if (!CollectionUtils.isEqualCollection((Collection)this.getPushURIs(), (Collection)that.getPushURIs())) {
            return false;
        }
        if (!CollectionUtils.isEqualCollection((Collection)this.getURIs(), (Collection)that.getURIs())) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.getName(), (Object)that.getName()).append((Object)this.getReceivePack(), (Object)that.getReceivePack()).append((Object)this.getTagOpt(), (Object)that.getTagOpt()).append(this.getTimeout(), that.getTimeout()).append((Object)this.getUploadPack(), (Object)that.getUploadPack()).append(this.isMirror(), that.isMirror()).append((Object)this.relativeTargetDir, (Object)that.relativeTargetDir).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getFetchRefSpecs()).append((Object)this.getPushRefSpecs()).append((Object)this.getPushURIs()).append((Object)this.getURIs()).append((Object)this.getName()).append((Object)this.getReceivePack()).append((Object)this.getTagOpt()).append(this.getTimeout()).append((Object)this.getUploadPack()).append(this.isMirror()).append((Object)this.relativeTargetDir).toHashCode();
    }
}

