/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.converter;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.util.Base64Encoder;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.plugins.git.converter.LegacyConverter;
import org.eclipse.jgit.lib.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIdConverter
implements Converter,
LegacyConverter<ObjectId> {
    private static final String LEGACY_NODE_KEY = "byte-array";
    private Base64Encoder base64 = new Base64Encoder();

    public boolean canConvert(Class type) {
        return ObjectId.class == type;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.setValue(((ObjectId)source).name());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (this.isLegacyNode(reader, context)) {
            return this.legacyUnmarshal(reader, context);
        }
        return ObjectId.fromString((String)reader.getValue());
    }

    @Override
    public boolean isLegacyNode(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return reader.hasMoreChildren() && LEGACY_NODE_KEY.equals(reader.peekNextChild());
    }

    @Override
    public ObjectId legacyUnmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        ObjectId sha1 = ObjectId.fromRaw((byte[])this.base64.decode(reader.getValue()));
        reader.moveUp();
        return sha1;
    }
}

