/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.Extension;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.GitUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildChooser
extends BuildChooser {
    @DataBoundConstructor
    public DefaultBuildChooser() {
    }

    @Override
    public Collection<Revision> getCandidateRevisions(boolean isPollCall, String singleBranch, IGitAPI git, TaskListener listener, BuildData data) throws GitException, IOException {
        Set<String> tags;
        this.verbose(listener, "getCandidateRevisions({0},{1},,,{2}) considering branches to build", isPollCall, singleBranch, data);
        if (singleBranch == null || singleBranch.contains("*")) {
            return this.getAdvancedCandidateRevisions(isPollCall, listener, new GitUtils(listener, git), data);
        }
        if (!isPollCall && singleBranch.matches("[0-9a-f]{6,40}")) {
            try {
                ObjectId sha1 = git.revParse(singleBranch);
                Revision revision = new Revision(sha1);
                revision.getBranches().add(new Branch("detached", sha1));
                this.verbose(listener, "Will build the detached SHA1 {0}", sha1);
                return Collections.singletonList(revision);
            }
            catch (GitException e) {
                this.verbose(listener, "Not a valid SHA1 {0}", singleBranch);
            }
        }
        if (!singleBranch.contains("/") && (tags = git.getTagNames(singleBranch)).size() == 0) {
            String repository = this.gitSCM.getRepositories().get(0).getName();
            singleBranch = repository + "/" + singleBranch;
            this.verbose(listener, "{0} is not a tag. Qualifying with the repository {1} a a branch", singleBranch, repository);
        }
        try {
            ObjectId sha1 = git.revParse(singleBranch);
            this.verbose(listener, "rev-parse {0} -> {1}", singleBranch, sha1);
            if (isPollCall && data.hasBeenBuilt(sha1)) {
                this.verbose(listener, "{0} has already been built", sha1);
                return Collections.emptyList();
            }
            this.verbose(listener, "Found a new commit {0} to be built on {1}", sha1, singleBranch);
            Revision revision = new Revision(sha1);
            revision.getBranches().add(new Branch(singleBranch, sha1));
            return Collections.singletonList(revision);
        }
        catch (GitException e) {
            this.verbose(listener, "Failed to rev-parse: {0}", singleBranch);
            return Collections.emptyList();
        }
    }

    private Collection<Revision> getAdvancedCandidateRevisions(boolean isPollCall, TaskListener listener, GitUtils utils, BuildData data) throws GitException, IOException {
        Revision r;
        Collection<Revision> revs = utils.getAllBranchRevisions();
        this.verbose(listener, "Starting with all the branches: {0}", revs);
        Iterator<Revision> i = revs.iterator();
        while (i.hasNext()) {
            r = i.next();
            Iterator<Branch> j = r.getBranches().iterator();
            while (j.hasNext()) {
                Branch b = j.next();
                boolean keep = false;
                for (BranchSpec bspec : this.gitSCM.getBranches()) {
                    if (!bspec.matches(b.getName())) continue;
                    keep = true;
                    break;
                }
                if (keep) continue;
                this.verbose(listener, "Ignoring {0} because it doesn't match branch specifier", b);
                j.remove();
            }
            if (r.getBranches().size() != 0) continue;
            this.verbose(listener, "Ignoring {0} because we don't care about any of the branches that point to it", r);
            i.remove();
        }
        this.verbose(listener, "After branch filtering: {0}", revs);
        revs = utils.filterTipBranches(revs);
        this.verbose(listener, "After non-tip filtering: {0}", revs);
        this.verbose(listener, "Removing what's already been built: {0}", data.getBuildsByBranchName());
        i = revs.iterator();
        while (i.hasNext()) {
            r = i.next();
            if (!data.hasBeenBuilt(r.getSha1())) continue;
            i.remove();
        }
        this.verbose(listener, "After filtering out what's already been built: {0}", revs);
        if (!isPollCall && revs.isEmpty() && data.getLastBuiltRevision() != null) {
            if (!utils.git.isCommitInRepo(data.getLastBuiltRevision().getSha1String())) {
                return revs;
            }
            this.verbose(listener, "Nothing seems worth building, so falling back to the previously built revision: {0}", data.getLastBuiltRevision());
            return Collections.singletonList(data.getLastBuiltRevision());
        }
        return revs;
    }

    private void verbose(TaskListener listener, String format, Object ... args) {
        if (GitSCM.VERBOSE) {
            listener.getLogger().println(MessageFormat.format(format, args));
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildChooserDescriptor {
        public String getDisplayName() {
            return "Default";
        }

        public String getLegacyId() {
            return "Default";
        }
    }
}

