/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeTypeRefactoring;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class ChangeTypeContentProvider
implements ITreeContentProvider {
    private ChangeTypeRefactoring fGeneralizeType;

    ChangeTypeContentProvider(ChangeTypeRefactoring gt) {
        this.fGeneralizeType = gt;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof RootType) {
            return ((RootType)element).getChildren();
        }
        Object[] superTypes = this.getDirectSuperTypes((ITypeBinding)element).toArray();
        Arrays.sort(superTypes, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((ITypeBinding)o1).getQualifiedName();
                String name2 = ((ITypeBinding)o2).getQualifiedName();
                return name1.compareTo(name2);
            }
        });
        return superTypes;
    }

    public Set getDirectSuperTypes(ITypeBinding type) {
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        if (type.getSuperclass() != null) {
            result.add(type.getSuperclass());
        }
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            result.add(interfaces[i]);
            ++i;
        }
        if (this.fGeneralizeType.getOriginalType().isInterface() && type != this.fGeneralizeType.getObject()) {
            result.add(this.fGeneralizeType.getObject());
        }
        return result;
    }

    public Object[] getElements(Object element) {
        Assert.isTrue((boolean)(element instanceof RootType));
        return ((RootType)element).getChildren();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object getParent(Object element) {
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    static class RootType {
        private ITypeBinding fRoot;

        RootType(ITypeBinding root) {
            this.fRoot = root;
        }

        public ITypeBinding[] getChildren() {
            return new ITypeBinding[]{this.fRoot};
        }
    }
}

