/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class JavaElementImageDescriptor
extends CompositeImageDescriptor {
    public static final int ABSTRACT = 1;
    public static final int FINAL = 2;
    public static final int SYNCHRONIZED = 4;
    public static final int STATIC = 8;
    public static final int RUNNABLE = 16;
    public static final int WARNING = 32;
    public static final int ERROR = 64;
    public static final int OVERRIDES = 128;
    public static final int IMPLEMENTS = 256;
    public static final int CONSTRUCTOR = 512;
    public static final int DEPRECATED = 1024;
    public static final int VOLATILE = 2048;
    public static final int TRANSIENT = 4096;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;
    static /* synthetic */ Class class$0;

    public JavaElementImageDescriptor(ImageDescriptor baseImage, int flags, Point size) {
        this.fBaseImage = baseImage;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = size;
        Assert.isNotNull((Object)this.fSize);
    }

    public void setAdornments(int adornments) {
        Assert.isTrue((adornments >= 0 ? 1 : 0) != 0);
        this.fFlags = adornments;
    }

    public int getAdronments() {
        return this.fFlags;
    }

    public void setImageSize(Point size) {
        Assert.isNotNull((Object)size);
        Assert.isTrue((size.x >= 0 && size.y >= 0 ? 1 : 0) != 0);
        this.fSize = size;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        block8: {
            block7: {
                if (object == null) break block7;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.ui.JavaElementImageDescriptor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(object.getClass())) break block8;
            }
            return false;
        }
        JavaElementImageDescriptor other = (JavaElementImageDescriptor)((Object)object);
        return this.fBaseImage.equals(other.fBaseImage) && this.fFlags == other.fFlags && this.fSize.equals((Object)other.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this.fBaseImage);
        if ((this.fFlags & 0x400) != 0) {
            Point size = this.getSize();
            ImageData data = this.getImageData(JavaPluginImages.DESC_OVR_DEPRECATED);
            this.drawImage(data, 0, size.y - data.height);
        }
        this.drawImage(bg, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            JavaPlugin.logErrorMessage("Image data not available: " + descriptor.toString());
        }
        return data;
    }

    private void addTopRightImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x - data.width;
        if (x >= 0) {
            this.drawImage(data, x, pos.y);
            pos.x = x;
        }
    }

    private void addBottomRightImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x - data.width;
        int y = pos.y - data.height;
        if (x >= 0 && y >= 0) {
            this.drawImage(data, x, y);
            pos.x = x;
        }
    }

    private void addBottomLeftImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x;
        int y = pos.y - data.height;
        if (x + data.width < this.getSize().x && y >= 0) {
            this.drawImage(data, x, y);
            pos.x = x + data.width;
        }
    }

    private void drawTopRight() {
        Point pos = new Point(this.getSize().x, 0);
        if ((this.fFlags & 1) != 0) {
            this.addTopRightImage(JavaPluginImages.DESC_OVR_ABSTRACT, pos);
        }
        if ((this.fFlags & 0x200) != 0) {
            this.addTopRightImage(JavaPluginImages.DESC_OVR_CONSTRUCTOR, pos);
        }
        if ((this.fFlags & 2) != 0) {
            this.addTopRightImage(JavaPluginImages.DESC_OVR_FINAL, pos);
        }
        if ((this.fFlags & 0x800) != 0) {
            this.addTopRightImage(JavaPluginImages.DESC_OVR_VOLATILE, pos);
        }
        if ((this.fFlags & 8) != 0) {
            this.addTopRightImage(JavaPluginImages.DESC_OVR_STATIC, pos);
        }
    }

    private void drawBottomRight() {
        Point size = this.getSize();
        Point pos = new Point(size.x, size.y);
        int flags = this.fFlags;
        int syncAndOver = 132;
        int syncAndImpl = 260;
        if ((flags & syncAndOver) == syncAndOver) {
            this.addBottomRightImage(JavaPluginImages.DESC_OVR_SYNCH_AND_OVERRIDES, pos);
            flags &= ~syncAndOver;
        } else if ((flags & syncAndImpl) == syncAndImpl) {
            this.addBottomRightImage(JavaPluginImages.DESC_OVR_SYNCH_AND_IMPLEMENTS, pos);
            flags &= ~syncAndImpl;
        }
        if ((flags & 0x80) != 0) {
            this.addBottomRightImage(JavaPluginImages.DESC_OVR_OVERRIDES, pos);
        }
        if ((flags & 0x100) != 0) {
            this.addBottomRightImage(JavaPluginImages.DESC_OVR_IMPLEMENTS, pos);
        }
        if ((flags & 4) != 0) {
            this.addBottomRightImage(JavaPluginImages.DESC_OVR_SYNCH, pos);
        }
        if ((flags & 0x10) != 0) {
            this.addBottomRightImage(JavaPluginImages.DESC_OVR_RUN, pos);
        }
        if ((flags & 0x1000) != 0) {
            this.addBottomRightImage(JavaPluginImages.DESC_OVR_TRANSIENT, pos);
        }
    }

    private void drawBottomLeft() {
        Point pos = new Point(0, this.getSize().y);
        if ((this.fFlags & 0x40) != 0) {
            this.addBottomLeftImage(JavaPluginImages.DESC_OVR_ERROR, pos);
        }
        if ((this.fFlags & 0x20) != 0) {
            this.addBottomLeftImage(JavaPluginImages.DESC_OVR_WARNING, pos);
        }
    }
}

