/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.server.AsyncContinuation;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class RequestLogHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(RequestLogHandler.class);
    private RequestLog _requestLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        AsyncContinuation continuation = baseRequest.getAsyncContinuation();
        if (!continuation.isInitial()) {
            baseRequest.setDispatchTime(System.currentTimeMillis());
        }
        try {
            super.handle(target, baseRequest, request, response);
            if (continuation.isAsync()) {
                if (continuation.isInitial()) {
                    continuation.addContinuationListener(new ContinuationListener(baseRequest, response){
                        final /* synthetic */ Request val$baseRequest;
                        final /* synthetic */ HttpServletResponse val$response;
                        {
                            this.val$baseRequest = request;
                            this.val$response = httpServletResponse;
                        }

                        @Override
                        public void onTimeout(Continuation continuation) {
                        }

                        @Override
                        public void onComplete(Continuation continuation) {
                            RequestLogHandler.this._requestLog.log(this.val$baseRequest, (Response)this.val$response);
                        }
                    });
                }
            } else {
                this._requestLog.log(baseRequest, (Response)response);
            }
        }
        catch (Throwable throwable) {
            if (continuation.isAsync()) {
                if (continuation.isInitial()) {
                    continuation.addContinuationListener(new /* invalid duplicate definition of identical inner class */);
                }
            } else {
                this._requestLog.log(baseRequest, (Response)response);
            }
            throw throwable;
        }
    }

    public void setRequestLog(RequestLog requestLog) {
        try {
            if (this._requestLog != null) {
                this._requestLog.stop();
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._requestLog, requestLog, "logimpl", true);
        }
        this._requestLog = requestLog;
        try {
            if (this.isStarted() && this._requestLog != null) {
                this._requestLog.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setServer(Server server) {
        if (this._requestLog != null) {
            if (this.getServer() != null && this.getServer() != server) {
                this.getServer().getContainer().update((Object)this, this._requestLog, null, "logimpl", true);
            }
            super.setServer(server);
            if (server != null && server != this.getServer()) {
                server.getContainer().update((Object)this, null, this._requestLog, "logimpl", true);
            }
        } else {
            super.setServer(server);
        }
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    @Override
    protected void doStart() throws Exception {
        if (this._requestLog == null) {
            LOG.warn("!RequestLog", new Object[0]);
            this._requestLog = new NullRequestLog();
        }
        super.doStart();
        this._requestLog.start();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._requestLog.stop();
        if (this._requestLog instanceof NullRequestLog) {
            this._requestLog = null;
        }
    }

    private static class NullRequestLog
    extends AbstractLifeCycle
    implements RequestLog {
        private NullRequestLog() {
        }

        @Override
        public void log(Request request, Response response) {
        }
    }
}

