/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.maven.plugin;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractForker
extends AbstractLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractForker.class);
    protected Map<String, String> env;
    protected String jvmArgs;
    protected boolean exitVm;
    protected boolean stopAtShutdown;
    protected List<File> jettyXmlFiles;
    protected Map<String, String> jettyProperties;
    protected int stopPort;
    protected String stopKey;
    protected File jettyOutputFile;
    protected boolean waitForChild;
    protected int maxChildStartChecks = 10;
    protected long maxChildStartCheckMs = 200L;
    protected File tokenFile;
    protected File workDir;
    protected Map<String, String> systemProperties;

    protected abstract ProcessBuilder createCommand();

    protected abstract void redeployWebApp() throws Exception;

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public String getJvmArgs() {
        return this.jvmArgs;
    }

    public void setJvmArgs(String jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    public boolean isExitVm() {
        return this.exitVm;
    }

    public void setExitVm(boolean exitVm) {
        this.exitVm = exitVm;
    }

    public boolean isStopAtShutdown() {
        return this.stopAtShutdown;
    }

    public void setStopAtShutdown(boolean stopAtShutdown) {
        this.stopAtShutdown = stopAtShutdown;
    }

    public List<File> getJettyXmlFiles() {
        return this.jettyXmlFiles;
    }

    public void setJettyXmlFiles(List<File> jettyXmlFiles) {
        this.jettyXmlFiles = jettyXmlFiles;
    }

    public Map<String, String> getJettyProperties() {
        return this.jettyProperties;
    }

    public void setJettyProperties(Map<String, String> jettyProperties) {
        this.jettyProperties = jettyProperties;
    }

    public int getStopPort() {
        return this.stopPort;
    }

    public void setStopPort(int stopPort) {
        this.stopPort = stopPort;
    }

    public String getStopKey() {
        return this.stopKey;
    }

    public void setStopKey(String stopKey) {
        this.stopKey = stopKey;
    }

    public File getJettyOutputFile() {
        return this.jettyOutputFile;
    }

    public void setJettyOutputFile(File jettyOutputFile) {
        this.jettyOutputFile = jettyOutputFile;
    }

    public boolean isWaitForChild() {
        return this.waitForChild;
    }

    public void setWaitForChild(boolean waitForChild) {
        this.waitForChild = waitForChild;
    }

    public int getMaxChildtartChecks() {
        return this.maxChildStartChecks;
    }

    public void setMaxChildStartChecks(int maxChildStartChecks) {
        this.maxChildStartChecks = maxChildStartChecks;
    }

    public long getMaxChildStartCheckMs() {
        return this.maxChildStartCheckMs;
    }

    public void setMaxChildStartCheckMs(long maxChildStartCheckMs) {
        this.maxChildStartCheckMs = maxChildStartCheckMs;
    }

    public File getTokenFile() {
        return this.tokenFile;
    }

    public void setTokenFile(File tokenFile) {
        this.tokenFile = tokenFile;
    }

    public void doStart() throws Exception {
        super.doStart();
        ProcessBuilder command = this.createCommand();
        Process process = command.start();
        if (this.waitForChild) {
            process.waitFor();
        } else {
            int attempts;
            for (attempts = this.maxChildStartChecks; !this.tokenFile.exists() && attempts > 0; --attempts) {
                Thread.sleep(this.maxChildStartCheckMs);
            }
            if (attempts <= 0) {
                LOG.info("Couldn't verify success of child startup");
            }
        }
    }
}

