/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.apache.jsp;

import jakarta.servlet.ServletContext;
import java.net.URL;
import java.util.Collection;
import org.apache.jasper.servlet.TldPreScanned;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;

public class JettyTldPreScanned
extends TldPreScanned {
    private final Collection<URL> _jettyPreScannedURLs;

    public JettyTldPreScanned(ServletContext context, boolean namespaceAware, boolean validation, boolean blockExternal, Collection<URL> preScannedTlds) {
        super(context, namespaceAware, validation, blockExternal, preScannedTlds);
        this._jettyPreScannedURLs = preScannedTlds;
    }

    @Override
    public void scanJars() {
        if (this._jettyPreScannedURLs != null) {
            for (URL url : this._jettyPreScannedURLs) {
                String str = url.toExternalForm();
                int a = str.indexOf("jar:");
                int b = str.indexOf("META-INF");
                if (b < 0) {
                    throw new IllegalStateException("Bad tld url: " + str);
                }
                String path = str.substring(b);
                if (a >= 0) {
                    int c = str.indexOf("!/");
                    String fileUrl = str.substring(a + 4, c);
                    try {
                        this.parseTld(new TldResourcePath(new URL(fileUrl), null, path));
                        continue;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                try {
                    this.parseTld(new TldResourcePath(url, null, null));
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

