/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.webapp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.MountedPathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebInfConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(WebInfConfiguration.class);
    public static final String TEMPDIR_CONFIGURED = "org.eclipse.jetty.tmpdirConfigured";
    public static final String TEMPORARY_RESOURCE_BASE = "org.eclipse.jetty.webapp.tmpResourceBase";
    public static final String ORIGINAL_RESOURCE_BASE = "org.eclipse.jetty.webapp.originalResourceBase";

    public WebInfConfiguration() {
        this(new AbstractConfiguration.Builder());
    }

    protected WebInfConfiguration(AbstractConfiguration.Builder builder) {
        super(builder);
    }

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        this.resolveTempDirectory(context);
        context.createTempDirectory();
        this.unpack(context);
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        Resource webInf = context.getWebInf();
        if (webInf != null && webInf.isDirectory() && context.getClassLoader() instanceof WebAppClassLoader) {
            Resource lib;
            Resource classes = webInf.resolve("classes/");
            if (Resources.isReadableDirectory(classes)) {
                ((WebAppClassLoader)context.getClassLoader()).addClassPath(classes);
            }
            if (Resources.isReadableDirectory(lib = webInf.resolve("lib/"))) {
                ((WebAppClassLoader)context.getClassLoader()).addJars(lib);
            }
        }
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        Boolean tmpdirConfigured = (Boolean)context.getAttribute(TEMPDIR_CONFIGURED);
        if (tmpdirConfigured != null && !tmpdirConfigured.booleanValue()) {
            context.setTempDirectory(null);
        }
        Resource originalBaseResource = (Resource)context.removeAttribute(ORIGINAL_RESOURCE_BASE);
        context.setBaseResource(originalBaseResource);
    }

    public void resolveTempDirectory(WebAppContext context) throws Exception {
        File tempDirectory = context.getTempDirectory();
        if (tempDirectory != null) {
            context.setAttribute(TEMPDIR_CONFIGURED, Boolean.TRUE);
            return;
        }
        File servletTmpDir = IO.asFile(context.getAttribute("jakarta.servlet.context.tempdir"));
        if (servletTmpDir != null) {
            tempDirectory = servletTmpDir;
            context.setTempDirectory(tempDirectory);
            return;
        }
        this.makeTempDirectory(context.getServer().getContext().getTempDirectory(), context);
    }

    public void makeTempDirectory(File parent, WebAppContext context) throws Exception {
        File tmpDir;
        if (!(parent != null && parent.exists() && parent.canWrite() && parent.isDirectory())) {
            throw new IllegalStateException("Parent for temp dir not configured correctly: " + (String)(parent == null ? "null" : "writeable=" + parent.canWrite()));
        }
        boolean persistent = context.isTempDirectoryPersistent() || "work".equals(parent.toPath().getFileName().toString());
        String temp = WebInfConfiguration.getCanonicalNameForWebAppTmpDir(context);
        if (persistent) {
            tmpDir = new File(parent, temp);
        } else {
            tmpDir = Files.createTempDirectory(parent.toPath(), temp, new FileAttribute[0]).toFile();
            tmpDir.deleteOnExit();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set temp dir {}", (Object)tmpDir);
        }
        context.setTempDirectory(tmpDir);
        context.setTempDirectoryPersistent(persistent);
    }

    public void unpack(WebAppContext context) throws IOException {
        Resource webApp = context.getBaseResource();
        context.setAttribute(ORIGINAL_RESOURCE_BASE, context.getBaseResource());
        if (webApp == null) {
            Resource jarWebApp;
            String war = context.getWar();
            webApp = war != null && war.length() > 0 ? context.newResource(war) : context.getBaseResource();
            if (webApp == null) {
                throw new IllegalStateException("No resourceBase or war set for context");
            }
            if (webApp.isAlias()) {
                Resource realWebApp;
                URI realURI = webApp.getRealURI();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} anti-aliased to {}", (Object)webApp, (Object)realURI);
                }
                if (Resources.exists(realWebApp = context.newResource(realURI))) {
                    webApp = realWebApp;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try webapp={} exists={} directory={} file={}", webApp, webApp.exists(), webApp.isDirectory(), webApp.getPath());
            }
            Resource originalWarResource = webApp;
            if (Resources.isReadableFile(webApp) && FileID.isJavaArchive(webApp.getURI()) && !webApp.getURI().getScheme().equalsIgnoreCase("jar") && Resources.isReadableFile(jarWebApp = context.getResourceFactory().newJarFileResource(webApp.getURI()))) {
                webApp = jarWebApp;
            }
            if (context.isCopyWebDir() && webApp.getPath() != null && originalWarResource.isDirectory() || context.isExtractWAR() && webApp.getPath() != null && !originalWarResource.isDirectory() || context.isExtractWAR() && webApp.getPath() == null || !originalWarResource.isDirectory()) {
                Path sibling;
                Path warPath;
                Path extractedWebAppDir = null;
                if (war != null && FileID.isWebArchive(warPath = Path.of(war, new String[0])) && Files.exists(warPath, new LinkOption[0]) && Files.exists(sibling = warPath.getParent().resolve(FileID.getBasename(warPath)), new LinkOption[0]) && Files.isDirectory(sibling, new LinkOption[0]) && Files.isWritable(sibling)) {
                    extractedWebAppDir = sibling;
                }
                if (extractedWebAppDir == null) {
                    extractedWebAppDir = context.getTempDirectory().toPath().resolve("webapp");
                    context.setAttribute(TEMPORARY_RESOURCE_BASE, extractedWebAppDir);
                }
                if (Resources.isReadableDirectory(webApp)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Copy {} to  {}", (Object)webApp, (Object)extractedWebAppDir);
                    }
                    webApp.copyTo(extractedWebAppDir);
                } else {
                    File extractionLock = new File(context.getTempDirectory(), ".extract_lock");
                    if (!Files.exists(extractedWebAppDir, new LinkOption[0])) {
                        extractionLock.createNewFile();
                        Files.createDirectory(extractedWebAppDir, new FileAttribute[0]);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Extract {} to {}", (Object)webApp, (Object)extractedWebAppDir);
                        }
                        resourceFactory = ResourceFactory.closeable();
                        try {
                            jarWebApp = resourceFactory.newJarFileResource(webApp.getURI());
                            jarWebApp.copyTo(extractedWebAppDir);
                        }
                        finally {
                            if (resourceFactory != null) {
                                resourceFactory.close();
                            }
                        }
                        extractionLock.delete();
                    } else if (originalWarResource.lastModified().isAfter(Files.getLastModifiedTime(extractedWebAppDir, new LinkOption[0]).toInstant()) || extractionLock.exists()) {
                        extractionLock.createNewFile();
                        IO.delete(extractedWebAppDir);
                        Files.createDirectory(extractedWebAppDir, new FileAttribute[0]);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Extract {} to {}", (Object)webApp, (Object)extractedWebAppDir);
                        }
                        resourceFactory = ResourceFactory.closeable();
                        try {
                            jarWebApp = resourceFactory.newJarFileResource(webApp.getURI());
                            jarWebApp.copyTo(extractedWebAppDir);
                        }
                        finally {
                            if (resourceFactory != null) {
                                resourceFactory.close();
                            }
                        }
                        extractionLock.delete();
                    }
                }
                Resource extractedWebApp = context.getResourceFactory().newResource(extractedWebAppDir.normalize());
                if (extractedWebApp == null) {
                    LOG.warn("Unable to use non-existent extracted war location: " + String.valueOf(extractedWebApp));
                } else {
                    webApp = extractedWebApp;
                }
            }
            if (Resources.missing(webApp)) {
                LOG.warn("Web application not found {}", (Object)war);
                throw new FileNotFoundException(war);
            }
            context.setBaseResource(webApp);
            if (LOG.isDebugEnabled()) {
                LOG.debug("webapp={}", (Object)webApp);
            }
        }
        if (context.isCopyWebInf() && !context.isCopyWebDir()) {
            Resource webInf = webApp.resolve("WEB-INF/");
            if (Resources.isReadableDirectory(webInf)) {
                Resource webInfClasses;
                File extractedWebInfDir = new File(context.getTempDirectory(), "webinf");
                if (extractedWebInfDir.exists()) {
                    IO.delete(extractedWebInfDir);
                }
                extractedWebInfDir.mkdir();
                Resource webInfLib = webInf.resolve("lib/");
                File webInfDir = new File(extractedWebInfDir, "WEB-INF");
                webInfDir.mkdir();
                if (Resources.isReadableDirectory(webInfLib)) {
                    File webInfLibDir = new File(webInfDir, "lib");
                    if (webInfLibDir.exists()) {
                        IO.delete(webInfLibDir);
                    }
                    webInfLibDir.mkdir();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Copying WEB-INF/lib {} to {}", (Object)webInfLib, (Object)webInfLibDir);
                    }
                    webInfLib.copyTo(webInfLibDir.toPath());
                }
                if (Resources.isReadableDirectory(webInfClasses = webInf.resolve("classes/"))) {
                    File webInfClassesDir = new File(webInfDir, "classes");
                    if (webInfClassesDir.exists()) {
                        IO.delete(webInfClassesDir);
                    }
                    webInfClassesDir.mkdir();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Copying WEB-INF/classes from {} to {}", (Object)webInfClasses, (Object)webInfClassesDir.getAbsolutePath());
                    }
                    webInfClasses.copyTo(webInfClassesDir.toPath());
                }
                webInf = context.getResourceFactory().newResource(extractedWebInfDir.getCanonicalPath());
            }
            Resource rc = ResourceFactory.combine(webInf, webApp);
            if (LOG.isDebugEnabled()) {
                LOG.debug("context.baseResource={}", (Object)rc);
            }
            context.setBaseResource(rc);
        }
    }

    public static String getCanonicalNameForWebAppTmpDir(WebAppContext context) {
        Connector[] connectors;
        StringBuilder canonicalName = new StringBuilder();
        canonicalName.append("jetty-");
        Server server = context.getServer();
        if (server != null && (connectors = server.getConnectors()).length > 0) {
            String host = null;
            int port = 0;
            Connector connector = connectors[0];
            if (connector instanceof NetworkConnector) {
                NetworkConnector connector2 = (NetworkConnector)connector;
                host = connector2.getHost();
                port = connector2.getLocalPort();
                if (port < 0) {
                    port = connector2.getPort();
                }
            }
            if (host == null) {
                host = "0.0.0.0";
            }
            canonicalName.append(host);
            canonicalName.append("-");
            canonicalName.append(port);
            canonicalName.append("-");
        }
        try {
            Resource resource = context.getBaseResource();
            if (resource == null) {
                if (context.getWar() == null || context.getWar().length() == 0) {
                    throw new IllegalStateException("No resourceBase or war set for context");
                }
                resource = context.newResource(context.getWar());
            }
            String resourceBaseName = WebInfConfiguration.getResourceBaseName(resource);
            canonicalName.append(resourceBaseName);
            canonicalName.append("-");
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Can't get resource base name", e);
            }
            canonicalName.append("-");
        }
        String contextPath = context.getContextPath();
        contextPath = contextPath.replace('/', '_');
        contextPath = contextPath.replace('\\', '_');
        canonicalName.append(contextPath);
        canonicalName.append("-");
        List<String> vhosts = context.getVirtualHosts();
        if (vhosts == null || vhosts.size() <= 0) {
            canonicalName.append("any");
        } else {
            canonicalName.append(vhosts.get(0));
        }
        for (int i = 0; i < canonicalName.length(); ++i) {
            char c = canonicalName.charAt(i);
            if (Character.isJavaIdentifierPart(c) || "-.".indexOf(c) >= 0) continue;
            canonicalName.setCharAt(i, '.');
        }
        canonicalName.append("-");
        return StringUtil.sanitizeFileSystemName(canonicalName.toString());
    }

    protected static String getResourceBaseName(Resource resource) {
        Path resourceFile = resource.getPath();
        if (resourceFile != null && resource instanceof MountedPathResource) {
            resourceFile = ((MountedPathResource)resource).getContainerPath();
        }
        if (resourceFile != null) {
            Path fileName = resourceFile.getFileName();
            return fileName == null ? "" : fileName.toString();
        }
        URI uri = resource.getURI();
        if (uri == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource has no URI reference: {}", (Object)resource);
            }
            return "";
        }
        return URIUtil.getUriLastPathSegment(uri);
    }
}

