/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http.ByteRange;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MultiPart;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.io.content.ContentSourceCompletableFuture;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.AutoLock;

public class MultiPartByteRanges {
    private MultiPartByteRanges() {
    }

    public static class Parser {
        private final PartsListener listener = new PartsListener();
        private final MultiPart.Parser parser;
        private Parts parts;

        public Parser(String boundary) {
            this.parser = new MultiPart.Parser(boundary, this.listener);
        }

        public CompletableFuture<Parts> parse(Content.Source content) {
            ContentSourceCompletableFuture<Parts> futureParts = new ContentSourceCompletableFuture<Parts>(content){

                @Override
                protected Parts parse(Content.Chunk chunk) throws Throwable {
                    if (listener.isFailed()) {
                        throw listener.failure;
                    }
                    parser.parse(chunk);
                    if (listener.isFailed()) {
                        throw listener.failure;
                    }
                    return parts;
                }

                @Override
                public boolean completeExceptionally(Throwable failure) {
                    boolean failed = super.completeExceptionally(failure);
                    if (failed) {
                        listener.fail(failure);
                    }
                    return failed;
                }
            };
            futureParts.parse();
            return futureParts;
        }

        public String getBoundary() {
            return this.parser.getBoundary();
        }

        private class PartsListener
        extends MultiPart.AbstractPartsListener {
            private final AutoLock lock = new AutoLock();
            private final List<Content.Chunk> partChunks = new ArrayList<Content.Chunk>();
            private final List<MultiPart.Part> parts = new ArrayList<MultiPart.Part>();
            private Throwable failure;

            private PartsListener() {
            }

            private boolean isFailed() {
                try (AutoLock ignored = this.lock.lock();){
                    boolean bl = this.failure != null;
                    return bl;
                }
            }

            @Override
            public void onPartContent(Content.Chunk chunk) {
                try (AutoLock ignored = this.lock.lock();){
                    chunk.retain();
                    this.partChunks.add(chunk);
                }
            }

            @Override
            public void onPart(String name, String fileName, HttpFields headers) {
                try (AutoLock ignored = this.lock.lock();){
                    this.parts.add(new MultiPart.ChunksPart(name, fileName, headers, List.copyOf(this.partChunks)));
                    this.partChunks.forEach(Retainable::release);
                    this.partChunks.clear();
                }
            }

            @Override
            public void onComplete() {
                super.onComplete();
                try (AutoLock ignored = this.lock.lock();){
                    List<MultiPart.Part> copy = List.copyOf(this.parts);
                    Parser.this.parts = new Parts(Parser.this.getBoundary(), copy);
                }
            }

            @Override
            public void onFailure(Throwable failure) {
                this.fail(failure);
            }

            private void fail(Throwable cause) {
                List<MultiPart.Part> partsToFail;
                try (AutoLock ignored = this.lock.lock();){
                    if (this.failure != null) {
                        return;
                    }
                    this.failure = cause;
                    partsToFail = List.copyOf(this.parts);
                    this.parts.clear();
                    this.partChunks.forEach(Retainable::release);
                    this.partChunks.clear();
                }
                partsToFail.forEach(p -> p.fail(cause));
            }
        }
    }

    public static class Part
    extends MultiPart.Part {
        private final Resource resource;
        private final ByteRange byteRange;

        public Part(String contentType, Resource resource, ByteRange byteRange, long contentLength) {
            this(HttpFields.build().put(HttpHeader.CONTENT_TYPE, contentType).put(HttpHeader.CONTENT_RANGE, byteRange.toHeaderValue(contentLength)), resource, byteRange);
        }

        public Part(HttpFields headers, Resource resource, ByteRange byteRange) {
            super(null, null, headers);
            this.resource = resource;
            this.byteRange = byteRange;
        }

        @Override
        public Content.Source newContentSource() {
            Path path = this.resource.getPath();
            if (path != null) {
                return new PathContentSource(path, this.byteRange);
            }
            try {
                return new InputStreamContentSource(this.resource.newInputStream(), this.byteRange);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }

    public static class PathContentSource
    extends org.eclipse.jetty.io.content.PathContentSource {
        private final ByteRange byteRange;
        private long toRead;

        public PathContentSource(Path path, ByteRange byteRange) {
            super(path);
            this.byteRange = byteRange;
        }

        @Override
        protected SeekableByteChannel open() throws IOException {
            SeekableByteChannel channel = super.open();
            channel.position(this.byteRange.first());
            this.toRead = this.byteRange.getLength();
            return channel;
        }

        @Override
        protected int read(SeekableByteChannel channel, ByteBuffer byteBuffer) throws IOException {
            int read = super.read(channel, byteBuffer);
            if (read <= 0) {
                return read;
            }
            read = (int)Math.min((long)read, this.toRead);
            this.toRead -= (long)read;
            byteBuffer.position(read);
            return read;
        }

        @Override
        protected boolean isReadComplete(long read) {
            return read == this.byteRange.getLength();
        }
    }

    public static class InputStreamContentSource
    extends org.eclipse.jetty.io.content.InputStreamContentSource {
        private long toRead;

        public InputStreamContentSource(InputStream inputStream, ByteRange byteRange) throws IOException {
            super(inputStream);
            inputStream.skipNBytes(byteRange.first());
            this.toRead = byteRange.getLength();
        }

        @Override
        protected int fillBufferFromInputStream(InputStream inputStream, byte[] buffer) throws IOException {
            if (this.toRead == 0L) {
                return -1;
            }
            int toReadInt = (int)Math.min(Integer.MAX_VALUE, this.toRead);
            int len = Math.min(toReadInt, buffer.length);
            int read = inputStream.read(buffer, 0, len);
            this.toRead -= (long)read;
            return read;
        }
    }

    public static class ContentSource
    extends MultiPart.AbstractContentSource {
        public ContentSource(String boundary) {
            super(boundary);
        }

        @Override
        public boolean addPart(MultiPart.Part part) {
            if (part instanceof Part) {
                return super.addPart(part);
            }
            return false;
        }
    }

    public static class Parts
    implements Iterable<MultiPart.Part> {
        private final String boundary;
        private final List<MultiPart.Part> parts;

        private Parts(String boundary, List<MultiPart.Part> parts) {
            this.boundary = boundary;
            this.parts = parts;
        }

        public String getBoundary() {
            return this.boundary;
        }

        public MultiPart.Part get(int index) {
            return this.parts.get(index);
        }

        public int size() {
            return this.parts.size();
        }

        @Override
        public Iterator<MultiPart.Part> iterator() {
            return this.parts.iterator();
        }
    }
}

