/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.Syntax;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.session.DefaultSessionCache;
import org.eclipse.jetty.session.DefaultSessionIdManager;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.session.NullSessionDataStore;
import org.eclipse.jetty.session.SessionCache;
import org.eclipse.jetty.session.SessionCacheFactory;
import org.eclipse.jetty.session.SessionConfig;
import org.eclipse.jetty.session.SessionContext;
import org.eclipse.jetty.session.SessionDataStore;
import org.eclipse.jetty.session.SessionDataStoreFactory;
import org.eclipse.jetty.session.SessionIdManager;
import org.eclipse.jetty.session.SessionInactivityTimer;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.session.UnreadableSessionDataException;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionManager
extends ContainerLifeCycle
implements SessionManager,
SessionConfig.Mutable {
    static final Logger LOG = LoggerFactory.getLogger(AbstractSessionManager.class);
    private final Set<String> _candidateSessionIdsForExpiry = ConcurrentHashMap.newKeySet();
    private final SampleStatistic _sessionTimeStats = new SampleStatistic();
    private final CounterStatistic _sessionsCreatedStats = new CounterStatistic();
    private int _dftMaxIdleSecs = -1;
    private boolean _usingUriParameters;
    private boolean _usingCookies = true;
    private SessionIdManager _sessionIdManager;
    private ClassLoader _loader;
    private Context _context;
    private SessionContext _sessionContext;
    private SessionCache _sessionCache;
    private Scheduler _scheduler;
    private boolean _ownScheduler = false;
    private String _sessionCookie;
    private String _sessionIdPathParameterName;
    private String _sessionIdPathParameterNamePrefix;
    private final Map<String, String> _sessionCookieAttributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, String> _sessionCookieSecureAttributes;
    private boolean _secureRequestOnly = true;
    private int _refreshCookieAge;
    private boolean _checkingRemoteSessionIdEncoding;
    private List<Session.LifeCycleListener> _sessionLifeCycleListeners = Collections.emptyList();
    private static final RequestedSession NO_REQUESTED_SESSION = new RequestedSession(null, null, false);

    public HttpCookie access(ManagedSession session, boolean secure) {
        if (session == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        if (session.access(now) && this.isUsingCookies() && (session.isSetCookieNeeded() || this.getMaxCookieAge() > 0 && this.getRefreshCookieAge() > 0 && (now - session.getCookieSetTime()) / 1000L > (long)this.getRefreshCookieAge())) {
            return this.getSessionCookie(session, secure);
        }
        return null;
    }

    @Override
    public long calculateInactivityTimeout(String id, long timeRemainingMs, long maxInactiveMs) {
        long time;
        int evictionPolicy = this._sessionCache.getEvictionPolicy();
        if (maxInactiveMs <= 0L) {
            if (evictionPolicy < 1) {
                time = -1L;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session {} is immortal && no inactivity eviction", (Object)id);
                }
            } else {
                time = TimeUnit.SECONDS.toMillis(evictionPolicy);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session {} is immortal; evict after {} sec inactivity", (Object)id, (Object)evictionPolicy);
                }
            }
        } else if (evictionPolicy == -1) {
            long l = time = timeRemainingMs > 0L ? timeRemainingMs : 0L;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} no eviction", (Object)id);
            }
        } else if (evictionPolicy == 0) {
            time = -1L;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} evict on exit", (Object)id);
            }
        } else {
            long l = time = timeRemainingMs > 0L ? Math.min(maxInactiveMs, TimeUnit.SECONDS.toMillis(evictionPolicy)) : 0L;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} timer set to lesser of maxInactive={} and inactivityEvict={}", id, maxInactiveMs, evictionPolicy);
            }
        }
        return time;
    }

    @Override
    public void commit(ManagedSession session) {
        if (session == null) {
            return;
        }
        try {
            this._sessionCache.commit(session);
        }
        catch (Exception e) {
            LOG.warn("Unable to commit Session {}", (Object)session, (Object)e);
        }
    }

    @Override
    public void complete(ManagedSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Complete called with session {}", (Object)session);
        }
        if (session == null) {
            return;
        }
        try {
            this._sessionCache.release(session);
        }
        catch (Exception e) {
            LOG.warn("Unable to release Session {}", (Object)session, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStart() throws Exception {
        String contextPath;
        Server server = this.getServer();
        this._context = ContextHandler.getCurrentContext(server);
        this._loader = Thread.currentThread().getContextClassLoader();
        if (this.getSessionCookie() == null) {
            this.setSessionCookie("JSESSIONID");
        }
        if (this.getSessionIdPathParameterName() == null) {
            this.setSessionIdPathParameterName("jsessionid");
        }
        String string = contextPath = this._context == null ? "/" : this._context.getContextPath();
        if (this.getSessionPath() == null) {
            this.setSessionPath(contextPath);
        }
        Server server2 = server;
        synchronized (server2) {
            if (this._sessionCache == null) {
                SessionCacheFactory ssFactory = server.getBean(SessionCacheFactory.class);
                this.setSessionCache(ssFactory != null ? ssFactory.getSessionCache(this) : new DefaultSessionCache(this));
                SessionDataStoreFactory sdsFactory = server.getBean(SessionDataStoreFactory.class);
                SessionDataStore sds = sdsFactory != null ? sdsFactory.getSessionDataStore(this) : new NullSessionDataStore();
                this._sessionCache.setSessionDataStore(sds);
            }
            if (this._sessionIdManager == null) {
                this._sessionIdManager = server.getBean(SessionIdManager.class);
                if (this._sessionIdManager == null) {
                    ClassLoader serverLoader = server.getClass().getClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(serverLoader);
                        this._sessionIdManager = new DefaultSessionIdManager(server);
                        server.addBean(this._sessionIdManager, true);
                        this._sessionIdManager.start();
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(this._loader);
                    }
                }
                this.addBean(this._sessionIdManager, false);
            }
            this._scheduler = server.getScheduler();
            if (this._scheduler == null) {
                this._scheduler = new ScheduledExecutorScheduler(String.format("Session-Scheduler-%x", this.hashCode()), false);
                this._ownScheduler = true;
                this._scheduler.start();
            }
        }
        this._sessionContext = new SessionContext(this);
        this._sessionCache.initialize(this._sessionContext);
        this.secureRequestOnlyAttributes();
        super.doStart();
        if (this._context != null) {
            this._sessionLifeCycleListeners = this._context.getAttributeNameSet().stream().map(this._context::getAttribute).filter(Session.LifeCycleListener.class::isInstance).map(Session.LifeCycleListener.class::cast).toList();
            this.addBean(this._sessionLifeCycleListeners);
        }
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    @Override
    public int getMaxCookieAge() {
        String mca = this._sessionCookieAttributes.get("Max-Age");
        return mca == null ? -1 : Integer.parseInt(mca);
    }

    @Override
    public void setMaxCookieAge(int maxCookieAge) {
        this._sessionCookieAttributes.put("Max-Age", Integer.toString(maxCookieAge));
        this.secureRequestOnlyAttributes();
    }

    @Override
    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    @Override
    public void setMaxInactiveInterval(int seconds) {
        this._dftMaxIdleSecs = seconds;
        if (LOG.isDebugEnabled()) {
            if (this._dftMaxIdleSecs <= 0) {
                LOG.debug("Sessions created by this manager are immortal (default maxInactiveInterval={})", (Object)this._dftMaxIdleSecs);
            } else {
                LOG.debug("SessionManager default maxInactiveInterval={}", (Object)this._dftMaxIdleSecs);
            }
        }
    }

    @Override
    public int getRefreshCookieAge() {
        return this._refreshCookieAge;
    }

    @Override
    public void setRefreshCookieAge(int ageInSeconds) {
        this._refreshCookieAge = ageInSeconds;
    }

    public abstract Server getServer();

    @Override
    public ManagedSession getManagedSession(String extendedId) {
        String id = this.getSessionIdManager().getId(extendedId);
        try {
            ManagedSession session = this._sessionCache.get(id);
            if (session != null) {
                if (session.isExpiredAt(System.currentTimeMillis())) {
                    block10: {
                        try {
                            session.invalidate();
                        }
                        catch (Exception e) {
                            if (!LOG.isDebugEnabled()) break block10;
                            LOG.warn("Invalidating session {} found to be expired when requested", (Object)id, (Object)e);
                        }
                    }
                    return null;
                }
                session.setExtendedId(this._sessionIdManager.getExtendedId(id, null));
            }
            if (session != null && !session.getExtendedId().equals(extendedId)) {
                session.onIdChanged();
            }
            return session;
        }
        catch (UnreadableSessionDataException e) {
            LOG.warn("Error loading session {}", (Object)id, (Object)e);
            try {
                this.getSessionIdManager().invalidateAll(id);
            }
            catch (Exception x) {
                LOG.warn("Error cross-context invalidating unreadable session {}", (Object)id, (Object)x);
            }
            return null;
        }
        catch (Exception other) {
            LOG.warn("Unable to get Session", other);
            return null;
        }
    }

    @Override
    public SessionCache getSessionCache() {
        return this._sessionCache;
    }

    @Override
    public void setSessionCache(SessionCache cache) {
        this.updateBean(this._sessionCache, cache);
        this._sessionCache = cache;
    }

    @Override
    public String getSessionComment() {
        return this._sessionCookieAttributes.get("Comment");
    }

    @Override
    public void setSessionComment(String sessionComment) {
        this._sessionCookieAttributes.put("Comment", sessionComment);
        this.secureRequestOnlyAttributes();
    }

    @Override
    public HttpCookie.SameSite getSameSite() {
        return HttpCookie.SameSite.from(this._sessionCookieAttributes.get("SameSite"));
    }

    @Override
    public void setSameSite(HttpCookie.SameSite sessionSameSite) {
        this._sessionCookieAttributes.put("SameSite", sessionSameSite.getAttributeValue());
        this.secureRequestOnlyAttributes();
    }

    public SessionContext getSessionContext() {
        return this._sessionContext;
    }

    @Override
    public String getSessionCookie() {
        return this._sessionCookie;
    }

    @Override
    public void setSessionCookie(String cookieName) {
        if (StringUtil.isBlank(cookieName)) {
            throw new IllegalArgumentException("Blank cookie name");
        }
        Syntax.requireValidRFC2616Token(cookieName, "Bad Session cookie name");
        this._sessionCookie = cookieName;
    }

    @Override
    public String getSessionDomain() {
        return this._sessionCookieAttributes.get("Domain");
    }

    @Override
    public void setSessionDomain(String domain) {
        this._sessionCookieAttributes.put("Domain", domain);
        this.secureRequestOnlyAttributes();
    }

    public void setSessionCookieAttribute(String name, String value) {
        this._sessionCookieAttributes.put(name, value);
        this.secureRequestOnlyAttributes();
    }

    public String getSessionCookieAttribute(String name) {
        return this._sessionCookieAttributes.get(name);
    }

    public Map<String, String> getSessionCookieAttributes() {
        return Collections.unmodifiableMap(this._sessionCookieAttributes);
    }

    @Override
    public SessionIdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    @Override
    public void setSessionIdManager(SessionIdManager sessionIdManager) {
        this.updateBean(this._sessionIdManager, sessionIdManager);
        this._sessionIdManager = sessionIdManager;
    }

    @Override
    public String getSessionIdPathParameterName() {
        return this._sessionIdPathParameterName;
    }

    @Override
    public void setSessionIdPathParameterName(String param) {
        this._sessionIdPathParameterName = param == null || "none".equals(param) ? null : param;
        this._sessionIdPathParameterNamePrefix = param == null || "none".equals(param) ? null : ";" + this._sessionIdPathParameterName + "=";
    }

    @Override
    public String getSessionIdPathParameterNamePrefix() {
        return this._sessionIdPathParameterNamePrefix;
    }

    @Override
    public String getSessionPath() {
        return this._sessionCookieAttributes.get("Path");
    }

    @Override
    public void setSessionPath(String sessionPath) {
        this._sessionCookieAttributes.put("Path", sessionPath);
        this.secureRequestOnlyAttributes();
    }

    @Override
    @ManagedAttribute(value="mean time sessions remain valid (in s)")
    public double getSessionTimeMean() {
        return this._sessionTimeStats.getMean();
    }

    @Override
    @ManagedAttribute(value="standard deviation a session remained valid (in s)")
    public double getSessionTimeStdDev() {
        return this._sessionTimeStats.getStdDev();
    }

    @Override
    @ManagedAttribute(value="total time sessions have remained valid")
    public long getSessionTimeTotal() {
        return this._sessionTimeStats.getTotal();
    }

    @Override
    @ManagedAttribute(value="number of sessions created by this context")
    public int getSessionsCreated() {
        return (int)this._sessionsCreatedStats.getCurrent();
    }

    @Override
    public String encodeURI(Request request, String uri, boolean cookiesInUse) {
        int prefix;
        String sessionURLPrefix;
        HttpURI.Immutable httpURI = null;
        if (this.isCheckingRemoteSessionIdEncoding() && URIUtil.hasScheme(uri)) {
            httpURI = HttpURI.from(uri);
            String path = httpURI.getPath();
            path = path == null ? "" : path;
            int port = httpURI.getPort();
            if (port < 0) {
                port = HttpScheme.getDefaultPort(httpURI.getScheme());
            }
            if (!Request.getServerName(request).equalsIgnoreCase(httpURI.getHost())) {
                return uri;
            }
            if (Request.getServerPort(request) != port) {
                return uri;
            }
            if (request.getContext() != null && !path.startsWith(request.getContext().getContextPath())) {
                return uri;
            }
        }
        if ((sessionURLPrefix = this.getSessionIdPathParameterNamePrefix()) == null) {
            return uri;
        }
        if (uri == null) {
            return null;
        }
        if (this.isUsingCookies() && cookiesInUse || !this.isUsingUriParameters()) {
            int prefix2 = uri.indexOf(sessionURLPrefix);
            if (prefix2 != -1) {
                int suffix = uri.indexOf("?", prefix2);
                if (suffix < 0) {
                    suffix = uri.indexOf("#", prefix2);
                }
                if (suffix <= prefix2) {
                    return uri.substring(0, prefix2);
                }
                return uri.substring(0, prefix2) + uri.substring(suffix);
            }
            return uri;
        }
        Session session = request.getSession(false);
        if (session == null || !session.isValid()) {
            return uri;
        }
        String id = session.getExtendedId();
        if (httpURI == null) {
            httpURI = HttpURI.from(uri);
        }
        if ((prefix = uri.indexOf(sessionURLPrefix)) != -1) {
            int suffix = uri.indexOf("?", prefix);
            if (suffix < 0) {
                suffix = uri.indexOf("#", prefix);
            }
            if (suffix <= prefix) {
                return uri.substring(0, prefix + sessionURLPrefix.length()) + id;
            }
            return uri.substring(0, prefix + sessionURLPrefix.length()) + id + uri.substring(suffix);
        }
        int suffix = uri.indexOf(63);
        if (suffix < 0) {
            suffix = uri.indexOf(35);
        }
        if (suffix < 0) {
            return uri + ((HttpScheme.HTTPS.is(httpURI.getScheme()) || HttpScheme.HTTP.is(httpURI.getScheme())) && httpURI.getPath() == null ? "/" : "") + sessionURLPrefix + id;
        }
        return uri.substring(0, suffix) + ((HttpScheme.HTTPS.is(httpURI.getScheme()) || HttpScheme.HTTP.is(httpURI.getScheme())) && httpURI.getPath() == null ? "/" : "") + sessionURLPrefix + id + uri.substring(suffix);
    }

    @Override
    public void onSessionIdChanged(Session session, String oldId) {
        for (Session.LifeCycleListener listener : this._sessionLifeCycleListeners) {
            listener.onSessionIdChanged(session, oldId);
        }
    }

    @Override
    public void onSessionCreated(Session session) {
        for (Session.LifeCycleListener listener : this._sessionLifeCycleListeners) {
            listener.onSessionCreated(session);
        }
    }

    @Override
    public void onSessionDestroyed(Session session) {
        for (Session.LifeCycleListener listener : this._sessionLifeCycleListeners) {
            listener.onSessionDestroyed(session);
        }
    }

    @Override
    public void invalidate(String id) throws Exception {
        block8: {
            if (StringUtil.isBlank(id)) {
                return;
            }
            try {
                ManagedSession session = this._sessionCache.delete(id);
                if (session == null) break block8;
                try {
                    if (!session.beginInvalidate()) break block8;
                    try {
                        this.onSessionDestroyed(session);
                    }
                    catch (Exception e) {
                        LOG.warn("Error during Session destroy listener", e);
                    }
                    session.finishInvalidate();
                }
                catch (IllegalStateException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Session {} already invalid", (Object)session, (Object)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to delete Session {}", (Object)id, (Object)e);
            }
        }
    }

    @Override
    public boolean isCheckingRemoteSessionIdEncoding() {
        return this._checkingRemoteSessionIdEncoding;
    }

    @Override
    public void setCheckingRemoteSessionIdEncoding(boolean remote) {
        this._checkingRemoteSessionIdEncoding = remote;
    }

    @Override
    public boolean isHttpOnly() {
        return Boolean.parseBoolean(this._sessionCookieAttributes.get("HttpOnly"));
    }

    @Override
    public void setHttpOnly(boolean httpOnly) {
        this._sessionCookieAttributes.put("HttpOnly", Boolean.toString(httpOnly));
    }

    @Override
    public boolean isPartitioned() {
        return Boolean.parseBoolean(this._sessionCookieAttributes.get("Partitioned"));
    }

    @Override
    public void setPartitioned(boolean partitioned) {
        this._sessionCookieAttributes.put("Partitioned", Boolean.toString(partitioned));
    }

    @Override
    public boolean isIdInUse(String id) throws Exception {
        return this._sessionCache.exists(id);
    }

    @Override
    public boolean isSecureCookies() {
        return Boolean.parseBoolean(this._sessionCookieAttributes.get("Secure"));
    }

    @Override
    public void setSecureCookies(boolean secure) {
        this._sessionCookieAttributes.put("Secure", Boolean.toString(secure));
        this.secureRequestOnlyAttributes();
    }

    @Override
    public boolean isSecureRequestOnly() {
        return this._secureRequestOnly;
    }

    @Override
    public void setSecureRequestOnly(boolean secureRequestOnly) {
        this._secureRequestOnly = secureRequestOnly;
        this.secureRequestOnlyAttributes();
    }

    private void secureRequestOnlyAttributes() {
        if (this.isSecureRequestOnly() && !Boolean.parseBoolean(this._sessionCookieAttributes.get("Secure"))) {
            TreeMap<String, String> attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            attributes.putAll(this._sessionCookieAttributes);
            attributes.put("Secure", Boolean.TRUE.toString());
            this._sessionCookieSecureAttributes = attributes;
        } else {
            this._sessionCookieSecureAttributes = this._sessionCookieAttributes;
        }
    }

    @Override
    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    @Override
    public void setUsingCookies(boolean usingCookies) {
        this._usingCookies = usingCookies;
    }

    @Override
    public boolean isUsingUriParameters() {
        return this._usingUriParameters;
    }

    @Override
    public void setUsingUriParameters(boolean usingUriParameters) {
        this._usingUriParameters = usingUriParameters;
    }

    @Deprecated(since="12.0.1", forRemoval=true)
    public boolean isUsingURLs() {
        return this.isUsingUriParameters();
    }

    @Deprecated(since="12.0.1", forRemoval=true)
    public void setUsingURLs(boolean usingURLs) {
        this.setUsingUriParameters(usingURLs);
    }

    @Override
    public void newSession(Request request, String requestedSessionId, Consumer<ManagedSession> consumer) {
        long created = System.currentTimeMillis();
        String id = this._sessionIdManager.newSessionId(request, requestedSessionId, created);
        ManagedSession session = this._sessionCache.newSession(id, created, this._dftMaxIdleSecs > 0 ? (long)this._dftMaxIdleSecs * 1000L : -1L);
        session.setExtendedId(this._sessionIdManager.getExtendedId(id, request));
        session.getSessionData().setLastNode(this._sessionIdManager.getWorkerName());
        try {
            this._sessionCache.add(id, session);
            this._sessionsCreatedStats.increment();
            if (request != null && request.getConnectionMetaData().isSecure()) {
                session.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", Boolean.TRUE);
            }
            consumer.accept(session);
            this.onSessionCreated(session);
        }
        catch (Exception e) {
            LOG.warn("Unable to add Session {}", (Object)id, (Object)e);
        }
    }

    @Override
    public SessionInactivityTimer newSessionInactivityTimer(ManagedSession session) {
        return new SessionInactivityTimer(this, session, this._scheduler);
    }

    @Override
    public void recordSessionTime(ManagedSession session) {
        this._sessionTimeStats.record(Math.round((double)(System.currentTimeMillis() - session.getSessionData().getCreated()) / 1000.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renewSessionId(String oldId, String oldExtendedId, String newId, String newExtendedId) {
        ManagedSession session = null;
        try {
            session = this._sessionCache.renewSessionId(oldId, newId, oldExtendedId, newExtendedId);
            if (session == null) {
                return;
            }
            this.onSessionIdChanged(session, oldId);
        }
        catch (Exception e) {
            LOG.warn("Unable to renew Session Id {}:{} -> {}:{}", oldId, oldExtendedId, newId, newExtendedId, e);
        }
        finally {
            if (session != null) {
                try {
                    this._sessionCache.release(session);
                }
                catch (Exception e) {
                    LOG.warn("Unable to release {}", (Object)newId, (Object)e);
                }
            }
        }
    }

    @Override
    public void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} scavenging sessions", (Object)this);
        }
        String[] ss = this._candidateSessionIdsForExpiry.toArray(new String[0]);
        Set<String> candidates = new HashSet<String>(Arrays.asList(ss));
        this._candidateSessionIdsForExpiry.removeAll(candidates);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} scavenging session ids {}", (Object)this, (Object)candidates);
        }
        try {
            candidates = this._sessionCache.checkExpiration(candidates);
            for (String id : candidates) {
                try {
                    this.getSessionIdManager().expireAll(id);
                }
                catch (Exception e) {
                    LOG.warn("Unable to expire Session {}", (Object)id, (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to check expiration on {}", (Object)candidates.stream().map(Objects::toString).collect(Collectors.joining(", ", "[", "]")), (Object)e);
        }
    }

    @Override
    public void sessionTimerExpired(ManagedSession session, long now) {
        if (session == null) {
            return;
        }
        try (AutoLock ignored = session.lock();){
            if (session.isExpiredAt(now)) {
                if (this._sessionIdManager.getSessionHouseKeeper() != null && this._sessionIdManager.getSessionHouseKeeper().getIntervalSec() > 0L) {
                    this._candidateSessionIdsForExpiry.add(session.getId());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Session {} is candidate for expiry", (Object)session.getId());
                    }
                }
            } else {
                this._sessionCache.checkInactiveSession(session);
            }
        }
    }

    protected void addSessionStreamWrapper(Request request) {
        request.addHttpStreamWrapper(s -> new SessionStreamWrapper((HttpStream)s, this, request));
    }

    @Override
    protected void doStop() throws Exception {
        this.shutdownSessions();
        this._sessionCache.stop();
        if (this._ownScheduler && this._scheduler != null) {
            this._scheduler.stop();
        }
        this._scheduler = null;
        super.doStop();
        this._loader = null;
        this.removeBean(this._sessionLifeCycleListeners);
        this._sessionLifeCycleListeners = Collections.emptyList();
    }

    protected RequestedSession resolveRequestedSessionId(Request request) {
        HttpURI uri;
        String param;
        int cookieIds;
        List<HttpCookie> cookies;
        String requestedSessionId = null;
        boolean requestedSessionIdFromCookie = false;
        ManagedSession session = null;
        ArrayList<String> ids = null;
        if (this.isUsingCookies() && (cookies = Request.getCookies(request)) != null && cookies.size() > 0) {
            String sessionCookie = this.getSessionCookie();
            for (HttpCookie cookie : cookies) {
                if (!sessionCookie.equalsIgnoreCase(cookie.getName())) continue;
                if (ids == null) {
                    ids = new ArrayList<String>();
                }
                ids.add(cookie.getValue());
            }
        }
        int n = cookieIds = ids == null ? 0 : ids.size();
        if (this.isUsingUriParameters() && StringUtil.isNotBlank(param = (uri = request.getHttpURI()).getParam())) {
            String[] params;
            String name = this.getSessionIdPathParameterName();
            for (String p : params = param.split(";")) {
                if (!p.startsWith(name) || p.length() <= name.length() || p.charAt(name.length()) != '=') continue;
                if (ids == null) {
                    ids = new ArrayList();
                }
                ids.add(p.substring(name.length() + 1).trim());
            }
        }
        if (ids == null) {
            return NO_REQUESTED_SESSION;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got Session IDs {} from cookies {}", (Object)ids, (Object)cookieIds);
        }
        for (int i = 0; i < ids.size(); ++i) {
            ManagedSession s;
            String id = (String)ids.get(i);
            if (session == null) {
                s = this.getManagedSession(id);
                if (s != null && s.isValid()) {
                    requestedSessionId = id;
                    requestedSessionIdFromCookie = i < cookieIds;
                    session = s;
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Selected session {}", (Object)session);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No session found for session id {}", (Object)id);
                }
                if (requestedSessionId != null) continue;
                requestedSessionId = id;
                requestedSessionIdFromCookie = i < cookieIds;
                continue;
            }
            if (session.getId().equals(this.getSessionIdManager().getId(id))) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(AbstractSessionManager.duplicateSession(requestedSessionId, true, requestedSessionIdFromCookie, id, false, i < cookieIds));
                continue;
            }
            s = this.getManagedSession(id);
            if (s != null && s.isValid()) {
                block19: {
                    block18: {
                        try {
                            this._sessionCache.release(session);
                        }
                        catch (Exception x) {
                            if (!LOG.isDebugEnabled()) break block18;
                            LOG.debug("Error releasing duplicate valid session: {}", (Object)requestedSessionId);
                        }
                    }
                    try {
                        this._sessionCache.release(s);
                    }
                    catch (Exception x) {
                        if (!LOG.isDebugEnabled()) break block19;
                        LOG.debug("Error releasing duplicate valid session: {}", (Object)id);
                    }
                }
                throw new BadMessageException(AbstractSessionManager.duplicateSession(requestedSessionId, true, requestedSessionIdFromCookie, id, true, i < cookieIds));
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(AbstractSessionManager.duplicateSession(requestedSessionId, true, requestedSessionIdFromCookie, id, false, i < cookieIds));
        }
        return new RequestedSession(session != null && session.isValid() ? session : null, requestedSessionId, requestedSessionIdFromCookie);
    }

    private static String duplicateSession(String id0, boolean valid0, boolean cookie0, String id1, boolean valid1, boolean cookie1) {
        return "Duplicate sessions: %s[%s,%s] & %s[%s,%s]".formatted(id0, valid0 ? "valid" : "unknown", cookie0 ? "cookie" : "param", id1, valid1 ? "valid" : "unknown", cookie1 ? "cookie" : "param");
    }

    private void shutdownSessions() {
        this._sessionCache.shutdown();
    }

    @Override
    public HttpCookie getSessionCookie(ManagedSession session, boolean requestIsSecure) {
        if (this.isUsingCookies()) {
            String name = this.getSessionCookie();
            if (name == null) {
                name = this._sessionCookieAttributes.get("name");
            }
            if (name == null) {
                name = "JSESSIONID";
            }
            if (this.isSecureRequestOnly() && requestIsSecure && this._sessionCookieSecureAttributes != null && this._sessionCookieAttributes != this._sessionCookieSecureAttributes) {
                return session.generateSetCookie(name, this._sessionCookieSecureAttributes);
            }
            return session.generateSetCookie(name, this._sessionCookieAttributes);
        }
        return null;
    }

    public record RequestedSession(ManagedSession session, String sessionId, boolean sessionIdFromCookie) {
    }

    private class SessionStreamWrapper
    extends HttpStream.Wrapper {
        private final SessionManager _sessionManager;
        private final Request _request;
        private final Context _context;

        public SessionStreamWrapper(HttpStream wrapped, SessionManager sessionManager, Request request) {
            super(wrapped);
            this._sessionManager = sessionManager;
            this._request = request;
            this._context = this._request.getContext();
        }

        @Override
        public void failed(Throwable x) {
            this._context.run(this::doComplete, this._request);
            super.failed(x);
        }

        @Override
        public void send(MetaData.Request metadataRequest, MetaData.Response metadataResponse, boolean last, ByteBuffer content, Callback callback) {
            if (metadataResponse != null) {
                this._context.run(this::doCommit, this._request);
            }
            super.send(metadataRequest, metadataResponse, last, content, callback);
        }

        @Override
        public void succeeded() {
            this._context.run(this::doComplete, this._request);
            super.succeeded();
        }

        private void doCommit() {
            AbstractSessionManager.this.commit(this._sessionManager.getManagedSession(this._request));
        }

        private void doComplete() {
            AbstractSessionManager.this.complete(this._sessionManager.getManagedSession(this._request));
        }
    }
}

