/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.UnavailableException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.ee10.servlet.AsyncContextEvent;
import org.eclipse.jetty.ee10.servlet.AsyncContextState;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletChannel;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletChannelState {
    private static final Logger LOG = LoggerFactory.getLogger(ServletChannelState.class);
    private static final long DEFAULT_TIMEOUT = Long.getLong("%s.DEFAULT_TIMEOUT".formatted(ServletChannelState.class.getName()), 30000L);
    private final AutoLock _lock = new AutoLock();
    private final ServletChannel _servletChannel;
    private List<AsyncListener> _asyncListeners;
    private State _state = State.IDLE;
    private RequestState _requestState = RequestState.BLOCKING;
    private OutputState _outputState = OutputState.IDLE;
    private InputState _inputState = InputState.IDLE;
    private boolean _initial = true;
    private boolean _sendError;
    private boolean _asyncWritePossible;
    private long _timeoutMs = DEFAULT_TIMEOUT;
    private AsyncContextEvent _event;
    private Thread _onTimeoutThread;
    private Throwable _failure;
    private boolean _failureListener;

    protected ServletChannelState(ServletChannel servletChannel) {
        this._servletChannel = servletChannel;
    }

    public ServletChannel getServletChannel() {
        return this._servletChannel;
    }

    public boolean isAborted() {
        try (AutoLock ignored = this.lock();){
            boolean bl = this._outputState == OutputState.ABORTED;
            return bl;
        }
    }

    public void openOutput() {
        try (AutoLock ignored = this.lock();){
            if (this._outputState != OutputState.IDLE) {
                throw new IllegalStateException(this.toStringLocked());
            }
            this._outputState = OutputState.OPEN;
        }
    }

    AutoLock lock() {
        return this._lock.lock();
    }

    public State getState() {
        try (AutoLock ignored = this.lock();){
            State state = this._state;
            return state;
        }
    }

    public void addListener(AsyncListener listener) {
        try (AutoLock ignored = this.lock();){
            if (this._asyncListeners == null) {
                this._asyncListeners = new ArrayList<AsyncListener>();
            }
            this._asyncListeners.add(listener);
        }
    }

    public boolean hasListener(AsyncListener listener) {
        try (AutoLock ignored = this.lock();){
            if (this._asyncListeners == null) {
                boolean bl = false;
                return bl;
            }
            for (AsyncListener l : this._asyncListeners) {
                if (l == listener) {
                    boolean bl = true;
                    return bl;
                }
                if (!(l instanceof AsyncContextState.WrappedAsyncListener) || ((AsyncContextState.WrappedAsyncListener)l).getListener() != listener) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean isSendError() {
        try (AutoLock ignored = this.lock();){
            boolean bl = this._sendError;
            return bl;
        }
    }

    public void setTimeout(long ms) {
        try (AutoLock ignored = this.lock();){
            this._timeoutMs = ms;
        }
    }

    public long getTimeout() {
        try (AutoLock ignored = this.lock();){
            long l = this._timeoutMs;
            return l;
        }
    }

    public AsyncContextEvent getAsyncContextEvent() {
        try (AutoLock ignored = this.lock();){
            AsyncContextEvent asyncContextEvent = this._event;
            return asyncContextEvent;
        }
    }

    public String toString() {
        try (AutoLock ignored = this.lock();){
            String string = this.toStringLocked();
            return string;
        }
    }

    private String toStringLocked() {
        return String.format("%s@%x{%s}", this.getClass().getSimpleName(), this.hashCode(), this.getStatusStringLocked());
    }

    private String getStatusStringLocked() {
        return String.format("s=%s rs=%s os=%s is=%s awp=%b se=%b i=%b al=%d", new Object[]{this._state, this._requestState, this._outputState, this._inputState, this._asyncWritePossible, this._sendError, this._initial, this._asyncListeners == null ? 0 : this._asyncListeners.size()});
    }

    public String getStatusString() {
        try (AutoLock ignored = this.lock();){
            String string = this.getStatusStringLocked();
            return string;
        }
    }

    public Throwable completeResponse() {
        try (AutoLock ignored = this.lock();){
            assert (this._outputState == OutputState.OPEN || this._failure != null);
            if (this._outputState == OutputState.OPEN) {
                this._outputState = OutputState.COMPLETED;
            }
            Throwable throwable = this._failure;
            return throwable;
        }
    }

    public boolean isResponseCommitted() {
        return this._servletChannel.getServletContextResponse().isCommitted();
    }

    public boolean isResponseCompleted() {
        try (AutoLock ignored = this.lock();){
            boolean bl = this._outputState == OutputState.COMPLETED;
            return bl;
        }
    }

    private boolean abortResponse(Throwable failure) {
        try (AutoLock ignored = this.lock();){
            switch (this._outputState.ordinal()) {
                case 2: 
                case 3: {
                    boolean bl = false;
                    return bl;
                }
            }
            this._outputState = OutputState.ABORTED;
            this._failure = failure;
            boolean bl = true;
            return bl;
        }
    }

    public void abort(Throwable failure) {
        boolean handle = false;
        try (AutoLock ignored = this.lock();){
            boolean aborted = this.abortResponse(failure);
            if (LOG.isDebugEnabled()) {
                LOG.debug("abort={} {}", aborted, this, failure);
            }
            if (aborted) {
                boolean bl = handle = this._state == State.WAITING;
                if (handle) {
                    this._state = State.WOKEN;
                }
                this._requestState = RequestState.COMPLETED;
            }
        }
        if (handle) {
            this.scheduleDispatch();
        }
    }

    public Action handling() {
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("handling {}", (Object)this.toStringLocked());
            }
            switch (this._state.ordinal()) {
                case 0: {
                    if (this._requestState != RequestState.BLOCKING) {
                        throw new IllegalStateException(this.getStatusStringLocked());
                    }
                    this._initial = true;
                    this._state = State.HANDLING;
                    Action action = Action.DISPATCH;
                    return action;
                }
                case 3: {
                    if (this._event != null && this._event.getThrowable() != null && !this._sendError) {
                        this._state = State.HANDLING;
                        Action action = Action.ASYNC_ERROR;
                        return action;
                    }
                    Action action = this.nextAction(true);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("nextAction(true) {} {}", (Object)action, (Object)this.toStringLocked());
                    }
                    Action action2 = action;
                    return action2;
                }
            }
            throw new IllegalStateException(this.getStatusStringLocked());
        }
    }

    protected Action unhandle() {
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("unhandle {}", (Object)this.toStringLocked());
            }
            if (this._state != State.HANDLING) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            this._initial = false;
            Action action = this.nextAction(false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("nextAction(false) {} {}", (Object)action, (Object)this.toStringLocked());
            }
            Action action2 = action;
            return action2;
        }
    }

    private Action nextAction(boolean handling) {
        this._state = State.HANDLING;
        if (this._sendError) {
            switch (this._requestState.ordinal()) {
                case 0: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    this._requestState = RequestState.BLOCKING;
                    this._sendError = false;
                    return Action.SEND_ERROR;
                }
            }
        }
        switch (this._requestState.ordinal()) {
            case 0: {
                if (handling) {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
                this._requestState = RequestState.COMPLETING;
                return Action.COMPLETE;
            }
            case 2: {
                switch (this._inputState.ordinal()) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        this._inputState = InputState.IDLE;
                        return Action.READ_CALLBACK;
                    }
                    default: {
                        throw new IllegalStateException(this.getStatusStringLocked());
                    }
                }
                if (this._asyncWritePossible) {
                    this._asyncWritePossible = false;
                    return Action.WRITE_CALLBACK;
                }
                Scheduler scheduler = this._servletChannel.getServletContextRequest().getConnectionMetaData().getConnector().getScheduler();
                if (scheduler != null && this._timeoutMs > 0L && !this._event.hasTimeoutTask()) {
                    this._event.setTimeoutTask(scheduler.schedule(this._event, this._timeoutMs, TimeUnit.MILLISECONDS));
                }
                this._state = State.WAITING;
                return Action.WAIT;
            }
            case 3: {
                this._requestState = RequestState.BLOCKING;
                return Action.ASYNC_DISPATCH;
            }
            case 4: {
                this._requestState = RequestState.EXPIRING;
                return Action.ASYNC_TIMEOUT;
            }
            case 5: {
                if (handling) {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
                this.sendError(500, "AsyncContext timeout");
                this._requestState = RequestState.BLOCKING;
                this._sendError = false;
                return Action.SEND_ERROR;
            }
            case 6: {
                this._requestState = RequestState.COMPLETING;
                return Action.COMPLETE;
            }
            case 1: 
            case 7: {
                this._state = State.WAITING;
                return Action.WAIT;
            }
            case 8: {
                this._state = State.IDLE;
                return Action.TERMINATED;
            }
        }
        throw new IllegalStateException(this.getStatusStringLocked());
    }

    public void startAsync(final AsyncContextEvent event) {
        List<AsyncListener> lastAsyncListeners;
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("startAsync {}", (Object)this.toStringLocked());
            }
            if (this._state != State.HANDLING || this._requestState != RequestState.BLOCKING && this._requestState != RequestState.ERRORING) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            if (!this._failureListener) {
                this._failureListener = true;
                this._servletChannel.getRequest().addFailureListener(this::asyncError);
            }
            this._requestState = RequestState.ASYNC;
            this._event = event;
            lastAsyncListeners = this._asyncListeners;
            this._asyncListeners = null;
        }
        if (lastAsyncListeners != null) {
            Runnable callback = new Runnable(){

                @Override
                public void run() {
                    for (AsyncListener listener : lastAsyncListeners) {
                        try {
                            listener.onStartAsync(event);
                        }
                        catch (Throwable e) {
                            LOG.warn("Async dispatch error", e);
                        }
                    }
                }

                public String toString() {
                    return "startAsync";
                }
            };
            this.runInContext(event, callback);
        }
    }

    void errorHandling() {
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("errorHandling {}", (Object)this.toStringLocked());
            }
            this._requestState = RequestState.ERRORING;
        }
    }

    void errorHandlingComplete(Throwable failure) {
        boolean handle;
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("errorHandlingComplete {}", (Object)this.toStringLocked(), (Object)failure);
            }
            boolean bl = handle = this._state == State.WAITING;
            if (handle) {
                this._state = State.WOKEN;
            }
            if (failure != null) {
                this.abortResponse(failure);
            }
            if (this._requestState == RequestState.ERRORING) {
                this._requestState = RequestState.COMPLETE;
            }
        }
        if (handle) {
            this.scheduleDispatch();
        }
    }

    public void dispatch(ServletContext context, String path) {
        AsyncContextEvent event;
        boolean dispatch = false;
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("dispatch {} -> {}", (Object)this.toStringLocked(), (Object)path);
            }
            switch (this._requestState.ordinal()) {
                case 2: {
                    break;
                }
                case 5: {
                    if (Thread.currentThread() == this._onTimeoutThread) break;
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            if (context != null) {
                this._event.setDispatchContext(context);
            }
            if (path != null) {
                this._event.setDispatchPath(path);
            }
            if (this._requestState == RequestState.ASYNC && this._state == State.WAITING) {
                this._state = State.WOKEN;
                dispatch = true;
            }
            this._requestState = RequestState.DISPATCH;
            event = this._event;
        }
        this.cancelTimeout(event);
        if (dispatch) {
            this.scheduleDispatch();
        }
    }

    protected void timeout() {
        boolean dispatch = false;
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("Timeout {}", (Object)this.toStringLocked());
            }
            if (this._requestState != RequestState.ASYNC) {
                return;
            }
            this._requestState = RequestState.EXPIRE;
            if (this._state == State.WAITING) {
                this._state = State.WOKEN;
                dispatch = true;
            }
        }
        if (dispatch) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dispatch after async timeout {}", (Object)this);
            }
            this.scheduleDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTimeout() {
        List<AsyncListener> listeners;
        AsyncContextEvent event;
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onTimeout {}", (Object)this.toStringLocked());
            }
            if (this._requestState != RequestState.EXPIRING || this._state != State.HANDLING) {
                throw new IllegalStateException(this.toStringLocked());
            }
            event = this._event;
            listeners = this._asyncListeners;
            this._onTimeoutThread = Thread.currentThread();
        }
        try {
            if (listeners != null) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        for (AsyncListener listener : listeners) {
                            try {
                                listener.onTimeout(event);
                            }
                            catch (Throwable x) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.warn("{} while invoking onTimeout listener {}", x, listener, x);
                                    continue;
                                }
                                LOG.warn("{} while invoking onTimeout listener {}", (Object)x, (Object)listener);
                            }
                        }
                    }

                    public String toString() {
                        return "onTimeout";
                    }
                };
                this.runInContext(event, task);
            }
        }
        finally {
            ignored = this.lock();
            try {
                this._onTimeoutThread = null;
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
    }

    public void complete() {
        AsyncContextEvent event;
        boolean handle = false;
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("complete {}", (Object)this.toStringLocked());
            }
            event = this._event;
            switch (this._requestState.ordinal()) {
                case 5: {
                    if (Thread.currentThread() != this._onTimeoutThread) {
                        throw new IllegalStateException(this.getStatusStringLocked());
                    }
                    this._requestState = this._sendError ? RequestState.BLOCKING : RequestState.COMPLETE;
                    break;
                }
                case 2: {
                    this._requestState = this._sendError ? RequestState.BLOCKING : RequestState.COMPLETE;
                    break;
                }
                case 6: {
                    return;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            if (this._state == State.WAITING) {
                handle = true;
                this._state = State.WOKEN;
            }
        }
        this.cancelTimeout(event);
        if (handle) {
            this.runInContext(event, this._servletChannel::handle);
        }
    }

    public void asyncError(Throwable failure) {
        AsyncContextEvent event = null;
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("asyncError {}", (Object)this.toStringLocked(), (Object)failure);
            }
            if (this._state == State.WAITING && this._requestState == RequestState.ASYNC) {
                this._state = State.WOKEN;
                this._event.addThrowable(failure);
                event = this._event;
            } else {
                if (!QuietException.isQuiet(failure)) {
                    LOG.warn(failure.toString());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Async error", failure);
                }
            }
        }
        if (event != null) {
            this.cancelTimeout(event);
            this.runInContext(event, this._servletChannel::handle);
        }
    }

    public boolean onIdleTimeout(TimeoutException timeout) {
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onIdleTimeout {}", (Object)this.getStatusStringLocked(), (Object)timeout);
            }
            boolean bl = this._state == State.IDLE;
            return bl;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void onError(Throwable th) {
        ignored = this.lock();
        try {
            if (ServletChannelState.LOG.isDebugEnabled()) {
                ServletChannelState.LOG.debug("thrownException {}", (Object)this.getStatusStringLocked(), (Object)th);
            }
            if (this._state != State.HANDLING) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            if (this._sendError) {
                ServletChannelState.LOG.warn("unhandled due to prior sendError", th);
                return;
            }
            switch (this._requestState.ordinal()) {
                case 0: {
                    this.sendError(th);
                    return;
                }
                case 2: 
                case 3: 
                case 6: {
                    if (this._asyncListeners == null || this._asyncListeners.isEmpty()) {
                        this.sendError(th);
                        return;
                    }
                    asyncEvent = this._event;
                    asyncEvent.addThrowable(th);
                    asyncListeners = this._asyncListeners;
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                default: {
                    ServletChannelState.LOG.warn("unhandled in state {}", (Object)this._requestState, (Object)new IllegalStateException(th));
                    return;
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        this.runInContext(asyncEvent, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onError$0(java.util.List org.eclipse.jetty.ee10.servlet.AsyncContextEvent ), ()V)(asyncListeners, (AsyncContextEvent)asyncEvent));
        ignored = this.lock();
        try {
            if (this._requestState == RequestState.ASYNC && !this._sendError) {
                this.sendError(th);
            } else if (this._requestState != RequestState.COMPLETE) {
                if (QuietException.isQuiet(th)) {
                    ServletChannelState.LOG.debug("unhandled in state {}", (Object)this._requestState, (Object)th);
                } else {
                    ServletChannelState.LOG.warn("unhandled in state {}", (Object)this._requestState, (Object)new IllegalStateException(th));
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    private void sendError(Throwable th) {
        String message;
        int code;
        ServletContextRequest request = this._servletChannel.getServletContextRequest();
        Throwable cause = this._servletChannel.unwrap(th, HttpException.class, UnavailableException.class);
        if (cause == null) {
            code = 500;
            message = th.toString();
        } else if (cause instanceof HttpException) {
            HttpException httpException = (HttpException)((Object)cause);
            code = httpException.getCode();
            message = httpException.getReason();
        } else if (cause instanceof UnavailableException) {
            message = cause.toString();
            code = ((UnavailableException)cause).isPermanent() ? 404 : 503;
        } else {
            code = 500;
            message = null;
        }
        this.sendError(code, message);
        request.setAttribute("jakarta.servlet.error.exception", th);
        request.setAttribute("jakarta.servlet.error.exception_type", th.getClass());
        request.setAttribute("org.eclipse.jetty.server.error_exception", th);
        this._requestState = RequestState.BLOCKING;
    }

    public void sendError(int code, String message) {
        ServletContextRequest servletContextRequest = this._servletChannel.getServletContextRequest();
        ServletApiRequest httpServletRequest = servletContextRequest.getServletApiRequest();
        ServletContextRequest request = this._servletChannel.getServletContextRequest();
        ServletContextResponse response = this._servletChannel.getServletContextResponse();
        if (message == null) {
            message = HttpStatus.getMessage(code);
        }
        try (AutoLock ignored = this.lock();){
            Throwable cause;
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendError {}", (Object)this.toStringLocked());
            }
            if (this._outputState != OutputState.OPEN) {
                throw new IllegalStateException(this._outputState.toString());
            }
            switch (this._state.ordinal()) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            response.setStatus(code);
            servletContextRequest.errorClose();
            request.setAttribute("org.eclipse.jetty.server.error_context", servletContextRequest.getErrorContext());
            request.setAttribute("jakarta.servlet.error.request_uri", httpServletRequest.getRequestURI());
            request.setAttribute("jakarta.servlet.error.servlet_name", servletContextRequest.getServletName());
            request.setAttribute("jakarta.servlet.error.status_code", code);
            request.setAttribute("jakarta.servlet.error.message", message);
            request.setAttribute("org.eclipse.jetty.server.error_context", servletContextRequest.getServletContext());
            request.setAttribute("org.eclipse.jetty.server.error_message", message);
            request.setAttribute("org.eclipse.jetty.server.error_status", code);
            this._sendError = true;
            if (this._event != null && (cause = (Throwable)request.getAttribute("jakarta.servlet.error.exception")) != null) {
                this._event.addThrowable(cause);
            }
        }
    }

    protected void completing() {
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("completing {}", (Object)this.toStringLocked());
            }
            switch (this._requestState.ordinal()) {
                case 8: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            this._requestState = RequestState.COMPLETING;
        }
    }

    protected void completed(Throwable failure) {
        AsyncContextEvent event;
        List<AsyncListener> aListeners;
        boolean handle = false;
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("completed {}", (Object)this.toStringLocked());
            }
            if (this._requestState != RequestState.COMPLETING) {
                throw new IllegalStateException(this.getStatusStringLocked());
            }
            if (failure != null) {
                this.abortResponse(failure);
            }
            if (this._event == null) {
                this._requestState = RequestState.COMPLETED;
                aListeners = null;
                event = null;
                if (this._state == State.WAITING) {
                    this._state = State.WOKEN;
                    handle = true;
                }
            } else {
                aListeners = this._asyncListeners;
                event = this._event;
            }
        }
        this._servletChannel.getHttpOutput().completed(failure);
        if (event != null) {
            this.cancelTimeout(event);
            if (aListeners != null) {
                this.runInContext(event, () -> {
                    for (AsyncListener listener : aListeners) {
                        try {
                            listener.onComplete(event);
                        }
                        catch (Throwable x) {
                            if (LOG.isDebugEnabled()) {
                                LOG.warn("{} while invoking onComplete listener {}", x, listener, x);
                                continue;
                            }
                            LOG.warn("{} while invoking onComplete listener {}", (Object)x, (Object)listener);
                        }
                    }
                });
            }
            event.completed();
            ignored = this.lock();
            try {
                this._requestState = RequestState.COMPLETED;
                if (this._state == State.WAITING) {
                    this._state = State.WOKEN;
                    handle = true;
                }
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        if (handle) {
            this._servletChannel.handle();
        }
    }

    protected void recycle() {
        this.cancelTimeout();
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("recycle {}", (Object)this.toStringLocked());
            }
            switch (this._state.ordinal()) {
                case 1: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
                case 4: {
                    return;
                }
            }
            this._asyncListeners = null;
            this._state = State.IDLE;
            this._requestState = RequestState.BLOCKING;
            if (this._outputState != OutputState.ABORTED) {
                this._outputState = OutputState.IDLE;
            }
            this._initial = true;
            this._inputState = InputState.IDLE;
            this._asyncWritePossible = false;
            this._timeoutMs = DEFAULT_TIMEOUT;
            this._event = null;
            this._failureListener = false;
        }
    }

    public void upgrade() {
        this.cancelTimeout();
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("upgrade {}", (Object)this.toStringLocked());
            }
            switch (this._state.ordinal()) {
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusStringLocked());
                }
            }
            this._asyncListeners = null;
            this._state = State.UPGRADED;
            this._requestState = RequestState.BLOCKING;
            this._initial = true;
            this._inputState = InputState.IDLE;
            this._asyncWritePossible = false;
            this._timeoutMs = DEFAULT_TIMEOUT;
            this._event = null;
        }
    }

    protected void scheduleDispatch() {
        this._servletChannel.execute(this._servletChannel::handle);
    }

    protected void cancelTimeout() {
        this.cancelTimeout(this.getAsyncContextEvent());
    }

    protected void cancelTimeout(AsyncContextEvent event) {
        if (event != null) {
            event.cancelTimeoutTask();
        }
    }

    public boolean isIdle() {
        try (AutoLock ignored = this.lock();){
            boolean bl = this._state == State.IDLE;
            return bl;
        }
    }

    public boolean isExpired() {
        try (AutoLock ignored = this.lock();){
            boolean bl = this._requestState == RequestState.EXPIRE || this._requestState == RequestState.EXPIRING;
            return bl;
        }
    }

    public boolean isInitial() {
        try (AutoLock ignored = this.lock();){
            boolean bl = this._initial;
            return bl;
        }
    }

    public boolean isSuspended() {
        try (AutoLock ignored = this.lock();){
            boolean bl = this._state == State.WAITING || this._state == State.HANDLING && this._requestState == RequestState.ASYNC;
            return bl;
        }
    }

    boolean isCompleted() {
        try (AutoLock ignored = this.lock();){
            boolean bl = this._requestState == RequestState.COMPLETED;
            return bl;
        }
    }

    public boolean isAsyncStarted() {
        try (AutoLock ignored = this.lock();){
            if (this._state == State.HANDLING) {
                boolean bl = this._requestState != RequestState.BLOCKING && this._requestState != RequestState.ERRORING;
                return bl;
            }
            boolean bl = this._requestState == RequestState.ASYNC || this._requestState == RequestState.EXPIRING;
            return bl;
        }
    }

    public boolean isAsync() {
        try (AutoLock ignored = this.lock();){
            boolean bl = !this._initial || this._requestState != RequestState.BLOCKING && this._requestState != RequestState.ERRORING;
            return bl;
        }
    }

    public ServletContextHandler getContextHandler() {
        return this._servletChannel.getServletContextHandler();
    }

    void runInContext(AsyncContextEvent event, Runnable runnable) {
        event.getContext().run(runnable);
    }

    public Object getAttribute(String name) {
        return this._servletChannel.getServletContextRequest().getAttribute(name);
    }

    public void removeAttribute(String name) {
        this._servletChannel.getServletContextRequest().removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._servletChannel.getServletContextRequest().setAttribute(name, attribute);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onReadReady() {
        boolean woken = false;
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onReadReady {}", (Object)this.toStringLocked());
            }
            switch (this._inputState.ordinal()) {
                case 2: {
                    return woken;
                }
                case 0: 
                case 1: {
                    this._inputState = InputState.READY;
                    if (this._state != State.WAITING) return woken;
                    woken = true;
                    this._state = State.WOKEN;
                    return woken;
                }
                default: {
                    throw new IllegalStateException(this.toStringLocked());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onReadEof() {
        boolean woken = false;
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onReadEof {}", (Object)this.toStringLocked());
            }
            switch (this._inputState.ordinal()) {
                case 0: 
                case 1: 
                case 2: {
                    this._inputState = InputState.READY;
                    if (this._state != State.WAITING) return woken;
                    woken = true;
                    this._state = State.WOKEN;
                    return woken;
                }
                default: {
                    throw new IllegalStateException(this.toStringLocked());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onContentAdded() {
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onContentAdded {}", (Object)this.toStringLocked());
            }
            switch (this._inputState.ordinal()) {
                case 0: 
                case 1: 
                case 2: {
                    this._inputState = InputState.READY;
                    return;
                }
                default: {
                    throw new IllegalStateException(this.toStringLocked());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReadIdle() {
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onReadIdle {}", (Object)this.toStringLocked());
            }
            switch (this._inputState.ordinal()) {
                case 0: 
                case 1: 
                case 2: {
                    this._inputState = InputState.IDLE;
                    return;
                }
                default: {
                    throw new IllegalStateException(this.toStringLocked());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReadUnready() {
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onReadUnready {}", (Object)this.toStringLocked());
            }
            switch (this._inputState.ordinal()) {
                case 0: 
                case 1: 
                case 2: {
                    this._inputState = InputState.UNREADY;
                    return;
                }
                default: {
                    throw new IllegalStateException(this.toStringLocked());
                }
            }
        }
    }

    public boolean isInputUnready() {
        try (AutoLock ignored = this.lock();){
            boolean bl = this._inputState == InputState.UNREADY;
            return bl;
        }
    }

    public boolean onWritePossible() {
        boolean wake = false;
        try (AutoLock ignored = this.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onWritePossible {}", (Object)this.toStringLocked());
            }
            this._asyncWritePossible = true;
            if (this._state == State.WAITING) {
                this._state = State.WOKEN;
                wake = true;
            }
        }
        return wake;
    }

    private static /* synthetic */ void lambda$onError$0(List asyncListeners, AsyncContextEvent asyncEvent) {
        for (AsyncListener listener : asyncListeners) {
            try {
                listener.onError(asyncEvent);
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("{} while invoking onError listener {}", x, listener, x);
                    continue;
                }
                LOG.warn("{} while invoking onError listener {}", (Object)x, (Object)listener);
            }
        }
    }

    public static enum State {
        IDLE,
        HANDLING,
        WAITING,
        WOKEN,
        UPGRADED;

    }

    private static enum RequestState {
        BLOCKING,
        ERRORING,
        ASYNC,
        DISPATCH,
        EXPIRE,
        EXPIRING,
        COMPLETE,
        COMPLETING,
        COMPLETED;

    }

    private static enum OutputState {
        IDLE,
        OPEN,
        COMPLETED,
        ABORTED;

    }

    private static enum InputState {
        IDLE,
        UNREADY,
        READY;

    }

    public static enum Action {
        DISPATCH,
        ASYNC_DISPATCH,
        SEND_ERROR,
        ASYNC_ERROR,
        ASYNC_TIMEOUT,
        WRITE_CALLBACK,
        READ_CALLBACK,
        COMPLETE,
        TERMINATED,
        WAIT;

    }
}

