/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client.transport.internal;

import org.eclipse.jetty.client.Connection;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpReceiver;
import org.eclipse.jetty.client.transport.HttpSender;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.client.HTTP3SessionClient;
import org.eclipse.jetty.http3.client.transport.internal.HttpConnectionOverHTTP3;
import org.eclipse.jetty.http3.client.transport.internal.HttpReceiverOverHTTP3;
import org.eclipse.jetty.http3.client.transport.internal.HttpSenderOverHTTP3;

public class HttpChannelOverHTTP3
extends HttpChannel {
    private final HttpConnectionOverHTTP3 connection;
    private final HTTP3SessionClient session;
    private final HttpSenderOverHTTP3 sender;
    private final HttpReceiverOverHTTP3 receiver;
    private Stream stream;

    public HttpChannelOverHTTP3(HttpConnectionOverHTTP3 connection, HTTP3SessionClient session) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.session = session;
        this.sender = new HttpSenderOverHTTP3(this);
        this.receiver = new HttpReceiverOverHTTP3(this);
    }

    public HttpConnectionOverHTTP3 getHttpConnection() {
        return this.connection;
    }

    public HTTP3SessionClient getSession() {
        return this.session;
    }

    public Stream.Client.Listener getStreamListener() {
        return this.receiver;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected HttpSender getHttpSender() {
        return this.sender;
    }

    protected HttpReceiver getHttpReceiver() {
        return this.receiver;
    }

    public Stream getStream() {
        return this.stream;
    }

    public void setStream(Stream stream) {
        this.stream = stream;
    }

    public void send(HttpExchange exchange) {
        this.sender.send(exchange);
    }

    public void exchangeTerminated(HttpExchange exchange, Result result) {
        super.exchangeTerminated(exchange, result);
        Stream stream = this.getStream();
        if (stream != null && result.isFailed()) {
            stream.reset(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), result.getFailure());
        } else {
            this.release();
        }
    }

    public void release() {
        this.setStream(null);
        this.connection.release(this);
    }

    public String toString() {
        return String.format("%s[send=%s,recv=%s]", new Object[]{super.toString(), this.sender, this.receiver});
    }
}

