/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class ChannelEndPoint
extends AbstractEndPoint {
    private static final Logger LOG = Log.getLogger(ChannelEndPoint.class);
    private final ByteChannel _channel;
    private final Socket _socket;
    private volatile boolean _ishut;
    private volatile boolean _oshut;

    public ChannelEndPoint(Scheduler scheduler, SocketChannel channel) {
        super(scheduler, (InetSocketAddress)channel.socket().getLocalSocketAddress(), (InetSocketAddress)channel.socket().getRemoteSocketAddress());
        this._channel = channel;
        this._socket = channel.socket();
    }

    @Override
    public boolean isOpen() {
        return this._channel.isOpen();
    }

    protected void shutdownInput() {
        LOG.debug("ishut {}", new Object[]{this});
        this._ishut = true;
        if (this._oshut) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownOutput() {
        LOG.debug("oshut {}", new Object[]{this});
        this._oshut = true;
        if (this._channel.isOpen()) {
            try {
                if (!this._socket.isOutputShutdown()) {
                    this._socket.shutdownOutput();
                }
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
            finally {
                if (this._ishut) {
                    this.close();
                }
            }
        }
    }

    @Override
    public boolean isOutputShutdown() {
        return this._oshut || !this._channel.isOpen() || this._socket.isOutputShutdown();
    }

    @Override
    public boolean isInputShutdown() {
        return this._ishut || !this._channel.isOpen() || this._socket.isInputShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        LOG.debug("close {}", new Object[]{this});
        try {
            this._channel.close();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
        finally {
            this._ishut = true;
            this._oshut = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fill(ByteBuffer buffer) throws IOException {
        if (this._ishut) {
            return -1;
        }
        int pos = BufferUtil.flipToFill((ByteBuffer)buffer);
        try {
            int filled = this._channel.read(buffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("filled {} {}", new Object[]{filled, this});
            }
            if (filled > 0) {
                this.notIdle();
            } else if (filled == -1) {
                this.shutdownInput();
            }
            int n = filled;
            return n;
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            this.shutdownInput();
            int n = -1;
            return n;
        }
        finally {
            BufferUtil.flipToFlush((ByteBuffer)buffer, (int)pos);
        }
    }

    @Override
    public boolean flush(ByteBuffer ... buffers) throws IOException {
        int flushed = 0;
        try {
            if (buffers.length == 1) {
                flushed = this._channel.write(buffers[0]);
            } else if (buffers.length > 1 && this._channel instanceof GatheringByteChannel) {
                flushed = (int)((GatheringByteChannel)((Object)this._channel)).write(buffers, 0, buffers.length);
            } else {
                for (ByteBuffer b : buffers) {
                    if (!b.hasRemaining()) continue;
                    int l = this._channel.write(b);
                    if (l > 0) {
                        flushed += l;
                    }
                    if (b.hasRemaining()) break;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("flushed {} {}", new Object[]{flushed, this});
            }
        }
        catch (IOException e) {
            throw new EofException(e);
        }
        if (flushed > 0) {
            this.notIdle();
        }
        for (ByteBuffer b : buffers) {
            if (BufferUtil.isEmpty((ByteBuffer)b)) continue;
            return false;
        }
        return true;
    }

    public ByteChannel getChannel() {
        return this._channel;
    }

    @Override
    public Object getTransport() {
        return this._channel;
    }

    public Socket getSocket() {
        return this._socket;
    }

    @Override
    protected void onIncompleteFlush() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean needsFill() throws IOException {
        throw new UnsupportedOperationException();
    }
}

