/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.util;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.eclipse.jetty.osgi.util.BundleFileLocatorHelper;
import org.eclipse.jetty.osgi.util.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);

    public static URI resolvePathAsLocalizedURI(String path, Bundle bundle, Path jettyHome) throws Exception {
        URL url;
        Path p;
        if (StringUtil.isBlank((String)path)) {
            return null;
        }
        if (path.startsWith("/") || path.startsWith("file:/")) {
            return URIUtil.toURI((String)path);
        }
        try {
            p = FileSystems.getDefault().getPath(path, new String[0]);
            if (p.isAbsolute()) {
                return p.toUri();
            }
        }
        catch (InvalidPathException x) {
            LOG.trace("IGNORED", (Throwable)x);
        }
        if (bundle != null && (url = bundle.getEntry(path)) != null) {
            return BundleFileLocatorHelper.DEFAULT.getLocalURL(url).toURI();
        }
        if (jettyHome != null && Files.exists(p = jettyHome.resolve(path), new LinkOption[0])) {
            return p.toUri();
        }
        return null;
    }

    public static URL getLocalURL(URL url) throws Exception {
        if (url == null) {
            return null;
        }
        return BundleFileLocatorHelper.DEFAULT.getLocalURL(url);
    }

    public static URL getLocalizedEntry(String file, Bundle bundle) throws Exception {
        if (file == null || bundle == null) {
            return null;
        }
        URL url = bundle.getEntry(file);
        if (url == null) {
            return null;
        }
        return BundleFileLocatorHelper.DEFAULT.getLocalURL(url);
    }

    public static List<Path> getPathsToBundlesBySymbolicNames(String bundleSymbolicNames, BundleContext bundleContext) throws Exception {
        String[] symbNames;
        PackageAdmin packageAdmin;
        if (bundleSymbolicNames == null) {
            return Collections.emptyList();
        }
        Objects.requireNonNull(bundleContext);
        ServiceReference ref = bundleContext.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin2 = packageAdmin = ref == null ? null : (PackageAdmin)bundleContext.getService(ref);
        if (packageAdmin == null) {
            throw new IllegalStateException("Unable to get PackageAdmin reference to locate required Tld bundles");
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String symbName : symbNames = bundleSymbolicNames.split("[, ]")) {
            Bundle[] bs = packageAdmin.getBundles(symbName, null);
            if (bs == null || bs.length == 0) {
                throw new IllegalArgumentException("Unable to locate the bundle '" + symbName + "' specified in manifest of " + bundleContext.getBundle().getSymbolicName());
            }
            File f = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bs[0]);
            paths.add(f.toPath());
        }
        return paths;
    }

    public static Filter createFilter(BundleContext bundleContext, String classname, String managedServerName) throws InvalidSyntaxException {
        if (StringUtil.isBlank((String)managedServerName) || managedServerName.equals("defaultJettyServer")) {
            return bundleContext.createFilter("(&(objectclass=" + classname + ")(|(managedServerName=" + managedServerName + ")(!(managedServerName=*))))");
        }
        return bundleContext.createFilter("(&(objectclass=" + classname + ")(managedServerName=" + managedServerName + "))");
    }

    public static String getManifestHeaderValue(String name, String altName, Dictionary<String, String> manifest) {
        if (manifest == null) {
            return null;
        }
        if (name == null && altName == null) {
            return null;
        }
        if (name != null) {
            return manifest.get(name);
        }
        return manifest.get(altName);
    }

    public static String getManifestHeaderValue(String name, Dictionary<String, String> manifest) {
        return Util.getManifestHeaderValue(name, null, manifest);
    }

    public static List<URL> fileNamesAsURLs(String val, String delims) throws Exception {
        String separators = ",;";
        if (delims == null) {
            delims = separators;
        }
        StringTokenizer tokenizer = new StringTokenizer(val, delims, false);
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tokenizer.hasMoreTokens()) {
            urls.add(BundleFileLocatorHelperFactory.getFactory().getHelper().getLocalURL(new URL(tokenizer.nextToken())));
        }
        return urls;
    }

    public static void setProperty(Dictionary<String, Object> properties, String key, Object value) {
        if (value != null) {
            properties.put(key, value);
        }
    }

    public static String resolvePropertyValue(String value) {
        int ind = value.indexOf("${");
        if (ind == -1) {
            return value;
        }
        int ind2 = value.indexOf(125, ind);
        if (ind2 == -1) {
            return value;
        }
        String sysprop = value.substring(ind + 2, ind2);
        Object defaultValue = null;
        int comma = sysprop.indexOf(44);
        if (comma != -1 && comma + 1 != sysprop.length()) {
            defaultValue = sysprop.substring(comma + 1);
            defaultValue = Util.resolvePropertyValue((String)defaultValue);
            sysprop = sysprop.substring(0, comma);
        } else {
            defaultValue = "${" + sysprop + "}";
        }
        String v = System.getProperty(sysprop);
        String reminder = value.length() > ind2 + 1 ? value.substring(ind2 + 1) : "";
        reminder = Util.resolvePropertyValue(reminder);
        if (v != null) {
            return value.substring(0, ind) + v + reminder;
        }
        return value.substring(0, ind) + (String)defaultValue + reminder;
    }
}

