/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spring;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.ConfigurationProcessor;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.eclipse.jetty.xml.XmlParser;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.UrlResource;

@Deprecated
public class SpringConfigurationProcessor
implements ConfigurationProcessor {
    private static final Logger LOG = Log.getLogger(SpringConfigurationProcessor.class);
    private XmlConfiguration _configuration;
    private DefaultListableBeanFactory _beanFactory;
    private String _main;

    public SpringConfigurationProcessor() {
        LOG.warn("DEPRECATION WARNING - The `jetty-spring` project will see no further updates, and has been fully removed from Jetty 10 onwards", new Object[0]);
    }

    public void init(URL url, XmlParser.Node root, XmlConfiguration configuration) {
        this.init(Resource.newResource((URL)url), root, configuration);
    }

    public void init(Resource jettyResource, XmlParser.Node config, XmlConfiguration configuration) {
        try {
            this._configuration = configuration;
            Object springResource = jettyResource != null ? new UrlResource(jettyResource.getURI()) : new ByteArrayResource(("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE beans PUBLIC \"-//SPRING//DTD BEAN//EN\" \"http://www.springframework.org/dtd/spring-beans.dtd\">" + config).getBytes(StandardCharsets.UTF_8));
            this._beanFactory = new DefaultListableBeanFactory(){

                protected void applyPropertyValues(String beanName, BeanDefinition mbd, BeanWrapper bw, PropertyValues pvs) {
                    SpringConfigurationProcessor.this._configuration.initializeDefaults(bw.getWrappedInstance());
                    super.applyPropertyValues(beanName, mbd, bw, pvs);
                }
            };
            new XmlBeanDefinitionReader((BeanDefinitionRegistry)this._beanFactory).loadBeanDefinitions((org.springframework.core.io.Resource)springResource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object configure(Object obj) throws Exception {
        this.doConfigure();
        return this._beanFactory.configureBean(obj, this._main);
    }

    public Object configure() throws Exception {
        this.doConfigure();
        return this._beanFactory.getBean(this._main);
    }

    private void doConfigure() {
        this._beanFactory.registerSingleton("properties", (Object)this._configuration.getProperties());
        for (String bean : this._beanFactory.getBeanDefinitionNames()) {
            LOG.debug("{} - {}", new Object[]{bean, Arrays.asList(this._beanFactory.getAliases(bean))});
            String[] aliases = this._beanFactory.getAliases(bean);
            if (!"Main".equals(bean) && !Arrays.asList(aliases).contains("Main")) continue;
            this._main = bean;
            break;
        }
        if (this._main == null) {
            this._main = this._beanFactory.getBeanDefinitionNames()[0];
        }
        Map idMap = this._configuration.getIdMap();
        LOG.debug("idMap {}", new Object[]{idMap});
        for (String id : idMap.keySet()) {
            LOG.debug("register {}", new Object[]{id});
            this._beanFactory.registerSingleton(id, idMap.get(id));
        }
        for (String id : idMap.keySet()) {
            if (!this._beanFactory.containsBeanDefinition(id)) continue;
            LOG.debug("reconfigure {}", new Object[]{id});
            this._beanFactory.configureBean(idMap.get(id), id);
        }
        for (String id : this._beanFactory.getSingletonNames()) {
            idMap.put(id, this._beanFactory.getBean(id));
        }
    }
}

