/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.start.BaseBuilder;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.Classpath;
import org.eclipse.jetty.start.CommandLineBuilder;
import org.eclipse.jetty.start.JarVersion;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.ModuleGraphWriter;
import org.eclipse.jetty.start.Modules;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.StartArgs;
import org.eclipse.jetty.start.StartEnvironment;
import org.eclipse.jetty.start.StartIni;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.UsageException;
import org.eclipse.jetty.start.Version;
import org.eclipse.jetty.start.config.CommandLineConfigSource;
import org.eclipse.jetty.start.config.ConfigSource;
import org.eclipse.jetty.util.FileID;

public class Main {
    private static final int EXIT_USAGE = 1;
    private BaseHome baseHome;
    private StartArgs jsvcStartArgs;

    public static void main(String[] args) {
        boolean test = false;
        try {
            Main main = new Main();
            StartArgs startArgs = main.processCommandLine(args);
            test = startArgs.isTestingModeEnabled();
            main.start(startArgs);
        }
        catch (UsageException e) {
            StartLog.error(e.getMessage(), new Object[0]);
            Main.usageExit(e.getCause(), e.getExitCode(), test);
        }
        catch (Throwable e) {
            Main.usageExit(e, -9, test);
        }
    }

    static void usageExit(int exit) {
        Main.usageExit(null, exit, false);
    }

    static void usageExit(Throwable t, int exit, boolean test) {
        if (t != null) {
            t.printStackTrace(System.err);
        }
        System.err.println();
        System.err.println("Usage: java -jar $JETTY_HOME/start.jar [options] [properties] [configs]");
        System.err.println("       java -jar $JETTY_HOME/start.jar --help  # for more information");
        if (test) {
            System.err.println("EXIT: " + exit);
        } else {
            System.exit(exit);
        }
    }

    private void copyInThread(InputStream in, OutputStream out) {
        new Thread(() -> {
            try {
                byte[] buf = new byte[1024];
                int len = in.read(buf);
                while (len > 0) {
                    out.write(buf, 0, len);
                    len = in.read(buf);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }).start();
    }

    private void dumpClasspathWithVersions(String name, PrintStream out, Classpath classpath) {
        StartLog.endStartLog();
        out.println();
        out.printf("Classpath: %s%n", name);
        out.printf("-----------%s%n", "-".repeat(name.length()));
        if (classpath.count() == 0) {
            out.println("No classpath entries and/or version information available show.");
            return;
        }
        out.println("Version Information on " + classpath.count() + " entr" + (classpath.count() > 1 ? "ies" : "y") + " in the classpath.");
        out.println("Note: order presented here is how they would appear on the classpath.");
        out.println("      changes to the --module=name command line options will be reflected here.");
        int i = 0;
        for (Path element : classpath.getElements()) {
            out.printf("%2d: %24s | %s\n", i++, this.getVersion(element), this.baseHome.toShortForm(element));
        }
    }

    public BaseHome getBaseHome() {
        return this.baseHome;
    }

    private String getVersion(Path element) {
        if (Files.isDirectory(element, new LinkOption[0])) {
            return "(dir)";
        }
        if (Files.isRegularFile(element, new LinkOption[0]) && FileID.isJavaArchive((Path)element)) {
            return JarVersion.getVersion(element);
        }
        return "";
    }

    public void invokeMain(ClassLoader classloader, StartArgs args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        Class<?> invokedClass;
        if (args.getSelectedModules().isEmpty()) {
            if (Files.exists(this.getBaseHome().getBasePath("start.jar"), new LinkOption[0])) {
                StartLog.error("Do not start with ${jetty.base} == ${jetty.home}!", new Object[0]);
            } else {
                StartLog.error("No enabled jetty modules found!", new Object[0]);
            }
            StartLog.info("${jetty.home} = %s", this.getBaseHome().getHomePath());
            StartLog.info("${jetty.base} = %s", this.getBaseHome().getBasePath());
            StartLog.error("Please create and/or configure a ${jetty.base} directory.", new Object[0]);
            Main.usageExit(-2);
            return;
        }
        String mainclass = args.getMainClassname();
        try {
            invokedClass = classloader.loadClass(mainclass);
        }
        catch (ClassNotFoundException e) {
            StartLog.error("Unable to find: %s", mainclass);
            StartLog.debug(e);
            Main.usageExit(-2);
            return;
        }
        StartLog.debug("%s - %s", invokedClass, invokedClass.getPackage().getImplementationVersion());
        CommandLineBuilder cmd = args.getMainArgs(StartArgs.ARG_PARTS);
        String[] argArray = cmd.getArgs().toArray(new String[0]);
        StartLog.debug("Command Line Args: %s", cmd.toString());
        Class[] methodParamTypes = new Class[]{argArray.getClass()};
        Method main = invokedClass.getDeclaredMethod("main", methodParamTypes);
        Object[] methodParams = new Object[]{argArray};
        StartLog.endStartLog();
        main.invoke(null, methodParams);
    }

    public void listConfig(PrintStream out, StartArgs args) {
        StartLog.endStartLog();
        Modules modules = args.getAllModules();
        modules.listEnabled(out);
        args.dumpJavaEnvironment(out);
        args.dumpJvmArgs(out);
        args.dumpSystemProperties(out);
        StartEnvironment jettyEnvironment = args.getJettyEnvironment();
        jettyEnvironment.dumpProperties(out);
        this.dumpClasspathWithVersions(jettyEnvironment.getName(), out, jettyEnvironment.getClasspath());
        jettyEnvironment.dumpActiveXmls(out);
        for (StartEnvironment environment : args.getEnvironments()) {
            environment.dumpProperties(out);
            this.dumpClasspathWithVersions(environment.getName(), out, environment.getClasspath());
            environment.dumpActiveXmls(out);
        }
    }

    public void listModules(PrintStream out, StartArgs args) {
        List<String> tags = args.getListModules();
        StartLog.endStartLog();
        String t = tags.toString();
        out.printf("%nModules %s:%n", t);
        out.printf("=========%s%n", "=".repeat(t.length()));
        args.getAllModules().listModules(out, tags);
        if ("[-internal]".equals(t) || "[*]".equals(t)) {
            args.getAllModules().listEnabled(out);
        }
    }

    public void showModules(PrintStream out, StartArgs args) {
        StartLog.endStartLog();
        args.getAllModules().showModules(out, args.getShowModules());
    }

    public StartArgs processCommandLine(List<String> cmdLine) throws Exception {
        return this.processCommandLine(cmdLine.toArray(new String[0]));
    }

    public StartArgs processCommandLine(String[] cmdLine) throws Exception {
        CommandLineConfigSource cmdLineSource = new CommandLineConfigSource(cmdLine);
        this.baseHome = new BaseHome(cmdLineSource);
        StartArgs args = new StartArgs(this.baseHome);
        StartLog.debug("jetty.home=%s", this.baseHome.getHome());
        StartLog.debug("jetty.base=%s", this.baseHome.getBase());
        Modules modules = new Modules(this.baseHome, args);
        StartLog.debug("Registering all modules", new Object[0]);
        modules.registerAll();
        args.setAllModules(modules);
        StartLog.debug("Parsing collected arguments", new Object[0]);
        args.parse(this.baseHome.getConfigSources());
        Props props = this.baseHome.getConfigSources().getProps();
        Props.Prop home = props.getProp("jetty.home");
        Props argProps = args.getJettyEnvironment().getProperties();
        if (!argProps.containsKey("jetty.home")) {
            argProps.setProperty(home);
        }
        argProps.setProperty("jetty.home.uri", this.normalizeURI(this.baseHome.getHomePath().toUri().toString()), home.source);
        Props.Prop base = props.getProp("jetty.base");
        if (!argProps.containsKey("jetty.base")) {
            argProps.setProperty(base);
        }
        argProps.setProperty("jetty.base.uri", this.normalizeURI(this.baseHome.getBasePath().toUri().toString()), base.source);
        Set<String> selectedModules = args.getSelectedModules();
        List<String> sortedSelectedModules = modules.getSortedNames(selectedModules);
        ArrayList<String> unknownModules = new ArrayList<String>(selectedModules);
        unknownModules.removeAll(sortedSelectedModules);
        if (unknownModules.size() >= 1) {
            throw new UsageException(-9, "Unknown module%s=[%s] List available with --list-modules", unknownModules.size() > 1 ? Character.valueOf('s') : "", String.join((CharSequence)", ", unknownModules));
        }
        for (String selectedModule : sortedSelectedModules) {
            for (String source : args.getSources(selectedModule)) {
                String shortForm = this.baseHome.toShortForm(source);
                modules.enable(selectedModule, shortForm);
            }
        }
        List<Module> activeModules = modules.getEnabled();
        Version START_VERSION = new Version(StartArgs.VERSION);
        for (Module enabled : activeModules) {
            if (!enabled.getVersion().isNewerThan(START_VERSION)) continue;
            throw new UsageException(-6, "Module [" + enabled.getName() + "] specifies jetty version [" + String.valueOf(enabled.getVersion()) + "] which is newer than this version of jetty [" + String.valueOf(START_VERSION) + "]");
        }
        for (String name : args.getSkipFileValidationModules()) {
            Module module = modules.get(name);
            module.setSkipFilesValidation(true);
        }
        args.expandEnvironments(activeModules);
        return args;
    }

    private String normalizeURI(String uri) {
        if (uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    public void start(StartArgs args) throws IOException, InterruptedException {
        BaseBuilder baseBuilder;
        StartLog.debug("StartArgs: %s", args);
        Classpath classpath = args.getJettyEnvironment().getClasspath();
        if (args.isHelp()) {
            this.usage(true);
        }
        if (args.isListClasspath()) {
            this.dumpClasspathWithVersions("Jetty", System.out, classpath);
        }
        if (args.isListConfig()) {
            this.listConfig(System.out, args);
        }
        if (args.getListModules() != null) {
            this.listModules(System.out, args);
        }
        if (args.getShowModules() != null) {
            this.showModules(System.out, args);
        }
        if (args.getModuleGraphFilename() != null) {
            Path outputFile = this.baseHome.getBasePath(args.getModuleGraphFilename());
            System.out.printf("Generating GraphViz Graph of Jetty Modules at %s%n", this.baseHome.toShortForm(outputFile));
            ModuleGraphWriter writer = new ModuleGraphWriter();
            writer.config(args.getJettyEnvironment().getProperties());
            writer.write(args.getAllModules(), outputFile);
        }
        if (args.isDryRun()) {
            CommandLineBuilder cmd = args.getMainArgs(args.getDryRunParts());
            cmd.debug();
            System.out.println(cmd.toCommandLine());
        }
        if (args.isStopCommand()) {
            this.doStop(args);
        }
        if (args.isUpdateIni()) {
            for (ConfigSource config : this.baseHome.getConfigSources()) {
                for (StartIni ini : config.getStartInis()) {
                    ini.update(this.baseHome, args.getJettyEnvironment().getProperties());
                }
            }
        }
        if ((baseBuilder = new BaseBuilder(this.baseHome, args)).build()) {
            StartLog.info("Base directory was modified", new Object[0]);
        } else if (args.isCreateFiles() || !args.getStartModules().isEmpty()) {
            StartLog.info("Base directory was not modified", new Object[0]);
        }
        args.getAllModules().checkEnabledModules();
        if (!args.isRun()) {
            return;
        }
        if (args.isExec()) {
            CommandLineBuilder cmd = args.getMainArgs(StartArgs.ALL_PARTS);
            cmd.debug();
            List execModules = args.getAllModules().getEnabled().stream().filter(module -> !module.getJvmArgs().isEmpty()).map(Module::getName).collect(Collectors.toList());
            StartLog.warn("Forking second JVM due to forking module(s): %s. Use --dry-run to generate the command line to avoid forking.", execModules);
            ProcessBuilder pbuilder = new ProcessBuilder(cmd.getArgs());
            StartLog.endStartLog();
            Process process = pbuilder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                StartLog.debug("Destroying %s", process);
                process.destroy();
            }));
            this.copyInThread(process.getErrorStream(), System.err);
            this.copyInThread(process.getInputStream(), System.out);
            this.copyInThread(System.in, process.getOutputStream());
            process.waitFor();
            System.exit(0);
            return;
        }
        if (args.hasJvmArgs() || args.hasSystemProperties()) {
            StartLog.warn("Unknown Arguments detected.  Consider using --dry-run or --exec", new Object[0]);
            if (args.hasSystemProperties()) {
                args.getSystemProperties().forEach((k, v) -> StartLog.warn("  Argument: -D%s=%s (interpreted as a System property, from %s)", k, System.getProperty(k), v));
            }
            if (args.hasJvmArgs()) {
                args.getJvmArgSources().forEach((jvmArg, source) -> StartLog.warn("  Argument: %s (interpreted as a JVM argument, from %s)", jvmArg, source));
            }
        }
        ClassLoader cl = classpath.getClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            this.invokeMain(cl, args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Main.usageExit(e, -2, args.isTestingModeEnabled());
        }
    }

    public void start() throws Exception {
        this.start(this.jsvcStartArgs);
    }

    private void doStop(StartArgs args) {
        Props argsProps = args.getJettyEnvironment().getProperties();
        Props.Prop stopHostProp = argsProps.getProp("STOP.HOST", true);
        Props.Prop stopPortProp = argsProps.getProp("STOP.PORT", true);
        Props.Prop stopKeyProp = argsProps.getProp("STOP.KEY", true);
        Props.Prop stopWaitProp = argsProps.getProp("STOP.WAIT", true);
        String stopHost = "127.0.0.1";
        int stopPort = -1;
        String stopKey = "";
        if (stopHostProp != null) {
            stopHost = stopHostProp.value;
        }
        if (stopPortProp != null) {
            stopPort = Integer.parseInt(stopPortProp.value);
        }
        if (stopKeyProp != null) {
            stopKey = stopKeyProp.value;
        }
        if (stopWaitProp != null) {
            int stopWait = Integer.parseInt(stopWaitProp.value);
            this.stop(stopHost, stopPort, stopKey, stopWait);
        } else {
            this.stop(stopHost, stopPort, stopKey);
        }
    }

    public void stop(String host, int port, String key) {
        this.stop(host, port, key, 0);
    }

    public void stop(String host, int port, String key, int timeout) {
        if (host == null || host.length() == 0) {
            host = "127.0.0.1";
        }
        try {
            if (port <= 0 || port > 65535) {
                System.err.println("STOP.PORT property must be specified with a valid port number");
                Main.usageExit(-7);
            }
            if (key == null) {
                key = "";
                System.err.println("STOP.KEY property must be specified");
                System.err.println("Using empty key");
            }
            try (Socket s = new Socket(InetAddress.getByName(host), port);){
                if (timeout > 0) {
                    s.setSoTimeout(timeout * 1000);
                }
                try (OutputStream out = s.getOutputStream();){
                    out.write((key + "\r\nstop\r\n").getBytes());
                    out.flush();
                    if (timeout > 0) {
                        String response;
                        StartLog.info("Waiting %,d seconds for jetty to stop%n", timeout);
                        LineNumberReader lin = new LineNumberReader(new InputStreamReader(s.getInputStream()));
                        while ((response = lin.readLine()) != null) {
                            StartLog.debug("Received \"%s\"", response);
                            if (!"Stopped".equals(response)) continue;
                            StartLog.warn("Server reports itself as Stopped", new Object[0]);
                        }
                    }
                }
            }
        }
        catch (SocketTimeoutException e) {
            StartLog.warn("Timed out waiting for stop confirmation", new Object[0]);
            System.exit(-9);
        }
        catch (ConnectException e) {
            Main.usageExit(e, -4, this.jsvcStartArgs != null && this.jsvcStartArgs.isTestingModeEnabled());
        }
        catch (Exception e) {
            Main.usageExit(e, -9, this.jsvcStartArgs != null && this.jsvcStartArgs.isTestingModeEnabled());
        }
    }

    public void stop() {
        this.doStop(this.jsvcStartArgs);
    }

    public void usage(boolean exit) {
        StartLog.endStartLog();
        if (!Main.printTextResource("org/eclipse/jetty/start/usage.txt")) {
            StartLog.warn("detailed usage resource unavailable", new Object[0]);
        }
        if (exit) {
            System.exit(1);
        }
    }

    public static boolean printTextResource(String resourceName) {
        boolean resourcePrinted;
        block20: {
            resourcePrinted = false;
            try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);){
                if (stream != null) {
                    try (InputStreamReader reader = new InputStreamReader(stream);
                         BufferedReader buf = new BufferedReader(reader);){
                        String line;
                        resourcePrinted = true;
                        while ((line = buf.readLine()) != null) {
                            System.out.println(line);
                        }
                        break block20;
                    }
                }
                StartLog.warn("Unable to find resource: %s", resourceName);
            }
            catch (IOException e) {
                StartLog.warn(e);
            }
        }
        return resourcePrinted;
    }

    public void init(String[] args) {
        try {
            this.jsvcStartArgs = this.processCommandLine(args);
        }
        catch (UsageException e) {
            StartLog.error(e.getMessage(), new Object[0]);
            Main.usageExit(e.getCause(), e.getExitCode(), false);
        }
        catch (Throwable e) {
            Main.usageExit(e, -9, false);
        }
    }

    public void destroy() {
    }
}

