/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.net.ssl.SSLParameters;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.Classpath;
import org.eclipse.jetty.start.CommandLineBuilder;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileArg;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.Modules;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.RawArgs;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.TextFile;
import org.eclipse.jetty.start.UsageException;
import org.eclipse.jetty.start.Utils;
import org.eclipse.jetty.start.config.ConfigSource;
import org.eclipse.jetty.start.config.ConfigSources;
import org.eclipse.jetty.start.config.DirConfigSource;
import org.eclipse.jetty.util.JavaVersion;
import org.eclipse.jetty.util.ManifestUtils;

public class StartArgs {
    public static final String VERSION;
    public static final Set<String> ALL_PARTS;
    public static final Set<String> ARG_PARTS;
    private static final String JETTY_VERSION_KEY = "jetty.version";
    private static final String JETTY_TAG_NAME_KEY = "jetty.tag.version";
    private static final String JETTY_BUILDNUM_KEY = "jetty.build";
    private static final String MAIN_CLASS = "org.eclipse.jetty.xml.XmlConfiguration";
    private static final String MODULE_MAIN_CLASS = "org.eclipse.jetty.xml/org.eclipse.jetty.xml.XmlConfiguration";
    private final BaseHome baseHome;
    private List<String> modules = new ArrayList<String>();
    private Set<String> skipFileValidationModules = new HashSet<String>();
    Map<String, List<String>> sources = new HashMap<String, List<String>>();
    private List<FileArg> files = new ArrayList<FileArg>();
    private Classpath classpath;
    private List<Path> xmls = new ArrayList<Path>();
    private Set<String> jmodAdds = new LinkedHashSet<String>();
    private Map<String, Set<String>> jmodPatch = new LinkedHashMap<String, Set<String>>();
    private Map<String, Set<String>> jmodOpens = new LinkedHashMap<String, Set<String>>();
    private Map<String, Set<String>> jmodExports = new LinkedHashMap<String, Set<String>>();
    private Map<String, Set<String>> jmodReads = new LinkedHashMap<String, Set<String>>();
    private List<String> jvmArgs = new ArrayList<String>();
    private List<String> xmlRefs = new ArrayList<String>();
    private List<String> propertyFileRefs = new ArrayList<String>();
    private List<Path> propertyFiles = new ArrayList<Path>();
    private Props properties = new Props();
    private Map<String, String> systemPropertySource = new HashMap<String, String>();
    private List<String> rawLibs = new ArrayList<String>();
    private List<String> startModules = new ArrayList<String>();
    private String moduleGraphFilename;
    private Modules allModules;
    private boolean run = true;
    private boolean createFiles = false;
    private boolean licenseCheckRequired = false;
    private boolean testingMode = false;
    private boolean help = false;
    private boolean stopCommand = false;
    private List<String> listModules = null;
    private boolean listClasspath = false;
    private boolean listConfig = false;
    private boolean version = false;
    private boolean dryRun = false;
    private final Set<String> dryRunParts = new HashSet<String>();
    private boolean jpms = false;
    private boolean createStartd = false;
    private boolean updateIni = false;
    private String mavenBaseUri;
    private boolean exec = false;
    private String execProperties;
    private boolean approveAllLicenses = false;

    public StartArgs(BaseHome baseHome) {
        this.baseHome = baseHome;
        this.classpath = new Classpath();
    }

    private void addFile(Module module, String uriLocation) {
        if (module != null && module.isSkipFilesValidation()) {
            StartLog.debug("Not validating module %s [files] for %s", module, uriLocation);
            return;
        }
        FileArg arg = new FileArg(module, this.properties.expand(uriLocation));
        if (!this.files.contains(arg)) {
            this.files.add(arg);
        }
    }

    private void addUniqueXmlFile(String xmlRef, Path xmlfile) throws IOException {
        if (!FS.canReadFile(xmlfile)) {
            throw new IOException("Cannot read file: " + xmlRef);
        }
        if (!this.xmls.contains(xmlfile = FS.toRealPath(xmlfile))) {
            this.xmls.add(xmlfile);
        }
    }

    private void addUniquePropertyFile(String propertyFileRef, Path propertyFile) throws IOException {
        if (!FS.canReadFile(propertyFile)) {
            throw new IOException("Cannot read file: " + propertyFileRef);
        }
        if (!this.propertyFiles.contains(propertyFile = FS.toRealPath(propertyFile))) {
            this.propertyFiles.add(propertyFile);
        }
    }

    public void dumpActiveXmls() {
        System.out.println();
        System.out.println("Jetty Active XMLs:");
        System.out.println("------------------");
        if (this.xmls.isEmpty()) {
            System.out.println(" (no xml files specified)");
            return;
        }
        for (Path xml : this.xmls) {
            System.out.printf(" %s%n", this.baseHome.toShortForm(xml.toAbsolutePath()));
        }
    }

    public void dumpEnvironment() {
        System.out.println();
        System.out.println("Java Environment:");
        System.out.println("-----------------");
        this.dumpSystemProperty("java.home");
        this.dumpSystemProperty("java.vm.vendor");
        this.dumpSystemProperty("java.vm.version");
        this.dumpSystemProperty("java.vm.name");
        this.dumpSystemProperty("java.vm.info");
        this.dumpSystemProperty("java.runtime.name");
        this.dumpSystemProperty("java.runtime.version");
        this.dumpSystemProperty("java.io.tmpdir");
        this.dumpSystemProperty("user.dir");
        this.dumpSystemProperty("user.language");
        this.dumpSystemProperty("user.country");
        System.out.println();
        System.out.println("Jetty Environment:");
        System.out.println("-----------------");
        this.dumpProperty(JETTY_VERSION_KEY);
        this.dumpProperty(JETTY_TAG_NAME_KEY);
        this.dumpProperty(JETTY_BUILDNUM_KEY);
        this.dumpProperty("jetty.home");
        this.dumpProperty("jetty.base");
        System.out.println();
        System.out.println("Config Search Order:");
        System.out.println("--------------------");
        for (ConfigSource config : this.baseHome.getConfigSources()) {
            DirConfigSource dirsource;
            System.out.printf(" %s", config.getId());
            if (config instanceof DirConfigSource && (dirsource = (DirConfigSource)config).isPropertyBased()) {
                System.out.printf(" -> %s", dirsource.getDir());
            }
            System.out.println();
        }
        System.out.println();
    }

    public void dumpJvmArgs() {
        System.out.println();
        System.out.println("JVM Arguments:");
        System.out.println("--------------");
        if (this.jvmArgs.isEmpty()) {
            System.out.println(" (no jvm args specified)");
            return;
        }
        for (String jvmArgKey : this.jvmArgs) {
            String value = System.getProperty(jvmArgKey);
            if (value != null) {
                System.out.printf(" %s = %s%n", jvmArgKey, value);
                continue;
            }
            System.out.printf(" %s%n", jvmArgKey);
        }
    }

    public void dumpProperties() {
        System.out.println();
        System.out.println("Properties:");
        System.out.println("-----------");
        ArrayList<String> sortedKeys = new ArrayList<String>();
        for (Props.Prop prop : this.properties) {
            if (prop.source.equals("<system-property>")) continue;
            sortedKeys.add(prop.key);
        }
        if (sortedKeys.isEmpty()) {
            System.out.println(" (no properties specified)");
            return;
        }
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            this.dumpProperty(key);
        }
        for (Path path : this.propertyFiles) {
            String p = this.baseHome.toShortForm(path);
            if (Files.isReadable(path)) {
                Properties props = new Properties();
                try {
                    props.load(new FileInputStream(path.toFile()));
                    for (Object key : props.keySet()) {
                        System.out.printf(" %s:%s = %s%n", p, key, props.getProperty(String.valueOf(key)));
                    }
                    continue;
                }
                catch (Throwable ex) {
                    System.out.printf(" %s NOT READABLE!%n", p);
                    continue;
                }
            }
            System.out.printf(" %s NOT READABLE!%n", p);
        }
    }

    private void dumpProperty(String key) {
        Props.Prop prop = this.properties.getProp(key);
        if (prop == null) {
            System.out.printf(" %s (not defined)%n", key);
        } else {
            System.out.printf(" %s = %s%n", key, prop.value);
            if (StartLog.isDebugEnabled()) {
                System.out.printf("   origin: %s%n", prop.source);
            }
        }
    }

    public void dumpSystemProperties() {
        System.out.println();
        System.out.println("System Properties:");
        System.out.println("------------------");
        if (this.systemPropertySource.keySet().isEmpty()) {
            System.out.println(" (no system properties specified)");
            return;
        }
        ArrayList<String> sortedKeys = new ArrayList<String>(this.systemPropertySource.keySet());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            this.dumpSystemProperty(key);
        }
    }

    private void dumpSystemProperty(String key) {
        String value = System.getProperty(key);
        String source = this.systemPropertySource.get(key);
        System.out.printf(" %s = %s (%s)%n", key, value, source);
    }

    private void ensureSystemPropertySet(String key) {
        if (this.systemPropertySource.containsKey(key)) {
            return;
        }
        if (this.properties.containsKey(key)) {
            Props.Prop prop = this.properties.getProp(key);
            if (prop == null) {
                return;
            }
            String val = this.properties.expand(prop.value);
            this.systemPropertySource.put(key, "property:" + prop.source);
            System.setProperty(key, val);
        }
    }

    public void expandSystemProperties() {
        StartLog.debug("Expanding System Properties", new Object[0]);
        for (String key : this.systemPropertySource.keySet()) {
            String expanded;
            String value = this.properties.getString(key);
            if (value == null || value.equals(expanded = this.properties.expand(value))) continue;
            System.setProperty(key, expanded);
        }
    }

    public void expandLibs() throws IOException {
        StartLog.debug("Expanding Libs", new Object[0]);
        for (String rawlibref : this.rawLibs) {
            StartLog.debug("rawlibref = " + rawlibref, new Object[0]);
            String libref = this.properties.expand(rawlibref);
            StartLog.debug("expanded = " + libref, new Object[0]);
            libref = libref.replaceAll("\\\\([^\\\\])", "\\\\\\\\$1");
            for (Path libpath : this.baseHome.getPaths(libref)) {
                this.classpath.addComponent(libpath.toFile());
            }
        }
    }

    public void expandModules(List<Module> activeModules) throws IOException {
        StartLog.debug("Expanding Modules", new Object[0]);
        for (Module module : activeModules) {
            for (String rawlibref : module.getLibs()) {
                StartLog.debug("rawlibref = " + rawlibref, new Object[0]);
                String libref = this.properties.expand(rawlibref);
                StartLog.debug("expanded = " + libref, new Object[0]);
                for (Path libpath : this.baseHome.getPaths(libref)) {
                    this.classpath.addComponent(libpath.toFile());
                }
            }
            for (String jvmArg : module.getJvmArgs()) {
                this.exec = true;
                this.jvmArgs.add(jvmArg);
            }
            for (String xmlRef : module.getXmls()) {
                xmlRef = this.properties.expand(xmlRef);
                Path xmlfile = this.baseHome.getPath(xmlRef);
                this.addUniqueXmlFile(xmlRef, xmlfile);
            }
            for (String file : module.getFiles()) {
                StartLog.debug("Adding module specified file: %s", file);
                this.addFile(module, file);
            }
        }
    }

    void expandJPMS(List<Module> activeModules) throws IOException {
        for (Module module : activeModules) {
            for (String line : module.getJPMS()) {
                line = this.properties.expand(line);
                String directive = "add-modules:";
                if (line.startsWith("add-modules:")) {
                    String[] names = line.substring(directive.length()).split(",");
                    Arrays.stream(names).map(String::trim).collect(Collectors.toCollection(() -> this.jmodAdds));
                    continue;
                }
                directive = "patch-module:";
                if (line.startsWith("patch-module:")) {
                    this.parseJPMSKeyValue(module, line, directive, true, this.jmodPatch);
                    continue;
                }
                directive = "add-opens:";
                if (line.startsWith("add-opens:")) {
                    this.parseJPMSKeyValue(module, line, directive, false, this.jmodOpens);
                    continue;
                }
                directive = "add-exports:";
                if (line.startsWith("add-exports:")) {
                    this.parseJPMSKeyValue(module, line, directive, false, this.jmodExports);
                    continue;
                }
                directive = "add-reads:";
                if (line.startsWith("add-reads:")) {
                    this.parseJPMSKeyValue(module, line, directive, false, this.jmodReads);
                    continue;
                }
                throw new IllegalArgumentException("Invalid [jpms] directive " + directive + " in module " + module.getName() + ": " + line);
            }
        }
        StartLog.debug("Expanded JPMS directives:%nadd-modules: %s%npatch-modules: %s%nadd-opens: %s%nadd-exports: %s%nadd-reads: %s", this.jmodAdds, this.jmodPatch, this.jmodOpens, this.jmodExports, this.jmodReads);
    }

    private void parseJPMSKeyValue(Module module, String line, String directive, boolean valueIsFile, Map<String, Set<String>> output) throws IOException {
        String valueString = line.substring(directive.length());
        int equals = valueString.indexOf(61);
        if (equals <= 0) {
            throw new IllegalArgumentException("Invalid [jpms] directive " + directive + " in module " + module.getName() + ": " + line);
        }
        String delimiter = valueIsFile ? File.pathSeparator : ",";
        String key = valueString.substring(0, equals).trim();
        String[] values = valueString.substring(equals + 1).split(delimiter);
        Set result = output.computeIfAbsent(key, k -> new LinkedHashSet());
        for (String value : values) {
            value = value.trim();
            if (valueIsFile) {
                List<Path> paths = this.baseHome.getPaths(value);
                paths.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.toCollection(() -> result));
                continue;
            }
            result.add(value);
        }
    }

    public List<String> getStartModules() {
        return this.startModules;
    }

    public Modules getAllModules() {
        return this.allModules;
    }

    public Classpath getClasspath() {
        return this.classpath;
    }

    public List<String> getEnabledModules() {
        return this.modules;
    }

    public List<FileArg> getFiles() {
        return this.files;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public CommandLineBuilder getMainArgs(Set<String> parts) throws IOException {
        if (parts.isEmpty()) {
            parts = ALL_PARTS;
        }
        CommandLineBuilder cmd = new CommandLineBuilder();
        this.ensureSystemPropertySet("STOP.PORT");
        this.ensureSystemPropertySet("STOP.KEY");
        this.ensureSystemPropertySet("STOP.WAIT");
        if (parts.contains("java")) {
            cmd.addRawArg(CommandLineBuilder.findJavaBin());
        }
        if (parts.contains("opts")) {
            cmd.addRawArg("-Djava.io.tmpdir=" + System.getProperty("java.io.tmpdir"));
            cmd.addRawArg("-Djetty.home=" + this.baseHome.getHome());
            cmd.addRawArg("-Djetty.base=" + this.baseHome.getBase());
            for (String x : this.getJvmArgs()) {
                if (x.startsWith("-D")) {
                    String[] assign = x.substring(2).split("=", 2);
                    String key = assign[0];
                    String value = assign.length == 1 ? "" : assign[1];
                    Props.Prop p = this.processSystemProperty(key, value, null);
                    cmd.addRawArg("-D" + p.key + "=" + this.getProperties().expand(p.value));
                    continue;
                }
                cmd.addRawArg(this.getProperties().expand(x));
            }
            for (String propKey : this.systemPropertySource.keySet()) {
                String value = System.getProperty(propKey);
                cmd.addEqualsArg("-D" + propKey, value);
            }
        }
        if (parts.contains("path")) {
            if (this.isJPMS()) {
                List dirs;
                Map<Boolean, List<File>> dirsAndFiles = StreamSupport.stream(this.classpath.spliterator(), false).collect(Collectors.groupingBy(File::isDirectory));
                List<File> files = dirsAndFiles.get(false);
                if (files != null && !files.isEmpty()) {
                    cmd.addRawArg("--module-path");
                    String modules = files.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
                    cmd.addRawArg(modules);
                }
                if ((dirs = (List)dirsAndFiles.get(true)) != null && !dirs.isEmpty()) {
                    cmd.addRawArg("--class-path");
                    String directories = dirs.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
                    cmd.addRawArg(directories);
                }
                if (!this.jmodAdds.isEmpty()) {
                    cmd.addRawArg("--add-modules");
                    cmd.addRawArg(String.join((CharSequence)",", this.jmodAdds));
                }
                for (Map.Entry<String, Set<String>> entry : this.jmodPatch.entrySet()) {
                    cmd.addRawArg("--patch-module");
                    cmd.addRawArg(entry.getKey() + "=" + String.join((CharSequence)File.pathSeparator, (Iterable<? extends CharSequence>)entry.getValue()));
                }
                for (Map.Entry<String, Set<String>> entry : this.jmodOpens.entrySet()) {
                    cmd.addRawArg("--add-opens");
                    cmd.addRawArg(entry.getKey() + "=" + String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
                }
                for (Map.Entry<String, Set<String>> entry : this.jmodExports.entrySet()) {
                    cmd.addRawArg("--add-exports");
                    cmd.addRawArg(entry.getKey() + "=" + String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
                }
                for (Map.Entry<String, Set<String>> entry : this.jmodReads.entrySet()) {
                    cmd.addRawArg("--add-reads");
                    cmd.addRawArg(entry.getKey() + "=" + String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
                }
            } else {
                cmd.addRawArg("-cp");
                cmd.addRawArg(this.classpath.toString());
            }
        }
        if (parts.contains("main")) {
            if (this.isJPMS()) {
                cmd.addRawArg("--module");
            }
            cmd.addRawArg(this.getMainClassname());
        }
        if (parts.contains("args")) {
            if (this.dryRun && this.execProperties == null) {
                for (Props.Prop p : this.properties) {
                    cmd.addRawArg(CommandLineBuilder.quote(p.key) + "=" + CommandLineBuilder.quote(p.value));
                }
            } else if (this.properties.size() > 0) {
                Path propPath;
                if (this.execProperties == null) {
                    propPath = Files.createTempFile("start_", ".properties", new FileAttribute[0]);
                    propPath.toFile().deleteOnExit();
                } else {
                    propPath = new File(this.execProperties).toPath();
                }
                try (OutputStream out = Files.newOutputStream(propPath, new OpenOption[0]);){
                    this.properties.store(out, "start.jar properties");
                }
                cmd.addRawArg(propPath.toAbsolutePath().toString());
            }
            for (Path xml : this.xmls) {
                cmd.addRawArg(xml.toAbsolutePath().toString());
            }
            for (Path propertyFile : this.propertyFiles) {
                cmd.addRawArg(propertyFile.toAbsolutePath().toString());
            }
        }
        return cmd;
    }

    public String getMainClassname() {
        String mainClass = System.getProperty("jetty.server", this.isJPMS() ? MODULE_MAIN_CLASS : MAIN_CLASS);
        return System.getProperty("main.class", mainClass);
    }

    public String getMavenLocalRepoDir() {
        String localRepo = this.getProperties().getString("maven.local.repo");
        if (Utils.isBlank(localRepo)) {
            localRepo = System.getenv("JETTY_MAVEN_LOCAL_REPO");
        }
        if (Utils.isBlank(localRepo)) {
            localRepo = System.getenv("MAVEN_LOCAL_REPO");
        }
        return localRepo;
    }

    public Path findMavenLocalRepoDir() {
        Path home;
        Path localMavenRepository;
        String localRepo = this.getMavenLocalRepoDir();
        if (Utils.isBlank(localRepo) && Files.exists(localMavenRepository = (home = Paths.get(System.getProperty("user.home"), new String[0])).resolve(".m2/repository"), new LinkOption[0])) {
            localRepo = localMavenRepository.toString();
        }
        if (Utils.isBlank(localRepo)) {
            return null;
        }
        Path localRepoDir = new File(localRepo).toPath();
        if (Files.exists(localRepoDir = localRepoDir.normalize().toAbsolutePath(), new LinkOption[0]) && Files.isDirectory(localRepoDir, new LinkOption[0])) {
            return localRepoDir;
        }
        StartLog.warn("Not a valid maven local repository directory: %s", localRepoDir);
        return null;
    }

    public String getModuleGraphFilename() {
        return this.moduleGraphFilename;
    }

    public Props getProperties() {
        return this.properties;
    }

    public Set<String> getSkipFileValidationModules() {
        return this.skipFileValidationModules;
    }

    public List<String> getSources(String module) {
        return this.sources.get(module);
    }

    public List<Path> getXmlFiles() {
        return this.xmls;
    }

    public boolean hasJvmArgs() {
        return !this.jvmArgs.isEmpty();
    }

    public boolean hasSystemProperties() {
        for (String key : this.systemPropertySource.keySet()) {
            if ("jetty.home".equals(key) || "jetty.base".equals(key) || "main.class".equals(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isApproveAllLicenses() {
        return this.approveAllLicenses;
    }

    public boolean isCreateFiles() {
        return this.createFiles;
    }

    public boolean isJPMS() {
        return this.jpms;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public Set<String> getDryRunParts() {
        return this.dryRunParts;
    }

    public boolean isExec() {
        return this.exec;
    }

    public boolean isLicenseCheckRequired() {
        return this.licenseCheckRequired;
    }

    public boolean isNormalMainClass() {
        return MAIN_CLASS.equals(this.getMainClassname());
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isListClasspath() {
        return this.listClasspath;
    }

    public boolean isListConfig() {
        return this.listConfig;
    }

    public List<String> getListModules() {
        return this.listModules;
    }

    public boolean isRun() {
        return this.run;
    }

    public boolean isStopCommand() {
        return this.stopCommand;
    }

    public boolean isTestingModeEnabled() {
        return this.testingMode;
    }

    public boolean isVersion() {
        return this.version;
    }

    public boolean isCreateStartd() {
        return this.createStartd;
    }

    public boolean isUpdateIni() {
        return this.updateIni;
    }

    public String getMavenBaseUri() {
        return this.mavenBaseUri;
    }

    public void parse(ConfigSources sources) {
        ListIterator<ConfigSource> iter = sources.reverseListIterator();
        while (iter.hasPrevious()) {
            ConfigSource source = iter.previous();
            for (RawArgs.Entry arg : source.getArgs()) {
                this.parse(arg.getLine(), arg.getOrigin());
            }
        }
    }

    public void parse(String rawarg, String source) {
        String value;
        String key;
        List<String> moduleNames;
        if (rawarg == null) {
            return;
        }
        StartLog.debug("parse(\"%s\", \"%s\")", rawarg, source);
        String arg = rawarg.trim();
        if (arg.length() <= 0) {
            return;
        }
        if (arg.startsWith("#")) {
            return;
        }
        if ("--help".equals(arg) || "-?".equals(arg)) {
            this.help = true;
            this.run = false;
            return;
        }
        if ("--debug".equals(arg) || arg.startsWith("--start-log-file")) {
            return;
        }
        if ("--testing-mode".equals(arg)) {
            System.setProperty("org.eclipse.jetty.start.testing", "true");
            this.testingMode = true;
            return;
        }
        if (arg.startsWith("--commands=")) {
            Path commands = this.baseHome.getPath(Props.getValue(arg));
            if (!Files.exists(commands, new LinkOption[0]) || !Files.isReadable(commands)) {
                throw new UsageException(-5, "--commands file must be readable: %s", commands);
            }
            try {
                TextFile file = new TextFile(commands);
                StartLog.info("reading commands from %s", this.baseHome.toShortForm(commands));
                String s = source + "|" + this.baseHome.toShortForm(commands);
                for (String line : file) {
                    this.parse(line, s);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (arg.startsWith("--include-jetty-dir=")) {
            return;
        }
        if ("--stop".equals(arg)) {
            this.stopCommand = true;
            this.run = false;
            return;
        }
        if (arg.startsWith("--download=")) {
            this.addFile(null, Props.getValue(arg));
            this.run = false;
            this.createFiles = true;
            return;
        }
        if (arg.equals("--create-files")) {
            this.run = false;
            this.createFiles = true;
            this.licenseCheckRequired = true;
            return;
        }
        if (arg.equals("--update-ini") || arg.equals("--update-inis")) {
            this.run = false;
            this.updateIni = true;
            return;
        }
        if ("--list-classpath".equals(arg) || "--version".equals(arg) || "-v".equals(arg) || "--info".equals(arg)) {
            this.listClasspath = true;
            this.run = false;
            return;
        }
        if ("--list-config".equals(arg)) {
            this.listConfig = true;
            this.run = false;
            return;
        }
        if ("--jpms".equals(arg)) {
            this.jpms = true;
            this.exec = true;
            return;
        }
        if ("--dry-run".equals(arg) || "--exec-print".equals(arg)) {
            this.dryRun = true;
            this.run = false;
            return;
        }
        if (arg.startsWith("--dry-run=")) {
            int colon = arg.indexOf(61);
            for (String part : arg.substring(colon + 1).split(",")) {
                if (!ALL_PARTS.contains(part)) {
                    throw new UsageException(-5, "Unrecognized --dry-run=\"%s\" in %s", part, source);
                }
                this.dryRunParts.add(part);
            }
            this.dryRun = true;
            this.run = false;
            return;
        }
        if ("--exec".equals(arg)) {
            this.exec = true;
            return;
        }
        if (arg.startsWith("--exec-properties=")) {
            this.execProperties = Props.getValue(arg);
            if (!this.execProperties.endsWith(".properties")) {
                throw new UsageException(-5, "--exec-properties filename must have .properties suffix: %s", this.execProperties);
            }
            return;
        }
        if ("--approve-all-licenses".equals(arg)) {
            this.approveAllLicenses = true;
            return;
        }
        if (arg.startsWith("--lib=")) {
            String cp = Props.getValue(arg);
            if (cp != null) {
                StringTokenizer t = new StringTokenizer(cp, File.pathSeparator);
                while (t.hasMoreTokens()) {
                    this.rawLibs.add(t.nextToken());
                }
            }
            return;
        }
        if ("--list-all-modules".equals(arg)) {
            this.listModules = Collections.singletonList("*");
            this.run = false;
            return;
        }
        if ("--list-modules".equals(arg)) {
            this.listModules = Collections.singletonList("-internal");
            this.run = false;
            return;
        }
        if (arg.startsWith("--list-modules=")) {
            this.listModules = Props.getValues(arg);
            this.run = false;
            return;
        }
        if ("--create-startd".equals(arg)) {
            this.createStartd = true;
            this.run = false;
            this.createFiles = true;
            this.licenseCheckRequired = true;
            return;
        }
        if (arg.startsWith("--add-to-startd=")) {
            String value2 = Props.getValue(arg);
            StartLog.warn("--add-to-startd is deprecated! Instead use: --create-startd --add-to-start=%s", value2);
            this.createStartd = true;
            this.startModules.addAll(Props.getValues(arg));
            this.run = false;
            this.createFiles = true;
            this.licenseCheckRequired = true;
            return;
        }
        if (arg.startsWith("--add-to-start=")) {
            this.startModules.addAll(Props.getValues(arg));
            this.run = false;
            this.createFiles = true;
            this.licenseCheckRequired = true;
            return;
        }
        if (arg.startsWith("--module=")) {
            moduleNames = Props.getValues(arg);
            this.enableModules(source, moduleNames);
            return;
        }
        if (arg.startsWith("--skip-file-validation=")) {
            moduleNames = Props.getValues(arg);
            this.skipFileValidationModules.addAll(moduleNames);
            return;
        }
        if (arg.startsWith("--write-module-graph=")) {
            this.moduleGraphFilename = Props.getValue(arg);
            this.run = false;
            return;
        }
        if (arg.startsWith("-D")) {
            String[] assign = arg.substring(2).split("=", 2);
            key = assign[0];
            value = assign.length == 1 ? "" : assign[1];
            Props.Prop p = this.processSystemProperty(key, value, source);
            this.systemPropertySource.put(p.key, p.source);
            this.setProperty(p.key, p.value, p.source);
            System.setProperty(p.key, p.value);
            return;
        }
        if (arg.startsWith("-")) {
            if (!this.jvmArgs.contains(arg)) {
                this.jvmArgs.add(arg);
            }
            return;
        }
        int equals = arg.indexOf(61);
        if (equals >= 0) {
            key = arg.substring(0, equals);
            value = arg.substring(equals + 1);
            this.processAndSetProperty(key, value, source);
            return;
        }
        if (FS.isXml(arg)) {
            if (!this.xmlRefs.contains(arg)) {
                this.xmlRefs.add(arg);
            }
            return;
        }
        if (FS.isPropertyFile(arg)) {
            if (!this.propertyFileRefs.contains(arg)) {
                this.propertyFileRefs.add(arg);
            }
            return;
        }
        throw new UsageException(-5, "Unrecognized argument: \"%s\" in %s", arg, source);
    }

    protected Props.Prop processSystemProperty(String key, String value, String source) {
        if (key.endsWith("+")) {
            String orig = System.getProperty(key = key.substring(0, key.length() - 1));
            if (orig == null || orig.isEmpty()) {
                if (value.startsWith(",")) {
                    value = value.substring(1);
                }
            } else {
                value = orig + value;
                if (source != null && this.systemPropertySource.containsKey(key)) {
                    source = this.systemPropertySource.get(key) + "," + source;
                }
            }
        } else if (key.endsWith("?")) {
            String preset = System.getProperty(key = key.substring(0, key.length() - 1));
            if (preset != null) {
                value = preset;
                source = this.systemPropertySource.get(key);
            } else if (source != null) {
                source = source + "?=";
            }
        }
        return new Props.Prop(key, value, source);
    }

    protected void processAndSetProperty(String key, String value, String source) {
        if (key.endsWith("+")) {
            key = key.substring(0, key.length() - 1);
            Props.Prop orig = this.getProperties().getProp(key);
            if (orig == null) {
                if (value.startsWith(",")) {
                    value = value.substring(1);
                }
            } else {
                value = orig.value + value;
                source = orig.source + "," + source;
            }
        } else if (key.endsWith("?")) {
            key = key.substring(0, key.length() - 1);
            Props.Prop preset = this.getProperties().getProp(key);
            if (preset != null) {
                return;
            }
            if (source != null) {
                source = source + "?=";
            }
        }
        this.setProperty(key, value, source);
    }

    private void enableModules(String source, List<String> moduleNames) {
        for (String moduleName : moduleNames) {
            this.modules.add(moduleName);
            List list = this.sources.computeIfAbsent(moduleName, k -> new ArrayList());
            list.add(source);
        }
    }

    public void resolveExtraXmls() throws IOException {
        for (String xmlRef : this.xmlRefs) {
            Path xmlfile = this.baseHome.getPath(xmlRef);
            if (!FS.exists(xmlfile)) {
                xmlfile = this.baseHome.getPath("etc/" + xmlRef);
            }
            this.addUniqueXmlFile(xmlRef, xmlfile);
        }
    }

    public void resolvePropertyFiles() throws IOException {
        for (String propertyFileRef : this.propertyFileRefs) {
            Path propertyFile = this.baseHome.getPath(propertyFileRef);
            if (!FS.exists(propertyFile)) {
                propertyFile = this.baseHome.getPath("etc/" + propertyFileRef);
            }
            this.addUniquePropertyFile(propertyFileRef, propertyFile);
        }
    }

    public void setAllModules(Modules allModules) {
        this.allModules = allModules;
    }

    public void setProperty(String key, String value, String source) {
        if (key.equals("jetty.home")) {
            this.properties.setProperty("jetty.home", System.getProperty("jetty.home"), source);
            return;
        }
        if (key.equals("jetty.base")) {
            this.properties.setProperty("jetty.base", System.getProperty("jetty.base"), source);
            return;
        }
        this.properties.setProperty(key, value, source);
        if (key.equals("java.version")) {
            try {
                JavaVersion ver = JavaVersion.parse((String)value);
                this.properties.setProperty("java.version.platform", Integer.toString(ver.getPlatform()), source);
                this.properties.setProperty("java.version.major", Integer.toString(ver.getMajor()), "Deprecated");
                this.properties.setProperty("java.version.minor", Integer.toString(ver.getMinor()), "Deprecated");
                this.properties.setProperty("java.version.micro", Integer.toString(ver.getMicro()), "Deprecated");
                this.properties.setProperty("runtime.feature.alpn", Boolean.toString(this.isMethodAvailable(SSLParameters.class, "getApplicationProtocols", null)), source);
            }
            catch (Throwable x) {
                UsageException ue = new UsageException(-5, x.getMessage() == null ? x.toString() : x.getMessage());
                ue.initCause(x);
                throw ue;
            }
        }
        if (key.equals("maven.repo.uri")) {
            this.mavenBaseUri = value;
        }
    }

    private boolean isMethodAvailable(Class<?> clazz, String methodName, Class<?>[] params) {
        try {
            clazz.getMethod(methodName, params);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public void setRun(boolean run) {
        this.run = run;
    }

    public String toString() {
        return String.format("%s[enabledModules=%s, xmlRefs=%s, properties=%s, jvmArgs=%s]", this.getClass().getSimpleName(), this.modules, this.xmlRefs, this.properties, this.jvmArgs);
    }

    static {
        ALL_PARTS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java", "opts", "path", "main", "args")));
        ARG_PARTS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("args")));
        String ver = System.getProperty(JETTY_VERSION_KEY);
        String tag = System.getProperty(JETTY_TAG_NAME_KEY);
        if (ver == null) {
            ver = ManifestUtils.getManifest(StartArgs.class).map(Manifest::getMainAttributes).filter(attributes -> "Eclipse Jetty Project".equals(attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR))).map(attributes -> attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION)).orElse(null);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Props jettyVerProps = Props.load(classLoader, "jetty-version.properties");
        Props buildProps = Props.load(classLoader, "org/eclipse/jetty/start/build.properties");
        String sha = buildProps.getString("buildNumber", System.getProperty(JETTY_BUILDNUM_KEY));
        if (Utils.isNotBlank(sha)) {
            System.setProperty(JETTY_BUILDNUM_KEY, sha);
        }
        if (Utils.isBlank(ver)) {
            ver = jettyVerProps.getString("version", buildProps.getString("version", "0.0"));
        }
        if (Utils.isBlank(tag)) {
            tag = jettyVerProps.getString("tag", buildProps.getString("tag", "jetty-" + ver));
        }
        VERSION = ver;
        System.setProperty(JETTY_VERSION_KEY, VERSION);
        System.setProperty(JETTY_TAG_NAME_KEY, tag);
    }
}

