/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.foreign;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentAllocator;
import java.net.SocketAddress;
import org.eclipse.jetty.quic.quiche.foreign.NativeHelper;
import org.eclipse.jetty.quic.quiche.foreign.linux.sockaddr_linux;
import org.eclipse.jetty.quic.quiche.foreign.macos.sockaddr_macos;
import org.eclipse.jetty.quic.quiche.foreign.windows.sockaddr_windows;

public class sockaddr {
    public static MemorySegment convert(SocketAddress socketAddress, SegmentAllocator allocator) {
        if (NativeHelper.isLinux()) {
            return sockaddr_linux.convert(socketAddress, allocator);
        }
        if (NativeHelper.isMac()) {
            return sockaddr_macos.convert(socketAddress, allocator);
        }
        if (NativeHelper.isWindows()) {
            return sockaddr_windows.convert(socketAddress, allocator);
        }
        throw new UnsupportedOperationException("Unsupported OS: " + System.getProperty("os.name"));
    }
}

