/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.http;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

public class AccessEvent {
    private final String method;
    private final String uri;
    private final Map<String, String> requestHeaders;
    private final Map<String, String[]> parameters;
    private int status;
    private Map<String, String> responseHeaders;

    AccessEvent(Request req) {
        this.method = req.getMethod();
        this.uri = req.getRequestURI();
        this.requestHeaders = AccessEvent.cloneHeaders(req);
        this.parameters = AccessEvent.clone(req.getParameterMap());
    }

    void setResponse(Response rsp) {
        this.status = rsp.getStatus();
        this.responseHeaders = AccessEvent.cloneHeaders(rsp);
    }

    private static Map<String, String> cloneHeaders(Request req) {
        TreeMap<String, String> r = new TreeMap<String, String>();
        Enumeration hn = req.getHeaderNames();
        while (hn.hasMoreElements()) {
            String key = (String)hn.nextElement();
            if (r.containsKey(key)) continue;
            r.put(key, req.getHeader(key));
        }
        return Collections.unmodifiableMap(r);
    }

    private static Map<String, String> cloneHeaders(Response rsp) {
        TreeMap<String, String> r = new TreeMap<String, String>();
        Enumeration hn = rsp.getHttpFields().getFieldNames();
        while (hn.hasMoreElements()) {
            String key = (String)hn.nextElement();
            if (r.containsKey(key)) continue;
            Enumeration v = rsp.getHttpFields().getValues(key);
            r.put(key, (String)v.nextElement());
        }
        return Collections.unmodifiableMap(r);
    }

    private static Map<String, String[]> clone(Map parameterMap) {
        return new TreeMap<String, String[]>(parameterMap);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.uri;
    }

    public String getRequestHeader(String name) {
        return this.requestHeaders.get(name);
    }

    public String getParameter(String name) {
        String[] r = this.parameters.get(name);
        return r != null && 1 <= r.length ? r[0] : null;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public int getStatus() {
        return this.status;
    }

    public String getResponseHeader(String name) {
        return this.responseHeaders != null ? this.responseHeaders.get(name) : null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.method);
        b.append(' ');
        b.append(this.uri);
        if (!this.parameters.isEmpty()) {
            b.append('?');
            boolean first = true;
            for (Map.Entry<String, String[]> e : this.parameters.entrySet()) {
                String[] stringArray = e.getValue();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String val = stringArray[n2];
                    if (!first) {
                        b.append('&');
                    }
                    first = false;
                    b.append(e.getKey());
                    b.append('=');
                    b.append(val);
                    ++n2;
                }
            }
        }
        b.append(' ');
        b.append(this.status);
        return b.toString();
    }
}

