/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lfs.internal.LfsText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.jgit.util.SystemReader;

public class InstallBuiltinLfsCommand
implements LfsFactory.LfsInstallCommand {
    private static final String[] ARGS_USER = new String[]{"lfs", "install"};
    private static final String[] ARGS_LOCAL = new String[]{"lfs", "install", "--local"};
    private Repository repository;

    public Void call() throws Exception {
        StoredConfig cfg = null;
        cfg = this.repository == null ? this.loadUserConfig() : this.repository.getConfig();
        cfg.setBoolean("filter", "lfs", "useJGitBuiltin", true);
        cfg.setBoolean("filter", "lfs", "required", true);
        cfg.save();
        ProcessBuilder builder = FS.DETECTED.runInShell("git", this.repository == null ? ARGS_USER : ARGS_LOCAL);
        if (this.repository != null) {
            builder.directory(this.repository.isBare() ? this.repository.getDirectory() : this.repository.getWorkTree());
        }
        FS.DETECTED.runProcess(builder, null, null, (String)null);
        return null;
    }

    public LfsFactory.LfsInstallCommand setRepository(Repository repo) {
        this.repository = repo;
        return this;
    }

    private StoredConfig loadUserConfig() throws IOException {
        FileBasedConfig c = SystemReader.getInstance().openUserConfig(null, FS.DETECTED);
        try {
            c.load();
        }
        catch (ConfigInvalidException e1) {
            throw new IOException(MessageFormat.format(LfsText.get().userConfigInvalid, new Object[]{c.getFile().getAbsolutePath(), e1}), e1);
        }
        return c;
    }
}

