/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lib.Repository;

public class Lfs {
    private Path root;
    private Path objDir;
    private Path tmpDir;

    @Deprecated
    public Lfs(Path root) {
        this.root = root;
    }

    public Lfs(Repository db) {
        this.root = db.getDirectory().toPath().resolve("lfs");
    }

    public Path getLfsRoot() {
        return this.root;
    }

    public Path getLfsTmpDir() {
        if (this.tmpDir == null) {
            this.tmpDir = this.root.resolve("tmp");
        }
        return this.tmpDir;
    }

    public Path getLfsObjDir() {
        if (this.objDir == null) {
            this.objDir = this.root.resolve("objects");
        }
        return this.objDir;
    }

    public Path getMediaFile(AnyLongObjectId id) {
        String idStr = id.name();
        return this.getLfsObjDir().resolve(idStr.substring(0, 2)).resolve(idStr.substring(2, 4)).resolve(idStr);
    }

    public Path createTmpFile() throws IOException {
        return Files.createTempFile(this.getLfsTmpDir(), null, null, new FileAttribute[0]);
    }
}

