/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.jgit.lfs.CleanFilter;
import org.eclipse.jgit.lfs.Lfs;
import org.eclipse.jgit.lfs.LfsBlobLoader;
import org.eclipse.jgit.lfs.LfsPointer;
import org.eclipse.jgit.lfs.SmudgeFilter;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.TemporaryBuffer;

public class LfsBlobFilter {
    public static ObjectLoader smudgeLfsBlob(Repository db, ObjectLoader loader) throws IOException {
        if (loader.getSize() > 200L) {
            return loader;
        }
        try (ObjectStream is = loader.openStream();){
            LfsPointer ptr = LfsPointer.parseLfsPointer((InputStream)is);
            if (ptr != null) {
                Lfs lfs = new Lfs(db);
                AnyLongObjectId oid = ptr.getOid();
                Path mediaFile = lfs.getMediaFile(oid);
                if (!Files.exists(mediaFile, new LinkOption[0])) {
                    SmudgeFilter.downloadLfsResource(lfs, db, ptr);
                }
                LfsBlobLoader lfsBlobLoader = new LfsBlobLoader(mediaFile);
                return lfsBlobLoader;
            }
        }
        return loader;
    }

    public static TemporaryBuffer cleanLfsBlob(Repository db, InputStream originalContent) throws IOException {
        TemporaryBuffer.LocalFile buffer = new TemporaryBuffer.LocalFile(null);
        CleanFilter f = new CleanFilter(db, originalContent, (OutputStream)buffer);
        try {
            while (f.run() != -1) {
            }
        }
        catch (IOException e) {
            buffer.destroy();
            throw e;
        }
        return buffer;
    }
}

