/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.internal;

import java.io.IOException;
import java.net.ProxySelector;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lfs.LfsPointer;
import org.eclipse.jgit.lfs.Protocol;
import org.eclipse.jgit.lfs.errors.LfsConfigInvalidException;
import org.eclipse.jgit.lfs.internal.LfsText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.HttpSupport;

public class LfsConnectionFactory {
    private static final String SCHEME_HTTPS = "https";
    private static final String SCHEME_SSH = "ssh";
    private static final Map<String, AuthCache> sshAuthCache = new TreeMap<String, AuthCache>();

    public static HttpConnection getLfsConnection(Repository db, String method, String purpose) throws IOException {
        StoredConfig config = db.getConfig();
        TreeMap<String, String> additionalHeaders = new TreeMap<String, String>();
        String lfsUrl = LfsConnectionFactory.getLfsUrl(db, purpose, additionalHeaders);
        URL url = new URL(lfsUrl + "/objects/batch");
        HttpConnection connection = HttpTransport.getConnectionFactory().create(url, HttpSupport.proxyFor((ProxySelector)ProxySelector.getDefault(), (URL)url));
        connection.setDoOutput(true);
        if (url.getProtocol().equals(SCHEME_HTTPS) && !config.getBoolean("http", "sslVerify", true)) {
            HttpSupport.disableSslVerify((HttpConnection)connection);
        }
        connection.setRequestMethod(method);
        connection.setRequestProperty("Accept", "application/vnd.git-lfs+json; charset=utf-8");
        connection.setRequestProperty("Content-Type", "application/vnd.git-lfs+json; charset=utf-8");
        additionalHeaders.forEach((k, v) -> connection.setRequestProperty(k, v));
        return connection;
    }

    private static String getLfsUrl(Repository db, String purpose, Map<String, String> additionalHeaders) throws LfsConfigInvalidException {
        StoredConfig config = db.getConfig();
        String lfsUrl = config.getString("lfs", null, "url");
        if (lfsUrl == null) {
            String remote;
            String remoteUrl = null;
            Iterator iterator = db.getRemoteNames().iterator();
            if (iterator.hasNext() && (lfsUrl = config.getString("lfs", remote = (String)iterator.next(), "url")) == null && remote.equals("origin")) {
                remoteUrl = config.getString("remote", remote, "url");
            }
            lfsUrl = lfsUrl == null && remoteUrl != null ? LfsConnectionFactory.discoverLfsUrl(db, purpose, additionalHeaders, remoteUrl) : lfsUrl + "/info/lfs";
        }
        if (lfsUrl == null) {
            throw new LfsConfigInvalidException(LfsText.get().lfsNoDownloadUrl);
        }
        return lfsUrl;
    }

    private static String discoverLfsUrl(Repository db, String purpose, Map<String, String> additionalHeaders, String remoteUrl) {
        try {
            URIish u = new URIish(remoteUrl);
            if (SCHEME_SSH.equals(u.getScheme())) {
                Protocol.ExpiringAction action = LfsConnectionFactory.getSshAuthentication(db, purpose, remoteUrl, u);
                additionalHeaders.putAll(action.header);
                return action.href;
            }
            return remoteUrl + "/info/lfs";
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Protocol.ExpiringAction getSshAuthentication(Repository db, String purpose, String remoteUrl, URIish u) throws IOException {
        AuthCache cached = sshAuthCache.get(remoteUrl);
        Protocol.ExpiringAction action = null;
        if (cached != null && cached.validUntil > System.currentTimeMillis()) {
            action = cached.cachedAction;
        }
        if (action == null) {
            String json = LfsConnectionFactory.runSshCommand(u.setPath(""), db.getFS(), "git-lfs-authenticate " + LfsConnectionFactory.extractProjectName(u) + " " + purpose);
            action = (Protocol.ExpiringAction)Protocol.gson().fromJson(json, Protocol.ExpiringAction.class);
            AuthCache c = new AuthCache(action);
            sshAuthCache.put(remoteUrl, c);
        }
        return action;
    }

    @NonNull
    public static HttpConnection getLfsContentConnection(Repository repo, Protocol.Action action, String method) throws IOException {
        URL contentUrl = new URL(action.href);
        HttpConnection contentServerConn = HttpTransport.getConnectionFactory().create(contentUrl, HttpSupport.proxyFor((ProxySelector)ProxySelector.getDefault(), (URL)contentUrl));
        contentServerConn.setRequestMethod(method);
        action.header.forEach((k, v) -> contentServerConn.setRequestProperty(k, v));
        if (contentUrl.getProtocol().equals(SCHEME_HTTPS) && !repo.getConfig().getBoolean("http", "sslVerify", true)) {
            HttpSupport.disableSslVerify((HttpConnection)contentServerConn);
        }
        contentServerConn.setRequestProperty("Accept-Encoding", "gzip");
        return contentServerConn;
    }

    private static String extractProjectName(URIish u) {
        String path = u.getPath().substring(1);
        if (path.endsWith(".git")) {
            return path.substring(0, path.length() - 4);
        }
        return path;
    }

    /*
     * Exception decompiling
     */
    private static String runSshCommand(URIish sshUri, FS fs, String command) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Protocol.Request toRequest(String operation, LfsPointer ... resources) {
        Protocol.Request req = new Protocol.Request();
        req.operation = operation;
        if (resources != null) {
            req.objects = new LinkedList<Protocol.ObjectSpec>();
            for (LfsPointer res : resources) {
                Protocol.ObjectSpec o = new Protocol.ObjectSpec();
                o.oid = res.getOid().getName();
                o.size = res.getSize();
                req.objects.add(o);
            }
        }
        return req;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    private static final class AuthCache {
        private static final long AUTH_CACHE_EAGER_TIMEOUT = 100L;
        private static final SimpleDateFormat ISO_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        long validUntil;
        Protocol.ExpiringAction cachedAction;

        public AuthCache(Protocol.ExpiringAction action) {
            this.cachedAction = action;
            try {
                this.validUntil = action.expiresIn != null && !action.expiresIn.isEmpty() ? System.currentTimeMillis() + Long.parseLong(action.expiresIn) : (action.expiresAt != null && !action.expiresAt.isEmpty() ? ISO_FORMAT.parse(action.expiresAt).getTime() - 100L : System.currentTimeMillis());
            }
            catch (Exception e) {
                this.validUntil = System.currentTimeMillis();
            }
        }
    }
}

