/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.RenameCallback;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class FollowFilter
extends TreeFilter {
    private final PathFilter path;
    final DiffConfig cfg;
    private RenameCallback renameCallback;

    public static FollowFilter create(String path, DiffConfig cfg) {
        return new FollowFilter(PathFilter.create(path), cfg);
    }

    FollowFilter(PathFilter path, DiffConfig cfg) {
        this.path = path;
        this.cfg = cfg;
    }

    public String getPath() {
        return this.path.getPath();
    }

    public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.path.include(walker) && ANY_DIFF.include(walker);
    }

    public boolean shouldBeRecursive() {
        return this.path.shouldBeRecursive() || ANY_DIFF.shouldBeRecursive();
    }

    public TreeFilter clone() {
        return new FollowFilter(this.path.clone(), this.cfg);
    }

    public String toString() {
        return "(FOLLOW(" + this.path.toString() + ")" + " AND " + ANY_DIFF.toString() + ")";
    }

    public RenameCallback getRenameCallback() {
        return this.renameCallback;
    }

    public void setRenameCallback(RenameCallback callback) {
        this.renameCallback = callback;
    }
}

