/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.RebaseTodoLine;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.io.SafeBufferedOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebaseTodoFile {
    private Repository repo;

    public RebaseTodoFile(Repository repo) {
        this.repo = repo;
    }

    public List<RebaseTodoLine> readRebaseTodo(String path, boolean includeComments) throws IOException {
        byte[] buf = IO.readFully(new File(this.repo.getDirectory(), path));
        int ptr = 0;
        int tokenBegin = 0;
        LinkedList<RebaseTodoLine> r = new LinkedList<RebaseTodoLine>();
        while (ptr < buf.length) {
            tokenBegin = ptr;
            ptr = RawParseUtils.nextLF(buf, ptr);
            int lineStart = tokenBegin;
            int lineEnd = ptr - 2;
            if (lineEnd >= 0 && buf[lineEnd] == 13) {
                --lineEnd;
            }
            if (buf[tokenBegin] == 35) {
                if (!includeComments) continue;
                RebaseTodoFile.parseComments(buf, tokenBegin, r, lineEnd);
                continue;
            }
            if ((tokenBegin = RebaseTodoFile.nextParsableToken(buf, tokenBegin, lineEnd)) == -1) {
                if (!includeComments) continue;
                r.add(new RebaseTodoLine(RawParseUtils.decode(buf, lineStart, 1 + lineEnd)));
                continue;
            }
            RebaseTodoLine line = RebaseTodoFile.parseLine(buf, tokenBegin, lineEnd);
            if (line == null) continue;
            r.add(line);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void parseComments(byte[] buf, int tokenBegin, List<RebaseTodoLine> r, int lineEnd) {
        RebaseTodoLine line = null;
        String commentString = RawParseUtils.decode(buf, tokenBegin, lineEnd + 1);
        try {
            try {
                int skip = tokenBegin + 1;
                skip = RebaseTodoFile.nextParsableToken(buf, skip, lineEnd);
                if (skip != -1) {
                    line = RebaseTodoFile.parseLine(buf, skip, lineEnd);
                    line.setAction(RebaseTodoLine.Action.COMMENT);
                    line.setComment(commentString);
                }
            }
            catch (Exception e) {
                line = null;
                Object var8_9 = null;
                if (line == null) {
                    line = new RebaseTodoLine(commentString);
                }
                r.add(line);
                return;
            }
            Object var8_8 = null;
            if (line == null) {
                line = new RebaseTodoLine(commentString);
            }
            r.add(line);
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (line == null) {
                line = new RebaseTodoLine(commentString);
            }
            r.add(line);
            throw throwable;
        }
    }

    private static int nextParsableToken(byte[] buf, int tokenBegin, int lineEnd) {
        while (tokenBegin <= lineEnd && (buf[tokenBegin] == 32 || buf[tokenBegin] == 9 || buf[tokenBegin] == 13)) {
            ++tokenBegin;
        }
        if (tokenBegin > lineEnd) {
            return -1;
        }
        return tokenBegin;
    }

    private static RebaseTodoLine parseLine(byte[] buf, int tokenBegin, int lineEnd) {
        int tokenCount;
        RebaseTodoLine.Action action = null;
        AbbreviatedObjectId commit = null;
        int nextSpace = RawParseUtils.next(buf, tokenBegin, ' ');
        block5: for (tokenCount = 0; tokenCount < 3 && nextSpace < lineEnd; ++tokenCount) {
            switch (tokenCount) {
                case 0: {
                    String actionToken = new String(buf, tokenBegin, nextSpace - tokenBegin - 1);
                    tokenBegin = nextSpace;
                    action = RebaseTodoLine.Action.parse(actionToken);
                    if (action != null) continue block5;
                    return null;
                }
                case 1: {
                    nextSpace = RawParseUtils.next(buf, tokenBegin, ' ');
                    String commitToken = new String(buf, tokenBegin, nextSpace - tokenBegin - 1);
                    tokenBegin = nextSpace;
                    commit = AbbreviatedObjectId.fromString(commitToken);
                    continue block5;
                }
                case 2: {
                    return new RebaseTodoLine(action, commit, RawParseUtils.decode(buf, tokenBegin, 1 + lineEnd));
                }
            }
        }
        if (tokenCount == 2) {
            return new RebaseTodoLine(action, commit, "");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRebaseTodoFile(String path, List<RebaseTodoLine> steps, boolean append) throws IOException {
        SafeBufferedOutputStream fw = new SafeBufferedOutputStream(new FileOutputStream(new File(this.repo.getDirectory(), path), append));
        try {
            StringBuilder sb = new StringBuilder();
            for (RebaseTodoLine step : steps) {
                sb.setLength(0);
                if (RebaseTodoLine.Action.COMMENT.equals((Object)step.action)) {
                    sb.append(step.getComment());
                } else {
                    sb.append(step.getAction().toToken());
                    sb.append(" ");
                    sb.append(step.getCommit().name());
                    sb.append(" ");
                    sb.append(step.getShortMessage().trim());
                }
                sb.append('\n');
                ((OutputStream)fw).write(Constants.encode(sb.toString()));
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            ((OutputStream)fw).close();
            throw throwable;
        }
        ((OutputStream)fw).close();
    }
}

