/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.util.SystemReader;

public class TransferConfig {
    public static final Config.SectionParser<TransferConfig> KEY = new Config.SectionParser<TransferConfig>(){

        @Override
        public TransferConfig parse(Config cfg) {
            return new TransferConfig(cfg);
        }
    };
    private final boolean checkReceivedObjects;
    private final boolean allowLeadingZeroFileMode;
    private final boolean allowInvalidPersonIdent;
    private final boolean safeForWindows;
    private final boolean safeForMacOS;
    private final boolean allowTipSha1InWant;
    private final boolean allowReachableSha1InWant;
    final String[] hideRefs;

    TransferConfig(Repository db) {
        this(db.getConfig());
    }

    TransferConfig(Config rc) {
        this.checkReceivedObjects = rc.getBoolean("fetch", "fsckobjects", rc.getBoolean("transfer", "fsckobjects", false));
        this.allowLeadingZeroFileMode = this.checkReceivedObjects && rc.getBoolean("fsck", "allowLeadingZeroFileMode", false);
        this.allowInvalidPersonIdent = this.checkReceivedObjects && rc.getBoolean("fsck", "allowInvalidPersonIdent", false);
        this.safeForWindows = this.checkReceivedObjects && rc.getBoolean("fsck", "safeForWindows", SystemReader.getInstance().isWindows());
        this.safeForMacOS = this.checkReceivedObjects && rc.getBoolean("fsck", "safeForMacOS", SystemReader.getInstance().isMacOS());
        this.allowTipSha1InWant = rc.getBoolean("uploadpack", "allowtipsha1inwant", false);
        this.allowReachableSha1InWant = rc.getBoolean("uploadpack", "allowreachablesha1inwant", false);
        this.hideRefs = rc.getStringList("uploadpack", null, "hiderefs");
    }

    public ObjectChecker newObjectChecker() {
        if (!this.checkReceivedObjects) {
            return null;
        }
        return new ObjectChecker().setAllowLeadingZeroFileMode(this.allowLeadingZeroFileMode).setAllowInvalidPersonIdent(this.allowInvalidPersonIdent).setSafeForWindows(this.safeForWindows).setSafeForMacOS(this.safeForMacOS);
    }

    public boolean isAllowTipSha1InWant() {
        return this.allowTipSha1InWant;
    }

    public boolean isAllowReachableSha1InWant() {
        return this.allowReachableSha1InWant;
    }

    public RefFilter getRefFilter() {
        if (this.hideRefs.length == 0) {
            return RefFilter.DEFAULT;
        }
        return new RefFilter(){

            @Override
            public Map<String, Ref> filter(Map<String, Ref> refs) {
                HashMap<String, Ref> result = new HashMap<String, Ref>();
                for (Map.Entry<String, Ref> e : refs.entrySet()) {
                    boolean add = true;
                    for (String hide : TransferConfig.this.hideRefs) {
                        if (!e.getKey().equals(hide) && !this.prefixMatch(hide, e.getKey())) continue;
                        add = false;
                        break;
                    }
                    if (!add) continue;
                    result.put(e.getKey(), e.getValue());
                }
                return result;
            }

            private boolean prefixMatch(String p, String s) {
                return p.charAt(p.length() - 1) == '/' && s.startsWith(p);
            }
        };
    }
}

