/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.RelativeDateFormatter;
import org.eclipse.jgit.util.SystemReader;

public class GitDateFormatter {
    private DateFormat dateTimeInstance;
    private DateFormat dateTimeInstance2;
    private final Format format;

    public GitDateFormatter(Format format) {
        this.format = format;
        switch (format) {
            default: {
                break;
            }
            case DEFAULT: {
                this.dateTimeInstance = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy Z", Locale.US);
                break;
            }
            case ISO: {
                this.dateTimeInstance = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.US);
                break;
            }
            case LOCAL: {
                this.dateTimeInstance = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
                break;
            }
            case RFC: {
                this.dateTimeInstance = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
                break;
            }
            case SHORT: {
                this.dateTimeInstance = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                break;
            }
            case LOCALE: 
            case LOCALELOCAL: {
                SystemReader systemReader = SystemReader.getInstance();
                this.dateTimeInstance = systemReader.getDateTimeInstance(2, 2);
                this.dateTimeInstance2 = systemReader.getSimpleDateFormat("Z");
            }
        }
    }

    public String formatDate(PersonIdent ident) {
        switch (this.format) {
            case RAW: {
                int offset = ident.getTimeZoneOffset();
                String sign = offset < 0 ? "-" : "+";
                int offset2 = offset < 0 ? -offset : offset;
                int hours = offset2 / 60;
                int minutes = offset2 % 60;
                return String.format("%d %s%02d%02d", ident.getWhen().getTime() / 1000L, sign, hours, minutes);
            }
            case RELATIVE: {
                return RelativeDateFormatter.format(ident.getWhen());
            }
            case LOCAL: 
            case LOCALELOCAL: {
                this.dateTimeInstance.setTimeZone(SystemReader.getInstance().getTimeZone());
                return this.dateTimeInstance.format(ident.getWhen());
            }
            case LOCALE: {
                TimeZone tz = ident.getTimeZone();
                if (tz == null) {
                    tz = SystemReader.getInstance().getTimeZone();
                }
                this.dateTimeInstance.setTimeZone(tz);
                this.dateTimeInstance2.setTimeZone(tz);
                return String.valueOf(this.dateTimeInstance.format(ident.getWhen())) + " " + this.dateTimeInstance2.format(ident.getWhen());
            }
        }
        TimeZone tz = ident.getTimeZone();
        if (tz == null) {
            tz = SystemReader.getInstance().getTimeZone();
        }
        this.dateTimeInstance.setTimeZone(ident.getTimeZone());
        return this.dateTimeInstance.format(ident.getWhen());
    }

    public static enum Format {
        DEFAULT,
        RELATIVE,
        LOCAL,
        ISO,
        RFC,
        SHORT,
        RAW,
        LOCALE,
        LOCALELOCAL;

    }
}

