/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.service.jib;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.api.buildplan.Port;
import com.google.cloud.tools.jib.event.events.ProgressEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.api.assembly.BuildDirs;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyFileEntry;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.service.jib.JibLogger;

public class JibServiceUtil {
    private static final long JIB_EXECUTOR_SHUTDOWN_TIMEOUT_SECONDS = 10L;
    private static final String BUSYBOX = "busybox:latest";

    private JibServiceUtil() {
    }

    public static void buildContainer(JibContainerBuilder jibContainerBuilder, TarImage image, JibLogger logger) throws InterruptedException {
        ExecutorService jibBuildExecutor = Executors.newCachedThreadPool();
        try {
            jibContainerBuilder.setCreationTime(Instant.now());
            jibContainerBuilder.containerize(Containerizer.to((TarImage)image).setAllowInsecureRegistries(true).setExecutorService(jibBuildExecutor).addEventHandler(LogEvent.class, (Consumer)logger).addEventHandler(ProgressEvent.class, (Consumer)logger.progressEventHandler()));
            logger.updateFinished();
        }
        catch (CacheDirectoryCreationException | RegistryException | IOException | ExecutionException ex) {
            throw new IllegalStateException("Unable to build the image tarball: " + ex.getMessage(), ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw ex;
        }
        finally {
            jibBuildExecutor.shutdown();
            jibBuildExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    public static JibContainerBuilder containerFromImageConfiguration(ImageConfiguration imageConfiguration, String pullRegistry, Credential pullRegistryCredential) throws InvalidImageReferenceException {
        JibContainerBuilder containerBuilder = Jib.from((RegistryImage)JibServiceUtil.toRegistryImage(JibServiceUtil.getBaseImage(imageConfiguration, pullRegistry), pullRegistryCredential)).setFormat(ImageFormat.Docker);
        return JibServiceUtil.populateContainerBuilderFromImageConfiguration(containerBuilder, imageConfiguration);
    }

    public static String getFullImageName(ImageConfiguration imageConfiguration, String tag) {
        ImageName imageName = tag != null ? new ImageName(imageConfiguration.getName(), tag) : new ImageName(imageConfiguration.getName());
        return imageName.getFullName();
    }

    public static void jibPush(ImageConfiguration imageConfiguration, Credential pushCredentials, File tarArchive, JibLogger log) {
        String imageName = JibServiceUtil.getFullImageName(imageConfiguration, null);
        List additionalTags = imageConfiguration.getBuildConfiguration().getTags();
        try {
            JibServiceUtil.pushImage(TarImage.at((Path)tarArchive.toPath()), additionalTags, imageName, pushCredentials, log);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread Interrupted", e);
        }
    }

    private static void pushImage(TarImage baseImage, List<String> additionalTags, String targetImageName, Credential credential, JibLogger logger) throws InterruptedException {
        ExecutorService jibBuildExecutor = Executors.newCachedThreadPool();
        try {
            JibServiceUtil.submitPushToJib(baseImage, JibServiceUtil.toRegistryImage(targetImageName, credential), additionalTags, jibBuildExecutor, logger);
        }
        catch (CacheDirectoryCreationException | InvalidImageReferenceException | RegistryException | IOException | ExecutionException e) {
            throw new IllegalStateException("Exception occurred while pushing the image: " + targetImageName + ", " + e.getMessage(), e);
        }
        finally {
            jibBuildExecutor.shutdown();
            jibBuildExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    private static JibContainerBuilder populateContainerBuilderFromImageConfiguration(JibContainerBuilder containerBuilder, ImageConfiguration imageConfiguration) {
        Optional<BuildConfiguration> bic = Optional.ofNullable(Objects.requireNonNull(imageConfiguration).getBuildConfiguration());
        bic.map(BuildConfiguration::getEntryPoint).map(Arguments::asStrings).ifPresent(arg_0 -> ((JibContainerBuilder)containerBuilder).setEntrypoint(arg_0));
        bic.map(BuildConfiguration::getEnv).ifPresent(arg_0 -> ((JibContainerBuilder)containerBuilder).setEnvironment(arg_0));
        bic.map(BuildConfiguration::getPorts).map(Collection::stream).map(s -> s.map(Integer::parseInt).map(Port::tcp)).map(s -> s.collect(Collectors.toSet())).ifPresent(arg_0 -> ((JibContainerBuilder)containerBuilder).setExposedPorts(arg_0));
        bic.map(BuildConfiguration::getLabels).map(Map::entrySet).ifPresent(labels -> labels.forEach(l -> {
            if (l.getKey() != null && l.getValue() != null) {
                containerBuilder.addLabel((String)l.getKey(), (String)l.getValue());
            }
        }));
        bic.map(BuildConfiguration::getCmd).map(Arguments::asStrings).ifPresent(arg_0 -> ((JibContainerBuilder)containerBuilder).setProgramArguments(arg_0));
        bic.map(BuildConfiguration::getUser).ifPresent(arg_0 -> ((JibContainerBuilder)containerBuilder).setUser(arg_0));
        bic.map(BuildConfiguration::getVolumes).map(Collection::stream).map(s -> s.map(AbsoluteUnixPath::get)).map(s -> s.collect(Collectors.toSet())).ifPresent(arg_0 -> ((JibContainerBuilder)containerBuilder).setVolumes(arg_0));
        bic.map(BuildConfiguration::getWorkdir).filter(((Predicate<String>)String::isEmpty).negate()).map(AbsoluteUnixPath::get).ifPresent(arg_0 -> ((JibContainerBuilder)containerBuilder).setWorkingDirectory(arg_0));
        return containerBuilder;
    }

    private static void submitPushToJib(TarImage baseImage, RegistryImage targetImage, List<String> additionalTags, ExecutorService jibBuildExecutor, JibLogger logger) throws InterruptedException, ExecutionException, RegistryException, CacheDirectoryCreationException, IOException {
        Jib.from((TarImage)baseImage).setCreationTime(Instant.now()).containerize(JibServiceUtil.createJibContainerizer(targetImage, additionalTags, jibBuildExecutor, logger));
        logger.updateFinished();
    }

    private static Containerizer createJibContainerizer(RegistryImage targetImage, List<String> additionalTags, ExecutorService jibBuildExecutor, JibLogger logger) {
        Containerizer containerizer = Containerizer.to((RegistryImage)targetImage).setAllowInsecureRegistries(true).setExecutorService(jibBuildExecutor).addEventHandler(LogEvent.class, (Consumer)logger).addEventHandler(ProgressEvent.class, (Consumer)logger.progressEventHandler());
        if (additionalTags != null) {
            additionalTags.forEach(arg_0 -> ((Containerizer)containerizer).withAdditionalTag(arg_0));
        }
        return containerizer;
    }

    private static RegistryImage toRegistryImage(String imageReference, Credential credential) throws InvalidImageReferenceException {
        RegistryImage registryImage = RegistryImage.named((String)imageReference);
        if (credential != null && !credential.getUsername().isEmpty() && !credential.getPassword().isEmpty()) {
            registryImage.addCredential(credential.getUsername(), credential.getPassword());
        }
        return registryImage;
    }

    public static String getBaseImage(ImageConfiguration imageConfiguration, String optionalRegistry) {
        String baseImage = Optional.ofNullable(imageConfiguration).map(ImageConfiguration::getBuildConfiguration).map(BuildConfiguration::getFrom).filter(((Predicate<String>)String::isEmpty).negate()).orElse(BUSYBOX);
        return new ImageName(baseImage).getFullName(optionalRegistry);
    }

    @Nonnull
    public static List<FileEntriesLayer> layers(BuildDirs buildDirs, Map<Assembly, List<AssemblyFileEntry>> layers) {
        ArrayList<FileEntriesLayer> fileEntriesLayers = new ArrayList<FileEntriesLayer>();
        for (Map.Entry<Assembly, List<AssemblyFileEntry>> layer : layers.entrySet()) {
            Path outputPath;
            FileEntriesLayer.Builder fel = FileEntriesLayer.builder();
            String layerId = layer.getKey().getId();
            if (StringUtils.isBlank((CharSequence)layerId)) {
                outputPath = buildDirs.getOutputDirectory().toPath();
            } else {
                fel.setName(layerId);
                outputPath = new File(buildDirs.getOutputDirectory(), layerId).toPath();
            }
            for (AssemblyFileEntry afe : layer.getValue()) {
                Path source = afe.getSource().toPath();
                AbsoluteUnixPath target = AbsoluteUnixPath.get((String)StringUtils.prependIfMissing((String)FilenameUtils.separatorsToUnix((String)outputPath.relativize(afe.getDest().toPath()).normalize().toString()), (CharSequence)"/", (CharSequence[])new CharSequence[0]));
                FilePermissions permissions = StringUtils.isNotBlank((CharSequence)afe.getFileMode()) ? FilePermissions.fromOctalString((String)StringUtils.right((String)afe.getFileMode(), (int)3)) : FileEntriesLayer.DEFAULT_FILE_PERMISSIONS_PROVIDER.get(source, target);
                fel.addEntry(source, target, permissions);
            }
            fileEntriesLayers.add(fel.build());
        }
        return fileEntriesLayers;
    }
}

