/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.File;

public class AssemblyFileEntry {
    private long lastModified;
    private File source;
    private File dest;
    private String fileMode;

    public AssemblyFileEntry(File source, File dest, String fileMode) {
        this.lastModified = source.lastModified();
        this.source = source;
        this.dest = dest;
        this.fileMode = fileMode;
    }

    public boolean isUpdated() {
        if (this.source.lastModified() > this.lastModified) {
            this.lastModified = this.source.lastModified();
            return true;
        }
        return false;
    }

    public static AssemblyFileEntryBuilder builder() {
        return new AssemblyFileEntryBuilder();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public File getSource() {
        return this.source;
    }

    public File getDest() {
        return this.dest;
    }

    public String getFileMode() {
        return this.fileMode;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    public void setFileMode(String fileMode) {
        this.fileMode = fileMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssemblyFileEntry)) {
            return false;
        }
        AssemblyFileEntry other = (AssemblyFileEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLastModified() != other.getLastModified()) {
            return false;
        }
        File this$source = this.getSource();
        File other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        File this$dest = this.getDest();
        File other$dest = other.getDest();
        if (this$dest == null ? other$dest != null : !((Object)this$dest).equals(other$dest)) {
            return false;
        }
        String this$fileMode = this.getFileMode();
        String other$fileMode = other.getFileMode();
        return !(this$fileMode == null ? other$fileMode != null : !this$fileMode.equals(other$fileMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssemblyFileEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastModified = this.getLastModified();
        result = result * 59 + (int)($lastModified >>> 32 ^ $lastModified);
        File $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        File $dest = this.getDest();
        result = result * 59 + ($dest == null ? 43 : ((Object)$dest).hashCode());
        String $fileMode = this.getFileMode();
        result = result * 59 + ($fileMode == null ? 43 : $fileMode.hashCode());
        return result;
    }

    public static class AssemblyFileEntryBuilder {
        private File source;
        private File dest;
        private String fileMode;

        AssemblyFileEntryBuilder() {
        }

        public AssemblyFileEntryBuilder source(File source) {
            this.source = source;
            return this;
        }

        public AssemblyFileEntryBuilder dest(File dest) {
            this.dest = dest;
            return this;
        }

        public AssemblyFileEntryBuilder fileMode(String fileMode) {
            this.fileMode = fileMode;
            return this;
        }

        public AssemblyFileEntry build() {
            return new AssemblyFileEntry(this.source, this.dest, this.fileMode);
        }

        public String toString() {
            return "AssemblyFileEntry.AssemblyFileEntryBuilder(source=" + this.source + ", dest=" + this.dest + ", fileMode=" + this.fileMode + ")";
        }
    }
}

