/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jkube.kit.common.util.EnvUtil;

public class PortMapping {
    private static final Pattern PROTOCOL_SPLIT_PATTERN = Pattern.compile("(.*?)(?:/(tcp|udp))?$");
    private final Map<String, String> bindToHostMap = new HashMap<String, String>();
    private final Map<String, Integer> containerPortToHostPort = new HashMap<String, Integer>();
    private final Map<String, Integer> hostPortVariableMap = new HashMap<String, Integer>();
    private final Properties projProperties;
    private final Map<String, String> specToHostIpVariableMap = new HashMap<String, String>();
    private final Map<String, String> specToHostPortVariableMap = new HashMap<String, String>();

    public PortMapping(List<String> portMappings, Properties projProperties) {
        this.projProperties = projProperties;
        for (String portMapping : portMappings) {
            this.parsePortMapping(portMapping);
        }
    }

    public JsonArray toJson() {
        Map<String, Integer> portMap = this.getContainerPortToHostPortMap();
        if (portMap.isEmpty()) {
            return null;
        }
        JsonArray ret = new JsonArray();
        Map<String, String> bindToMap = this.getBindToHostMap();
        for (Map.Entry<String, Integer> entry : portMap.entrySet()) {
            Integer hostPort;
            JsonObject mapping = new JsonObject();
            String containerPortSpec = entry.getKey();
            Matcher matcher = PROTOCOL_SPLIT_PATTERN.matcher(entry.getKey());
            if (!matcher.matches()) {
                throw new IllegalStateException("Internal error: " + entry.getKey() + " doesn't contain protocol part and doesn't match " + PROTOCOL_SPLIT_PATTERN);
            }
            mapping.addProperty("containerPort", (Number)Integer.parseInt(matcher.group(1)));
            if (matcher.group(2) != null) {
                mapping.addProperty("protocol", matcher.group(2));
            }
            if ((hostPort = entry.getValue()) != null) {
                mapping.addProperty("hostPort", (Number)hostPort);
            }
            if (bindToMap.containsKey(containerPortSpec)) {
                mapping.addProperty("hostIP", bindToMap.get(containerPortSpec));
            }
            ret.add((JsonElement)mapping);
        }
        return ret;
    }

    Map<String, String> getBindToHostMap() {
        return this.bindToHostMap;
    }

    Map<String, Integer> getContainerPortToHostPortMap() {
        return this.containerPortToHostPort;
    }

    private IllegalArgumentException createInvalidMappingError(String mapping, Exception exp) {
        return new IllegalArgumentException("\nInvalid port mapping '" + mapping + "'\nRequired format: '<hostIP>:<hostPort>:<containerPort>(/tcp|udp)'\nSee the reference manual for more details");
    }

    private void createMapping(String[] parts, String protocol) {
        if (parts.length == 3) {
            this.mapBindToAndHostPortSpec(parts[0], parts[1], this.createPortSpec(parts[2], protocol));
        } else if (parts.length == 2) {
            this.mapHostPortToSpec(parts[0], this.createPortSpec(parts[1], protocol));
        } else {
            this.mapHostPortToSpec(null, this.createPortSpec(parts[0], protocol));
        }
    }

    private String createPortSpec(String port, String protocol) {
        return Integer.parseInt(port) + "/" + protocol;
    }

    private Integer getAsIntOrNull(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException exp) {
            return null;
        }
    }

    private Integer getPortFromProjectOrSystemProperty(String var) {
        String sysProp = System.getProperty(var);
        if (sysProp != null) {
            return this.getAsIntOrNull(sysProp);
        }
        if (this.projProperties.containsKey(var)) {
            return this.getAsIntOrNull(this.projProperties.getProperty(var));
        }
        return null;
    }

    private String extractPortPropertyName(String name) {
        String mavenPropName = EnvUtil.extractMavenPropertyName(name);
        return mavenPropName != null ? mavenPropName : name;
    }

    private void mapBindToAndHostPortSpec(String bindTo, String hPort, String portSpec) {
        this.mapHostPortToSpec(hPort, portSpec);
        String hostPropName = this.extractHostPropertyName(bindTo);
        if (hostPropName != null) {
            String host = this.projProperties.getProperty(hostPropName);
            if (host != null) {
                this.bindToHostMap.put(portSpec, this.resolveHostname(host));
            }
            this.specToHostIpVariableMap.put(portSpec, hostPropName);
        } else {
            this.bindToHostMap.put(portSpec, this.resolveHostname(bindTo));
        }
    }

    private String extractHostPropertyName(String name) {
        if (name.startsWith("+")) {
            return name.substring(1);
        }
        return EnvUtil.extractMavenPropertyName(name);
    }

    private void mapHostPortToSpec(String hPort, String portSpec) {
        Integer hostPort;
        if (hPort == null) {
            hostPort = null;
        } else {
            try {
                hostPort = Integer.parseInt(hPort);
            }
            catch (NumberFormatException exp) {
                String portPropertyName = this.extractPortPropertyName(hPort);
                hostPort = this.getPortFromProjectOrSystemProperty(portPropertyName);
                if (hostPort != null) {
                    this.hostPortVariableMap.put(portPropertyName, hostPort);
                }
                this.specToHostPortVariableMap.put(portSpec, portPropertyName);
            }
        }
        this.containerPortToHostPort.put(portSpec, hostPort);
    }

    private void parsePortMapping(String input) {
        try {
            Matcher matcher = PROTOCOL_SPLIT_PATTERN.matcher(input);
            matcher.matches();
            String mapping = matcher.group(1);
            String protocol = matcher.group(2);
            if (protocol == null) {
                protocol = "tcp";
            }
            this.createMapping(mapping.split(":", 3), protocol);
        }
        catch (NullPointerException | NumberFormatException exp) {
            throw this.createInvalidMappingError(input, exp);
        }
    }

    private String resolveHostname(String bindToHost) {
        try {
            return InetAddress.getByName(bindToHost).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Host '" + bindToHost + "' to bind to cannot be resolved");
        }
    }
}

