/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.archive;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFileEntry;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.util.FileUtil;

public class AssemblyFileSetUtils {
    private static final String PATH_TO_SELF = ".";
    private static final String DIRECTORY_MODE_DEFAULT = "040755";
    private static final String FILE_MODE_DEFAULT = "0644";

    private AssemblyFileSetUtils() {
    }

    @Nonnull
    public static List<AssemblyFileEntry> calculateFilePermissions(File source, File dest, AssemblyFileSet assemblyFileSet) {
        ArrayList<AssemblyFileEntry> ret = new ArrayList<AssemblyFileEntry>();
        String fileMode = Optional.ofNullable(assemblyFileSet.getFileMode()).orElse(FILE_MODE_DEFAULT);
        if (dest.isDirectory()) {
            String directoryMode = Optional.ofNullable(assemblyFileSet.getDirectoryMode()).orElse(DIRECTORY_MODE_DEFAULT);
            ret.add(new AssemblyFileEntry(source, dest, directoryMode));
            FileUtil.listFilesAndDirsRecursivelyInDirectory(dest).forEach(f -> {
                File s = source.toPath().resolve(dest.toPath().relativize(f.toPath())).toFile();
                if (f.isDirectory()) {
                    ret.add(new AssemblyFileEntry(s, (File)f, directoryMode));
                } else if (f.isFile()) {
                    ret.add(new AssemblyFileEntry(s, (File)f, fileMode));
                }
            });
        } else if (dest.isFile()) {
            ret.add(new AssemblyFileEntry(source, dest, fileMode));
        }
        return ret;
    }

    @Nonnull
    public static List<AssemblyFileEntry> processAssemblyFileSet(File baseDirectory, File outputDirectory, AssemblyFileSet assemblyFileSet, Assembly layer, AssemblyConfiguration assemblyConfiguration) throws IOException {
        File sourceDirectory = AssemblyFileSetUtils.resolveSourceDirectory(baseDirectory, assemblyFileSet);
        Objects.requireNonNull(assemblyConfiguration.getTargetDir(), "Assembly Configuration target dir is required");
        if (!sourceDirectory.exists()) {
            return Collections.emptyList();
        }
        File targetDirectory = StringUtils.isNotBlank((CharSequence)layer.getId()) ? new File(new File(outputDirectory, layer.getId()), assemblyConfiguration.getTargetDir()) : new File(outputDirectory, assemblyConfiguration.getTargetDir());
        File destinationDirectory = assemblyFileSet.getOutputDirectory() == null ? new File(targetDirectory, sourceDirectory.getName()) : (assemblyFileSet.getOutputDirectory().isAbsolute() ? assemblyFileSet.getOutputDirectory() : (assemblyFileSet.getOutputDirectory().getPath().equals(PATH_TO_SELF) ? targetDirectory : targetDirectory.toPath().resolve(assemblyFileSet.getOutputDirectory().getPath()).toFile()));
        List<String> includes = Optional.ofNullable(assemblyFileSet.getIncludes()).filter(i -> !i.isEmpty()).orElse(Collections.singletonList(PATH_TO_SELF));
        ArrayList<AssemblyFileEntry> allEntries = new ArrayList<AssemblyFileEntry>();
        for (String include : includes) {
            String effectiveInclude = AssemblyFileSetUtils.isSelfPath(include) ? "**" : include;
            allEntries.addAll(AssemblyFileSetUtils.processInclude(sourceDirectory.toPath(), effectiveInclude, destinationDirectory.toPath(), assemblyFileSet));
        }
        return allEntries;
    }

    private static Set<AssemblyFileEntry> processInclude(Path sourceDirectory, String include, Path destinationDirectory, AssemblyFileSet assemblyFileSet) throws IOException {
        LinkedHashSet<AssemblyFileEntry> entries = new LinkedHashSet<AssemblyFileEntry>();
        for (File sourceFile : AssemblyFileSetUtils.findFilesUsingGlobMatcher(sourceDirectory, include, assemblyFileSet)) {
            File destFile = destinationDirectory.resolve(sourceDirectory.relativize(sourceFile.toPath())).toFile();
            FileUtil.createDirectory(destFile.getParentFile());
            entries.addAll(AssemblyFileSetUtils.copy(sourceDirectory, sourceFile, destFile, assemblyFileSet));
        }
        return entries;
    }

    private static List<File> findFilesUsingGlobMatcher(Path sourceDirectory, String include, AssemblyFileSet assemblyFileSet) throws IOException {
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(String.format("glob:%s", include));
        try (Stream<Path> sourceDirectoryStream = Files.walk(sourceDirectory, new FileVisitOption[0]);){
            List<File> list = sourceDirectoryStream.filter(p -> pathMatcher.matches(sourceDirectory.relativize((Path)p))).filter(AssemblyFileSetUtils.isNotExcluded(sourceDirectory, assemblyFileSet)).map(Path::normalize).map(Path::toFile).collect(Collectors.toList());
            return list;
        }
    }

    static File resolveSourceDirectory(File baseDirectory, AssemblyFileSet assemblyFileSet) {
        Path sourceDirectory = Objects.requireNonNull(assemblyFileSet.getDirectory(), "Assembly FileSet directory is required").isAbsolute() ? assemblyFileSet.getDirectory().toPath() : baseDirectory.toPath().resolve(assemblyFileSet.getDirectory().toPath());
        return sourceDirectory.normalize().toFile();
    }

    static boolean isSelfPath(String path) {
        return StringUtils.isBlank((CharSequence)path) || path.equals(PATH_TO_SELF);
    }

    private static List<AssemblyFileEntry> copy(Path sourceDirectory, File source, File target, AssemblyFileSet assemblyFileSet) throws IOException {
        if (source.exists() && AssemblyFileSetUtils.isNotExcluded(sourceDirectory, assemblyFileSet).test(source.toPath())) {
            if (source.isDirectory()) {
                FileUtils.forceMkdir((File)target);
                for (File sourceChild : Optional.ofNullable(source.listFiles()).orElse(new File[0])) {
                    AssemblyFileSetUtils.copy(sourceDirectory, sourceChild, new File(target, sourceChild.getName()), assemblyFileSet);
                }
            } else {
                FileUtil.copy(source, target);
            }
            return AssemblyFileSetUtils.calculateFilePermissions(source, target, assemblyFileSet);
        }
        return Collections.emptyList();
    }

    @Nonnull
    static Predicate<Path> isNotExcluded(@Nonnull Path sourceDirectory, @Nonnull AssemblyFileSet afs) {
        List<PathMatcher> excludePM = AssemblyFileSetUtils.excludePathMatchers(afs);
        return path -> excludePM.stream().noneMatch(pm -> pm.matches(sourceDirectory.relativize((Path)path).normalize()));
    }

    @Nonnull
    private static List<PathMatcher> excludePathMatchers(@Nonnull AssemblyFileSet fileSet) {
        return Optional.ofNullable(fileSet.getExcludes()).orElse(Collections.emptyList()).stream().map(exclude -> FileSystems.getDefault().getPathMatcher(String.format("glob:%s", exclude))).collect(Collectors.toList());
    }
}

