/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jkube.kit.common.util.EnvUtil;

public class BuildReferenceDateUtil {
    private BuildReferenceDateUtil() {
    }

    static Date getBuildReferenceDate(String buildDirectory, String dockerBuildTimestampFile) throws IOException {
        return Optional.ofNullable(EnvUtil.loadTimestamp(BuildReferenceDateUtil.getBuildTimestampFile(buildDirectory, dockerBuildTimestampFile))).orElse(new Date());
    }

    public static File getBuildTimestampFile(String projectBuildDirectory, String dockerBuildTimestampFile) {
        return new File(projectBuildDirectory, dockerBuildTimestampFile);
    }

    public static Date getBuildTimestamp(Map<String, Object> pluginContext, String buildTimestampContextKey, String projectBuildDir, String dockerBuildTimestampFile) throws IOException {
        Date now = (Date)(pluginContext != null ? pluginContext.get(buildTimestampContextKey) : null);
        if (now == null) {
            now = BuildReferenceDateUtil.getBuildReferenceDate(projectBuildDir, dockerBuildTimestampFile);
            if (pluginContext != null) {
                pluginContext.put(buildTimestampContextKey, now);
            }
        }
        return now;
    }
}

