/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.HTTPHeader;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HasMetadataComparator;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.DaemonSetSpec;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.authorization.v1.ResourceAttributesBuilder;
import io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectAccessReview;
import io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectAccessReviewBuilder;
import io.fabric8.kubernetes.api.model.authorization.v1.SelfSubjectAccessReviewFluent;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpec;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.AsyncUtil;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.ResourceUtil;

public class KubernetesHelper {
    protected static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.n]X");
    private static final String FILENAME_PATTERN_REGEX = "^(?<name>.*?)(-(?<type>[^-]+))?\\.(?<ext>yaml|yml|json)$";
    private static final String PROFILES_PATTERN_REGEX = "^profiles?\\.ya?ml$";
    public static final Pattern FILENAME_PATTERN = Pattern.compile("^(?<name>.*?)(-(?<type>[^-]+))?\\.(?<ext>yaml|yml|json)$", 2);
    public static final Pattern PROFILES_PATTERN = Pattern.compile("^profiles?\\.ya?ml$", 2);
    protected static final String[] POD_CONTROLLER_KINDS = new String[]{"ReplicationController", "ReplicaSet", "Deployment", "DeploymentConfig", "StatefulSet", "DaemonSet", "Job", "CronJob"};

    private KubernetesHelper() {
    }

    public static String validateKubernetesId(String currentValue, String description) {
        if (StringUtils.isBlank((CharSequence)currentValue)) {
            throw new IllegalArgumentException("No " + description + " is specified!");
        }
        int size = currentValue.length();
        for (int i = 0; i < size; ++i) {
            char ch = currentValue.charAt(i);
            if (!Character.isUpperCase(ch)) continue;
            throw new IllegalArgumentException("Invalid upper case letter '" + ch + "' at index " + i + " for " + description + " value: " + currentValue);
        }
        return currentValue;
    }

    public static String validateCronJobSchedule(String schedule) {
        if (StringUtils.isBlank((CharSequence)schedule)) {
            throw new IllegalArgumentException("No schedule is specified!");
        }
        return schedule;
    }

    public static Map<String, String> getOrCreateAnnotations(HasMetadata entity) {
        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata(entity);
        LinkedHashMap answer = metadata.getAnnotations();
        if (answer == null) {
            answer = new LinkedHashMap();
            metadata.setAnnotations(answer);
        }
        return answer;
    }

    public static ObjectMeta getOrCreateMetadata(HasMetadata entity) {
        ObjectMeta metadata = entity.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
            entity.setMetadata(metadata);
        }
        return metadata;
    }

    public static Map<String, String> getOrCreateLabels(HasMetadata entity) {
        ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata(entity);
        LinkedHashMap answer = metadata.getLabels();
        if (answer == null) {
            answer = new LinkedHashMap();
            metadata.setLabels(answer);
        }
        return answer;
    }

    public static String getResourceVersion(HasMetadata entity) {
        String resourceVersion;
        ObjectMeta metadata;
        if (entity != null && (metadata = entity.getMetadata()) != null && StringUtils.isNotBlank((CharSequence)(resourceVersion = metadata.getResourceVersion()))) {
            return resourceVersion;
        }
        return null;
    }

    public static Map<String, String> getLabels(HasMetadata entity) {
        if (entity != null) {
            return KubernetesHelper.getLabels(entity.getMetadata());
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> getLabels(ObjectMeta metadata) {
        Map labels;
        if (metadata != null && (labels = metadata.getLabels()) != null) {
            return labels;
        }
        return Collections.emptyMap();
    }

    public static String getName(HasMetadata entity) {
        if (entity != null) {
            return KubernetesHelper.getName(entity.getMetadata());
        }
        return null;
    }

    public static String getName(ObjectMeta entity) {
        if (entity != null) {
            for (String name : new String[]{entity.getName(), KubernetesHelper.getAdditionalPropertyText(entity.getAdditionalProperties(), "id"), entity.getUid()}) {
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                return name;
            }
        }
        return null;
    }

    public static String getNamespace(ObjectMeta entity) {
        if (entity != null) {
            return entity.getNamespace();
        }
        return null;
    }

    public static String getNamespace(HasMetadata entity) {
        if (entity != null) {
            return KubernetesHelper.getNamespace(entity.getMetadata());
        }
        return null;
    }

    public static String getKind(KubernetesResource entity) {
        if (entity != null) {
            if (entity instanceof KubernetesList) {
                return "List";
            }
            if (entity instanceof HasMetadata) {
                return ((HasMetadata)entity).getKind();
            }
            return entity.getClass().getSimpleName();
        }
        return null;
    }

    public static boolean isPodRunning(Pod pod) {
        return KubernetesHelper.isInPodPhase(pod, "run");
    }

    public static boolean isPodWaiting(Pod pod) {
        return KubernetesHelper.isInPodPhase(pod, "wait");
    }

    public static boolean isPodReady(Pod pod) {
        if (!KubernetesHelper.isPodRunning(pod)) {
            return false;
        }
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return true;
        }
        List conditions = podStatus.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return true;
        }
        for (PodCondition condition : conditions) {
            if (!"ready".equalsIgnoreCase(condition.getType())) continue;
            return Boolean.parseBoolean(condition.getStatus());
        }
        return true;
    }

    private static boolean isInPodPhase(Pod pod, String phase) {
        return KubernetesHelper.getPodPhase(pod).toLowerCase().startsWith(phase);
    }

    public static String getPodPhase(Pod pod) {
        PodStatus podStatus;
        if (pod != null && (podStatus = pod.getStatus()) != null) {
            String actualPhase = podStatus.getPhase();
            return actualPhase != null ? actualPhase : "";
        }
        return "";
    }

    public static List<Container> getContainers(Pod pod) {
        if (pod != null) {
            PodSpec podSpec = pod.getSpec();
            return KubernetesHelper.getContainers(podSpec);
        }
        return Collections.emptyList();
    }

    public static List<Container> getContainers(PodSpec podSpec) {
        if (podSpec != null) {
            return podSpec.getContainers();
        }
        return Collections.emptyList();
    }

    private static String getAdditionalPropertyText(Map<String, Object> additionalProperties, String name) {
        Object value;
        if (additionalProperties != null && (value = additionalProperties.get(name)) != null) {
            return value.toString();
        }
        return null;
    }

    public static String getDefaultNamespace() {
        String ns = new ConfigBuilder().build().getNamespace();
        return ns != null ? ns : "default";
    }

    public static void handleKubernetesClientException(KubernetesClientException e, KitLogger logger) {
        Throwable cause = e.getCause();
        if (cause instanceof UnknownHostException) {
            logger.error("Could not connect to kubernetes cluster!", new Object[0]);
            logger.error("Have you started a local cluster or connected to a remote cluster via `kubectl`?", new Object[0]);
            logger.info("For more help see: https://www.eclipse.dev/jkube/docs/#getting-started", new Object[0]);
            logger.error("Connection error: %s", cause);
            String message = "Could not connect to kubernetes cluster. Have you started a local cluster or connected to a remote cluster via `kubectl`? Error: " + cause;
            throw new IllegalStateException(message, e);
        }
        throw new IllegalStateException(e.getMessage(), e);
    }

    public static List<HasMetadata> loadResources(File manifest) throws IOException {
        return ResourceUtil.deserializeKubernetesListOrTemplate(manifest).stream().distinct().sorted(new HasMetadataComparator()).collect(Collectors.toList());
    }

    public static String getBuildStatusPhase(Build build) {
        if (build != null && build.getStatus() != null) {
            return build.getStatus().getPhase();
        }
        return null;
    }

    public static CompletableFuture<Void> printLogsAsync(LogWatch logWatcher, Consumer<String> lineConsumer) {
        LineIterator it = IOUtils.lineIterator((InputStream)logWatcher.getOutput(), (Charset)StandardCharsets.UTF_8);
        return AsyncUtil.async(cf -> {
            while (it.hasNext()) {
                String line = it.nextLine();
                if (line == null) {
                    cf.complete(null);
                } else {
                    lineConsumer.accept(line);
                }
                if (!cf.isDone()) continue;
                return null;
            }
            return null;
        });
    }

    public static String getBuildStatusReason(Build build) {
        if (build != null && build.getStatus() != null) {
            String reason = build.getStatus().getReason();
            String phase = build.getStatus().getPhase();
            if (StringUtils.isNotBlank((CharSequence)phase)) {
                if (StringUtils.isNotBlank((CharSequence)reason)) {
                    return phase + ": " + reason;
                }
                return phase;
            }
            return (String)StringUtils.defaultIfEmpty((CharSequence)reason, (CharSequence)"");
        }
        return "";
    }

    public static FilterWatchListDeletable<Pod, PodList, PodResource> withSelector(NonNamespaceOperation<Pod, PodList, PodResource> pods, LabelSelector selector, KitLogger log) {
        List matchExpressions;
        FilterWatchListDeletable answer = pods;
        Map matchLabels = selector.getMatchLabels();
        if (matchLabels != null && !matchLabels.isEmpty()) {
            answer = (FilterWatchListDeletable)answer.withLabels(matchLabels);
        }
        if ((matchExpressions = selector.getMatchExpressions()) != null) {
            block8: for (LabelSelectorRequirement expression : matchExpressions) {
                String operator;
                String key = expression.getKey();
                List values = expression.getValues();
                if (StringUtils.isBlank((CharSequence)key)) {
                    log.warn("Ignoring empty key in selector expression %s", expression);
                    continue;
                }
                if (values == null || values.isEmpty()) {
                    log.warn("Ignoring empty values in selector expression %s", expression);
                    continue;
                }
                String[] valuesArray = values.toArray(new String[values.size()]);
                switch (operator = expression.getOperator()) {
                    case "In": {
                        answer = (FilterWatchListDeletable)answer.withLabelIn(key, valuesArray);
                        continue block8;
                    }
                    case "NotIn": {
                        answer = (FilterWatchListDeletable)answer.withLabelNotIn(key, valuesArray);
                        continue block8;
                    }
                }
                log.warn("Ignoring unknown operator %s in selector expression %s", operator, expression);
            }
        }
        return answer;
    }

    public static LabelSelector extractPodLabelSelector(Collection<HasMetadata> entities) {
        LabelSelector chosenSelector = null;
        for (HasMetadata entity : entities) {
            LabelSelector selector = KubernetesHelper.extractPodLabelSelector(entity);
            if (selector == null) continue;
            if (chosenSelector != null && !chosenSelector.equals((Object)selector)) {
                throw new IllegalArgumentException("Multiple selectors found for the given entities: " + chosenSelector + " - " + selector);
            }
            chosenSelector = selector;
        }
        return chosenSelector;
    }

    public static LabelSelector extractPodLabelSelector(HasMetadata entity) {
        LabelSelector selector = null;
        if (entity instanceof Deployment) {
            Deployment resource = (Deployment)entity;
            DeploymentSpec spec = resource.getSpec();
            if (spec != null) {
                selector = spec.getSelector();
            }
        } else if (entity instanceof ReplicaSet) {
            ReplicaSet resource = (ReplicaSet)entity;
            ReplicaSetSpec spec = resource.getSpec();
            if (spec != null) {
                selector = spec.getSelector();
            }
        } else if (entity instanceof DeploymentConfig) {
            DeploymentConfig resource = (DeploymentConfig)entity;
            DeploymentConfigSpec spec = resource.getSpec();
            if (spec != null) {
                selector = KubernetesHelper.toLabelSelector(spec.getSelector());
            }
        } else if (entity instanceof ReplicationController) {
            ReplicationController resource = (ReplicationController)entity;
            ReplicationControllerSpec spec = resource.getSpec();
            if (spec != null) {
                selector = KubernetesHelper.toLabelSelector(spec.getSelector());
            }
        } else if (entity instanceof DaemonSet) {
            DaemonSet resource = (DaemonSet)entity;
            DaemonSetSpec spec = resource.getSpec();
            if (spec != null) {
                selector = spec.getSelector();
            }
        } else if (entity instanceof StatefulSet) {
            StatefulSet resource = (StatefulSet)entity;
            StatefulSetSpec spec = resource.getSpec();
            if (spec != null) {
                selector = spec.getSelector();
            }
        } else if (entity instanceof Job) {
            selector = KubernetesHelper.toLabelSelector((Job)entity);
        }
        return selector;
    }

    private static LabelSelector toLabelSelector(Job job) {
        LabelSelector ret = null;
        JobSpec spec = job.getSpec();
        if (spec != null) {
            if (spec.getSelector() != null) {
                ret = spec.getSelector();
            } else if (spec.getTemplate() != null) {
                ret = KubernetesHelper.toLabelSelector(spec.getTemplate().getMetadata());
            }
        }
        return ret;
    }

    private static LabelSelector toLabelSelector(ObjectMeta metadata) {
        if (metadata != null && metadata.getLabels() != null && !metadata.getLabels().isEmpty()) {
            return KubernetesHelper.toLabelSelector(metadata.getLabels());
        }
        return null;
    }

    private static LabelSelector toLabelSelector(Map<String, String> matchLabels) {
        if (matchLabels != null && !matchLabels.isEmpty()) {
            return ((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(matchLabels)).build();
        }
        return null;
    }

    public static boolean isNewerResource(HasMetadata newer, HasMetadata older) {
        Instant t1 = KubernetesHelper.getCreationTimestamp(newer);
        Instant t2 = KubernetesHelper.getCreationTimestamp(older);
        return t1 != null && (t2 == null || t1.compareTo(t2) > 0);
    }

    public static Instant getCreationTimestamp(HasMetadata hasMetadata) {
        ObjectMeta metadata = hasMetadata.getMetadata();
        if (metadata != null) {
            return KubernetesHelper.parseTimestamp(metadata.getCreationTimestamp());
        }
        return null;
    }

    private static Instant parseTimestamp(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        return KubernetesHelper.parseDate(text);
    }

    public static Instant parseDate(String text) {
        return Instant.from(DATE_TIME_FORMATTER.parse(text));
    }

    public static Pod getNewestPod(Collection<Pod> pods) {
        if (pods == null || pods.isEmpty()) {
            return null;
        }
        ArrayList<Pod> sortedPods = new ArrayList<Pod>(pods);
        sortedPods.sort((p1, p2) -> {
            Instant t1 = KubernetesHelper.getCreationTimestamp((HasMetadata)p1);
            Instant t2 = KubernetesHelper.getCreationTimestamp((HasMetadata)p2);
            if (t1 != null) {
                if (t2 == null) {
                    return 1;
                }
                return t1.compareTo(t2);
            }
            if (t2 == null) {
                return 0;
            }
            return -1;
        });
        return (Pod)sortedPods.get(sortedPods.size() - 1);
    }

    public static List<EnvVar> convertToEnvVarList(Map<String, String> envVars) {
        LinkedList<EnvVar> envList = new LinkedList<EnvVar>();
        for (Map.Entry entry : Optional.ofNullable(envVars).orElse(Collections.emptyMap()).entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (name == null) continue;
            EnvVar env = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(name)).withValue(value)).build();
            envList.add(env);
        }
        return envList;
    }

    public static boolean setEnvVar(List<EnvVar> envVarList, String name, String value) {
        for (EnvVar envVar : envVarList) {
            String envVarName = envVar.getName();
            if (!Objects.equals(name, envVarName)) continue;
            String oldValue = envVar.getValue();
            if (Objects.equals(value, oldValue)) {
                return false;
            }
            envVar.setValue(value);
            return true;
        }
        EnvVar env = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(name)).withValue(value)).build();
        envVarList.add(env);
        return true;
    }

    public static String getEnvVar(List<EnvVar> envVarList, String name, String defaultValue) {
        if (envVarList != null) {
            for (EnvVar envVar : envVarList) {
                String value;
                String envVarName = envVar.getName();
                if (!Objects.equals(name, envVarName) || !StringUtils.isNotBlank((CharSequence)(value = envVar.getValue()))) continue;
                return value;
            }
        }
        return defaultValue;
    }

    public static boolean removeEnvVar(List<EnvVar> envVarList, String name) {
        boolean removed = false;
        Iterator<EnvVar> it = envVarList.iterator();
        while (it.hasNext()) {
            EnvVar envVar = it.next();
            String envVarName = envVar.getName();
            if (!name.equals(envVarName)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    public static File getResourceFragmentFromSource(File resourceDirFinal, List<String> remotes, String resourceNameSuffix, KitLogger log) {
        for (File file : KubernetesHelper.listResourceFragments(remotes, log, resourceDirFinal)) {
            if (!file.getName().endsWith(resourceNameSuffix)) continue;
            return file;
        }
        return null;
    }

    public static Map<String, Quantity> getQuantityFromString(Map<String, String> quantity) {
        HashMap<String, Quantity> stringQuantityMap = new HashMap<String, Quantity>();
        if (quantity != null && !quantity.isEmpty()) {
            for (Map.Entry<String, String> entry : quantity.entrySet()) {
                stringQuantityMap.put(entry.getKey(), new Quantity(entry.getValue()));
            }
        }
        return stringQuantityMap;
    }

    public static File[] listResourceFragments(List<String> remotes, KitLogger log, List<File> resourceDirs) {
        return KubernetesHelper.listResourceFragments(remotes, log, (File[])resourceDirs.stream().filter(Objects::nonNull).toArray(File[]::new));
    }

    public static File[] listResourceFragments(List<String> remotes, KitLogger log, File ... resourceDirs) {
        File[] remoteResourceFiles;
        ArrayList resourceFiles = new ArrayList();
        for (File resourceDir : resourceDirs) {
            File[] resourceFragments = KubernetesHelper.listResourceFragments(resourceDir);
            if (resourceFragments == null) continue;
            Collections.addAll(resourceFiles, resourceFragments);
        }
        if (remotes != null && (remoteResourceFiles = KubernetesHelper.listRemoteResourceFragments(remotes, log)).length > 0) {
            Collections.addAll(resourceFiles, remoteResourceFiles);
        }
        return resourceFiles.toArray(new File[0]);
    }

    public static File[] listResourceFragments(File resourceDir) {
        if (resourceDir == null) {
            return new File[0];
        }
        return resourceDir.listFiles((dir, name) -> FILENAME_PATTERN.matcher(name).matches() && !PROFILES_PATTERN.matcher(name).matches());
    }

    private static File[] listRemoteResourceFragments(List<String> remotes, KitLogger log) {
        if (!remotes.isEmpty()) {
            File remoteResources = FileUtil.createTempDirectory();
            FileUtil.downloadRemotes(remoteResources, remotes, log);
            if (remoteResources.isDirectory()) {
                return remoteResources.listFiles();
            }
        }
        return new File[0];
    }

    public static String getFullyQualifiedApiGroupWithKind(HasMetadata item) {
        return ApiVersionUtil.joinApiGroupAndVersion((String)ApiVersionUtil.trimGroup((String)item.getApiVersion()), (String)ApiVersionUtil.trimVersion((String)item.getApiVersion())) + "#" + item.getKind();
    }

    public static String getNewestApplicationPodName(KubernetesClient client, String namespace, Collection<HasMetadata> resources) {
        LabelSelector selector = KubernetesHelper.extractPodLabelSelector(resources);
        PodList pods = namespace != null ? (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withLabelSelector(selector)).list() : (PodList)((FilterWatchListDeletable)client.pods().withLabelSelector(selector)).list();
        Pod newestPod = KubernetesHelper.getNewestPod(pods.getItems());
        if (newestPod != null) {
            return newestPod.getMetadata().getName();
        }
        return null;
    }

    public static String getAnnotationValue(HasMetadata item, String annotationKey) {
        if (item != null) {
            return KubernetesHelper.getOrCreateAnnotations(item).get(annotationKey);
        }
        return null;
    }

    public static boolean containsPort(List<ContainerPort> ports, String portValue) {
        for (ContainerPort port : ports) {
            Integer containerPort = port.getContainerPort();
            if (containerPort == null || containerPort != Integer.parseInt(portValue)) continue;
            return true;
        }
        return false;
    }

    public static ContainerPort addPort(String portNumberText, String portName, KitLogger log) {
        int portValue;
        if (StringUtils.isBlank((CharSequence)portNumberText)) {
            return null;
        }
        try {
            portValue = Integer.parseInt(portNumberText);
        }
        catch (NumberFormatException e) {
            log.warn("Could not parse remote debugging port %s as an integer: %s", portNumberText, e);
            return null;
        }
        return ((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName(portName)).withContainerPort(Integer.valueOf(portValue))).build();
    }

    public static boolean isControllerResource(HasMetadata h) {
        return Arrays.stream(POD_CONTROLLER_KINDS).anyMatch(c -> c.equals(h.getKind()));
    }

    public static List<HTTPHeader> convertMapToHTTPHeaderList(Map<String, String> headers) {
        ArrayList<HTTPHeader> httpHeaders = new ArrayList<HTTPHeader>();
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                httpHeaders.add(new HTTPHeader(header.getKey(), header.getValue()));
            }
        }
        return httpHeaders;
    }

    public static boolean hasAccessForAction(KubernetesClient client, String namespace, String group, String resource, String verb) {
        ResourceAttributesBuilder resourceAttributesBuilder = new ResourceAttributesBuilder();
        if (StringUtils.isNotBlank((CharSequence)group)) {
            resourceAttributesBuilder.withGroup(group);
        }
        if (StringUtils.isNotBlank((CharSequence)resource)) {
            resourceAttributesBuilder.withResource(resource);
        }
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            resourceAttributesBuilder.withNamespace(namespace);
        }
        if (StringUtils.isNotBlank((CharSequence)verb)) {
            resourceAttributesBuilder.withVerb(verb);
        }
        SelfSubjectAccessReview accessReviewFromServer = (SelfSubjectAccessReview)client.authorization().v1().selfSubjectAccessReview().create((Object)((SelfSubjectAccessReviewBuilder)((SelfSubjectAccessReviewFluent.SpecNested)new SelfSubjectAccessReviewBuilder().withNewSpec().withResourceAttributes(resourceAttributesBuilder.build())).endSpec()).build());
        return accessReviewFromServer.getStatus().getAllowed();
    }
}

