/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;

public class MapUtil {
    private static final BiFunction<String, Object, Object> GET_OR_NEW = (nK, nV) -> nV == null ? new LinkedHashMap() : nV;

    private MapUtil() {
    }

    public static void mergeIfAbsent(Map<String, String> map, Map<String, String> toMerge) {
        for (Map.Entry<String, String> entry : toMerge.entrySet()) {
            map.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    @SafeVarargs
    public static <K, V> Map<K, V> mergeMaps(Map<K, V> ... maps) {
        HashMap<K, V> answer = new HashMap<K, V>();
        for (int i = maps.length - 1; i >= 0; --i) {
            if (maps[i] == null) continue;
            answer.putAll(maps[i]);
        }
        return answer;
    }

    public static Map<String, String> mergeMaps(Properties ... properties) {
        HashMap<String, String> answer = new HashMap<String, String>();
        for (int i = properties.length - 1; i >= 0; --i) {
            if (properties[i] == null) continue;
            answer.putAll(PropertiesUtil.toMap(properties[i]));
        }
        return answer;
    }

    public static void putAllIfNotNull(Map<String, String> ret, Map<String, String> toPut) {
        if (toPut != null) {
            ret.putAll(toPut);
        }
    }

    public static Map<String, Object> getFlattenedMap(Map<?, ?> source) {
        return MapUtil.buildFlattenedMap(source, null);
    }

    public static Map<String, Object> getNestedMap(Map<String, ?> flattenedMap) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        flattenedMap.forEach((k, v) -> {
            String[] nodes = k.split("\\.");
            if (nodes.length == 1) {
                result.put((String)k, v);
            } else {
                Map currentNode = result;
                for (int it = 0; it < nodes.length - 1; ++it) {
                    Object tempNode = currentNode.compute(nodes[it], GET_OR_NEW);
                    if (!(tempNode instanceof Map)) {
                        throw new IllegalArgumentException("The provided input Map is invalid (node <" + nodes[it] + "> overlaps with key)");
                    }
                    currentNode = (Map)tempNode;
                }
                Object previousNodeValue = currentNode.put(nodes[nodes.length - 1], v);
                if (previousNodeValue != null) {
                    throw new IllegalArgumentException("The provided input Map is invalid (key <" + nodes[nodes.length - 1] + "> overlaps with node)");
                }
            }
        });
        return result;
    }

    private static Map<String, Object> buildFlattenedMap(Map<?, ?> source, String keyPrefix) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            String key = MapUtil.applicableKey(String.valueOf(entry.getKey()), keyPrefix);
            Object value = entry.getValue();
            if (value instanceof Map) {
                result.putAll(MapUtil.buildFlattenedMap((Map)value, key));
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    result.putAll(MapUtil.buildFlattenedMap(Collections.singletonMap("[" + count++ + "]", object), key));
                }
                continue;
            }
            result.put(key, value != null ? value.toString() : "");
        }
        return result;
    }

    private static String applicableKey(String key, String keyPrefix) {
        if (StringUtils.isNotBlank((CharSequence)keyPrefix)) {
            key = key.startsWith("[") ? keyPrefix + key : keyPrefix + "." + key;
        }
        return key;
    }
}

