/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util.validator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.NonValidationKeyword;
import com.networknt.schema.ValidationMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import javax.validation.metadata.ConstraintDescriptor;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.ResourceClassifier;
import org.eclipse.jkube.kit.common.util.validator.IgnorePortValidationRule;
import org.eclipse.jkube.kit.common.util.validator.IgnoreResourceMemoryLimitRule;
import org.eclipse.jkube.kit.common.util.validator.ValidationRule;

public class ResourceValidator {
    public static final String SCHEMA_JSON = "schema/validation-schema.json";
    private KitLogger log;
    private final File[] resources;
    private ResourceClassifier target = ResourceClassifier.KUBERNETES;
    private final List<ValidationRule> ignoreValidationRules = new ArrayList<ValidationRule>();

    public ResourceValidator(File inputFile) {
        this.resources = inputFile.isDirectory() ? inputFile.listFiles() : new File[]{inputFile};
    }

    public ResourceValidator(File inputFile, ResourceClassifier target, KitLogger log) {
        this(inputFile);
        this.target = target;
        this.log = log;
        this.setupIgnoreRules(this.target);
    }

    private void setupIgnoreRules(ResourceClassifier target) {
        this.ignoreValidationRules.add(new IgnorePortValidationRule("type"));
        this.ignoreValidationRules.add(new IgnoreResourceMemoryLimitRule("type"));
    }

    public int validate() throws IOException {
        for (File resource : this.resources) {
            if (!resource.isFile() || !resource.exists()) continue;
            this.log.info("validating %s resource", resource.toString());
            JsonNode inputSpecNode = this.geFileContent(resource);
            String kind = inputSpecNode.get("kind").toString();
            for (URL schemaFile : Collections.list(ResourceValidator.class.getClassLoader().getResources(SCHEMA_JSON))) {
                JsonSchema schema = this.getJsonSchema(schemaFile, kind);
                Set errors = schema.validate(inputSpecNode);
                this.processErrors(errors, resource);
            }
        }
        return this.resources.length;
    }

    private void processErrors(Set<ValidationMessage> errors, File resource) {
        HashSet<ConstraintViolationImpl> constraintViolations = new HashSet<ConstraintViolationImpl>();
        for (ValidationMessage errorMsg : errors) {
            if (this.ignoreError(errorMsg)) continue;
            constraintViolations.add(new ConstraintViolationImpl(errorMsg));
        }
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(this.getErrorMessage(resource, constraintViolations), constraintViolations);
        }
    }

    private boolean ignoreError(ValidationMessage errorMsg) {
        for (ValidationRule rule : this.ignoreValidationRules) {
            if (!rule.ignore(errorMsg)) continue;
            return true;
        }
        return false;
    }

    private String getErrorMessage(File resource, Set<ConstraintViolationImpl> violations) {
        StringBuilder validationError = new StringBuilder();
        validationError.append("Invalid Resource : ");
        validationError.append(resource.toString());
        for (ConstraintViolationImpl violation : violations) {
            validationError.append("\n");
            validationError.append(violation.toString());
        }
        return validationError.toString();
    }

    private JsonSchema getJsonSchema(URL schemaUrl, String kind) throws IOException {
        JsonMetaSchema v7 = JsonMetaSchema.getV7();
        String defaultUri = v7.getUri();
        JsonObject jsonSchema = ResourceValidator.fixUrlIfUnversioned(this.getSchemaJson(schemaUrl), defaultUri);
        this.checkIfKindPropertyExists(kind);
        this.getResourceProperties(kind, jsonSchema);
        JsonMetaSchema metaSchema = JsonMetaSchema.builder((String)v7.getUri(), (JsonMetaSchema)v7).addKeywords(ResourceValidator.createNonValidationKeywordList()).build();
        return new JsonSchemaFactory.Builder().defaultMetaSchemaURI(defaultUri).addMetaSchema(metaSchema).build().getSchema(jsonSchema.toString());
    }

    private void getResourceProperties(String kind, JsonObject jsonSchema) {
        String kindKey = kind.replaceAll("\"", "").toLowerCase();
        if (jsonSchema.get("resources") != null && jsonSchema.get("resources").getAsJsonObject().get(kindKey) != null) {
            jsonSchema.add("properties", (JsonElement)jsonSchema.get("resources").getAsJsonObject().getAsJsonObject(kindKey).getAsJsonObject("properties"));
        }
    }

    private void checkIfKindPropertyExists(String kind) {
        if (kind == null) {
            throw new JsonIOException("Invalid kind of resource or 'kind' is missing from resource definition");
        }
    }

    private JsonNode geFileContent(File file) throws IOException {
        try (FileInputStream resourceStream = new FileInputStream(file);){
            ObjectMapper jsonMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            JsonNode jsonNode = jsonMapper.readTree((InputStream)resourceStream);
            return jsonNode;
        }
    }

    public JsonObject getSchemaJson(URL schemaUrl) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String rootNode = ((JsonNode)objectMapper.readValue(schemaUrl, JsonNode.class)).toString();
        JsonObject jsonObject = new JsonParser().parse(rootNode).getAsJsonObject();
        jsonObject.remove("id");
        return jsonObject;
    }

    static List<NonValidationKeyword> createNonValidationKeywordList() {
        ArrayList<NonValidationKeyword> nonValidationKeywords = new ArrayList<NonValidationKeyword>();
        nonValidationKeywords.add(new NonValidationKeyword("javaType"));
        nonValidationKeywords.add(new NonValidationKeyword("javaInterfaces"));
        nonValidationKeywords.add(new NonValidationKeyword("resources"));
        nonValidationKeywords.add(new NonValidationKeyword("javaOmitEmpty"));
        nonValidationKeywords.add(new NonValidationKeyword("existingJavaType"));
        nonValidationKeywords.add(new NonValidationKeyword("$module"));
        return nonValidationKeywords;
    }

    private static JsonObject fixUrlIfUnversioned(JsonObject jsonSchema, String versionedUri) {
        String uri = jsonSchema.get("$schema").getAsString();
        if (uri.matches("^https?://json-schema.org/draft-05/schema[^/]*$")) {
            JsonObject ret = jsonSchema.deepCopy();
            ret.addProperty("$schema", versionedUri);
            return ret;
        }
        return jsonSchema;
    }

    private static class ConstraintViolationImpl
    implements ConstraintViolation<ValidationMessage> {
        private final ValidationMessage errorMsg;

        public ConstraintViolationImpl(ValidationMessage errorMsg) {
            this.errorMsg = errorMsg;
        }

        public String getMessage() {
            return this.errorMsg.getMessage();
        }

        public String getMessageTemplate() {
            return null;
        }

        public ValidationMessage getRootBean() {
            return null;
        }

        public Class<ValidationMessage> getRootBeanClass() {
            return null;
        }

        public Object getLeafBean() {
            return null;
        }

        public Object[] getExecutableParameters() {
            return new Object[0];
        }

        public Object getExecutableReturnValue() {
            return null;
        }

        public Path getPropertyPath() {
            return null;
        }

        public Object getInvalidValue() {
            return null;
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return null;
        }

        public <U> U unwrap(Class<U> aClass) {
            return null;
        }

        public String toString() {
            return "[message=" + this.getMessage().replaceFirst("[$]", "") + ", violation type=" + this.errorMsg.getType() + "]";
        }
    }
}

