/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.image;

import java.io.Serializable;
import java.util.Map;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.image.WatchImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;

public class ImageConfiguration
implements Serializable {
    private String name;
    private String alias;
    private BuildConfiguration build;
    private WatchImageConfiguration watch;
    private Map<String, String> external;
    private String registry;

    public void setExternalConfiguration(Map<String, String> externalConfiguration) {
        this.external = externalConfiguration;
    }

    public BuildConfiguration getBuildConfiguration() {
        return this.build;
    }

    public WatchImageConfiguration getWatchConfiguration() {
        return this.watch;
    }

    public Map<String, String> getExternalConfig() {
        return this.external;
    }

    public String getDescription() {
        return String.format("[%s] %s", new ImageName(this.name).getFullName(), this.alias != null ? "\"" + this.alias + "\"" : "").trim();
    }

    public static ImageConfigurationBuilder builder() {
        return new ImageConfigurationBuilder();
    }

    public ImageConfigurationBuilder toBuilder() {
        return new ImageConfigurationBuilder().name(this.name).alias(this.alias).build(this.build).watch(this.watch).external(this.external).registry(this.registry);
    }

    public ImageConfiguration(String name, String alias, BuildConfiguration build, WatchImageConfiguration watch, Map<String, String> external, String registry) {
        this.name = name;
        this.alias = alias;
        this.build = build;
        this.watch = watch;
        this.external = external;
        this.registry = registry;
    }

    public ImageConfiguration() {
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public BuildConfiguration getBuild() {
        return this.build;
    }

    public WatchImageConfiguration getWatch() {
        return this.watch;
    }

    public Map<String, String> getExternal() {
        return this.external;
    }

    public String getRegistry() {
        return this.registry;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setBuild(BuildConfiguration build) {
        this.build = build;
    }

    public void setWatch(WatchImageConfiguration watch) {
        this.watch = watch;
    }

    public void setExternal(Map<String, String> external) {
        this.external = external;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageConfiguration)) {
            return false;
        }
        ImageConfiguration other = (ImageConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        BuildConfiguration this$build = this.getBuild();
        BuildConfiguration other$build = other.getBuild();
        if (this$build == null ? other$build != null : !((Object)this$build).equals(other$build)) {
            return false;
        }
        WatchImageConfiguration this$watch = this.getWatch();
        WatchImageConfiguration other$watch = other.getWatch();
        if (this$watch == null ? other$watch != null : !((Object)this$watch).equals(other$watch)) {
            return false;
        }
        Map<String, String> this$external = this.getExternal();
        Map<String, String> other$external = other.getExternal();
        if (this$external == null ? other$external != null : !((Object)this$external).equals(other$external)) {
            return false;
        }
        String this$registry = this.getRegistry();
        String other$registry = other.getRegistry();
        return !(this$registry == null ? other$registry != null : !this$registry.equals(other$registry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        BuildConfiguration $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : ((Object)$build).hashCode());
        WatchImageConfiguration $watch = this.getWatch();
        result = result * 59 + ($watch == null ? 43 : ((Object)$watch).hashCode());
        Map<String, String> $external = this.getExternal();
        result = result * 59 + ($external == null ? 43 : ((Object)$external).hashCode());
        String $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
        return result;
    }

    public static class ImageConfigurationBuilder {
        private String name;
        private String alias;
        private BuildConfiguration build;
        private WatchImageConfiguration watch;
        private Map<String, String> external;
        private String registry;

        ImageConfigurationBuilder() {
        }

        public ImageConfigurationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ImageConfigurationBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public ImageConfigurationBuilder build(BuildConfiguration build) {
            this.build = build;
            return this;
        }

        public ImageConfigurationBuilder watch(WatchImageConfiguration watch) {
            this.watch = watch;
            return this;
        }

        public ImageConfigurationBuilder external(Map<String, String> external) {
            this.external = external;
            return this;
        }

        public ImageConfigurationBuilder registry(String registry) {
            this.registry = registry;
            return this;
        }

        public ImageConfiguration build() {
            return new ImageConfiguration(this.name, this.alias, this.build, this.watch, this.external, this.registry);
        }

        public String toString() {
            return "ImageConfiguration.ImageConfigurationBuilder(name=" + this.name + ", alias=" + this.alias + ", build=" + this.build + ", watch=" + this.watch + ", external=" + this.external + ", registry=" + this.registry + ")";
        }
    }
}

