/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.quarkus.generator;

import java.io.File;
import java.util.Properties;
import org.eclipse.jkube.generator.api.FromSelector;
import org.eclipse.jkube.generator.api.GeneratorConfig;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.quarkus.QuarkusUtils;
import org.eclipse.jkube.quarkus.generator.AbstractQuarkusNestedGenerator;

public class NativeGenerator
extends AbstractQuarkusNestedGenerator {
    private final FromSelector fromSelector;

    public NativeGenerator(GeneratorContext generatorContext, GeneratorConfig generatorConfig) {
        super(generatorContext, generatorConfig);
        this.fromSelector = new FromSelector.Default(generatorContext, "quarkus-native");
    }

    @Override
    public String getFrom() {
        return this.fromSelector.getFrom();
    }

    @Override
    public String getDefaultJolokiaPort() {
        return "0";
    }

    @Override
    public String getDefaultPrometheusPort() {
        return "0";
    }

    @Override
    public Arguments getBuildEntryPoint() {
        Arguments.ArgumentsBuilder ab = Arguments.builder();
        ab.execArgument("./" + QuarkusUtils.findSingleFileThatEndsWith(this.getProject(), QuarkusUtils.runnerSuffix(QuarkusUtils.getQuarkusConfiguration(this.getProject()))));
        return ab.build();
    }

    @Override
    public String getBuildWorkdir() {
        return "/";
    }

    @Override
    public String getTargetDir() {
        return "/";
    }

    @Override
    public AssemblyConfiguration createAssemblyConfiguration() {
        JavaProject project = this.getProject();
        Properties quarkusConfiguration = QuarkusUtils.getQuarkusConfiguration(project);
        AssemblyFileSet artifactFileSet = this.createFileSet().directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)project.getBuildDirectory())).include(QuarkusUtils.findSingleFileThatEndsWith(project, QuarkusUtils.runnerSuffix(quarkusConfiguration))).fileMode("0755").build();
        return AssemblyConfiguration.builder().targetDir(this.getTargetDir()).excludeFinalOutputArtifact(true).layer(Assembly.builder().fileSet(artifactFileSet).build()).build();
    }
}

