/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.quarkus.generator;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.javaexec.JavaExecGenerator;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.quarkus.QuarkusUtils;
import org.eclipse.jkube.quarkus.generator.QuarkusNestedGenerator;

public class QuarkusGenerator
extends JavaExecGenerator {
    public static final String QUARKUS = "quarkus";
    private final QuarkusNestedGenerator nestedGenerator;

    public QuarkusGenerator(GeneratorContext context) {
        super(context, QUARKUS);
        this.nestedGenerator = QuarkusNestedGenerator.from(context, this.getGeneratorConfig());
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddGeneratedImageConfiguration(configs) && QuarkusUtils.hasQuarkusPlugin(this.getProject());
    }

    protected String getDefaultWebPort() {
        return QuarkusUtils.extractPort(this.getProject(), QuarkusUtils.getQuarkusConfiguration(this.getProject()), super.getDefaultWebPort());
    }

    protected String getDefaultJolokiaPort() {
        return this.nestedGenerator.getDefaultJolokiaPort();
    }

    protected String getDefaultPrometheusPort() {
        return this.nestedGenerator.getDefaultPrometheusPort();
    }

    protected String getFromAsConfigured() {
        return Optional.ofNullable(super.getFromAsConfigured()).orElse(this.nestedGenerator.getFrom());
    }

    protected AssemblyConfiguration createAssembly() {
        return this.nestedGenerator.createAssemblyConfiguration();
    }

    protected String getBuildWorkdir() {
        return this.nestedGenerator.getBuildWorkdir();
    }

    protected Arguments getBuildEntryPoint() {
        return this.nestedGenerator.getBuildEntryPoint();
    }

    protected Map<String, String> getEnv(boolean prePackagePhase) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("JAVA_OPTIONS", StringUtils.join(QuarkusGenerator.getJavaOptions(), (String)" "));
        return env;
    }

    private static List<String> getJavaOptions() {
        return Collections.singletonList("-Dquarkus.http.host=0.0.0.0");
    }

    protected boolean isFatJar() {
        return this.nestedGenerator.isFatJar();
    }

    public static enum Config implements Configs.Config
    {
        NATIVE_IMAGE("nativeImage", "false");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

