/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.develop;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.maven.plugin.mojo.OpenShift;
import org.eclipse.jkube.maven.plugin.mojo.develop.UndeployMojo;

@Mojo(name="undeploy", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.INSTALL)
public class OpenshiftUndeployMojo
extends UndeployMojo {
    @Parameter(property="jkube.s2i.buildNameSuffix", defaultValue="-s2i")
    protected String s2iBuildNameSuffix;
    @Parameter(property="jkube.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/jkube/openshift.yml")
    protected File openshiftManifest;
    @Parameter(property="jkube.openshiftImageStreamManifest", defaultValue="${basedir}/target/${project.artifactId}-is.yml")
    protected File openshiftImageStreamManifest;

    protected List<File> getManifestsToUndeploy() {
        List ret = super.getManifestsToUndeploy();
        ret.add(this.openshiftImageStreamManifest);
        return ret;
    }

    public File getManifest(KubernetesClient kubernetesClient) {
        return OpenShift.getOpenShiftManifest(kubernetesClient, this.getKubernetesManifest(), this.openshiftManifest);
    }

    protected RuntimeMode getRuntimeMode() {
        return RuntimeMode.OPENSHIFT;
    }

    protected String getLogPrefix() {
        return "oc: ";
    }
}

