/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.binaryschema;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaBinaryDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.SerializationContext;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.opcfoundation.opcua.binaryschema.FieldType;
import org.opcfoundation.opcua.binaryschema.StructuredType;
import org.opcfoundation.opcua.binaryschema.SwitchOperand;

public abstract class AbstractCodec<StructureT, MemberT>
implements OpcUaBinaryDataTypeCodec<StructureT> {
    private static final ImmutableMap<String, Function<OpcUaBinaryStreamDecoder, Object>> READERS = ImmutableMap.builder().put((Object)"Boolean", OpcUaBinaryStreamDecoder::readBoolean).put((Object)"SByte", OpcUaBinaryStreamDecoder::readSByte).put((Object)"Int16", OpcUaBinaryStreamDecoder::readInt16).put((Object)"Int32", OpcUaBinaryStreamDecoder::readInt32).put((Object)"Int64", OpcUaBinaryStreamDecoder::readInt64).put((Object)"Byte", OpcUaBinaryStreamDecoder::readByte).put((Object)"UInt16", OpcUaBinaryStreamDecoder::readUInt16).put((Object)"UInt32", OpcUaBinaryStreamDecoder::readUInt32).put((Object)"UInt64", OpcUaBinaryStreamDecoder::readUInt64).put((Object)"Float", OpcUaBinaryStreamDecoder::readFloat).put((Object)"Double", OpcUaBinaryStreamDecoder::readDouble).put((Object)"String", OpcUaBinaryStreamDecoder::readUtf8CharArray).put((Object)"DateTime", OpcUaBinaryStreamDecoder::readDateTime).put((Object)"Guid", OpcUaBinaryStreamDecoder::readGuid).put((Object)"ByteString", OpcUaBinaryStreamDecoder::readByteString).put((Object)"XmlElement", OpcUaBinaryStreamDecoder::readXmlElement).put((Object)"NodeId", OpcUaBinaryStreamDecoder::readNodeId).put((Object)"ExpandedNodeId", OpcUaBinaryStreamDecoder::readExpandedNodeId).put((Object)"StatusCode", OpcUaBinaryStreamDecoder::readStatusCode).put((Object)"QualifiedName", OpcUaBinaryStreamDecoder::readQualifiedName).put((Object)"LocalizedText", OpcUaBinaryStreamDecoder::readLocalizedText).put((Object)"ExtensionObject", OpcUaBinaryStreamDecoder::readExtensionObject).put((Object)"DataValue", OpcUaBinaryStreamDecoder::readDataValue).put((Object)"Variant", OpcUaBinaryStreamDecoder::readVariant).put((Object)"DiagnosticInfo", OpcUaBinaryStreamDecoder::readDiagnosticInfo).put((Object)"Bit", OpcUaBinaryStreamDecoder::readBit).put((Object)"Char", OpcUaBinaryStreamDecoder::readCharacter).put((Object)"CharArray", OpcUaBinaryStreamDecoder::readUtf8CharArray).put((Object)"WideChar", OpcUaBinaryStreamDecoder::readWideChar).put((Object)"WideCharArray", OpcUaBinaryStreamDecoder::readUtf16CharArray).put((Object)"WideString", OpcUaBinaryStreamDecoder::readUtf16CharArray).build();
    private static final ImmutableMap<String, BiConsumer<OpcUaBinaryStreamEncoder, Object>> WRITERS = ImmutableMap.builder().put((Object)"Boolean", (w, v) -> w.writeBoolean((Boolean)v)).put((Object)"SByte", (w, v) -> w.writeSByte((Byte)v)).put((Object)"Int16", (w, v) -> w.writeInt16((Short)v)).put((Object)"Int32", (w, v) -> w.writeInt32((Integer)v)).put((Object)"Int64", (w, v) -> w.writeInt64((Long)v)).put((Object)"Byte", (w, v) -> w.writeByte((UByte)v)).put((Object)"UInt16", (w, v) -> w.writeUInt16((UShort)v)).put((Object)"UInt32", (w, v) -> w.writeUInt32((UInteger)v)).put((Object)"UInt64", (w, v) -> w.writeUInt64((ULong)v)).put((Object)"Float", (w, v) -> w.writeFloat((Float)v)).put((Object)"Double", (w, v) -> w.writeDouble((Double)v)).put((Object)"String", (w, v) -> w.writeUtf8CharArray((String)v)).put((Object)"DateTime", (w, v) -> w.writeDateTime((DateTime)v)).put((Object)"Guid", (w, v) -> w.writeGuid((UUID)v)).put((Object)"ByteString", (w, v) -> w.writeByteString((ByteString)v)).put((Object)"XmlElement", (w, v) -> w.writeXmlElement((XmlElement)v)).put((Object)"NodeId", (w, v) -> w.writeNodeId((NodeId)v)).put((Object)"ExpandedNodeId", (w, v) -> w.writeExpandedNodeId((ExpandedNodeId)v)).put((Object)"StatusCode", (w, v) -> w.writeStatusCode((StatusCode)v)).put((Object)"QualifiedName", (w, v) -> w.writeQualifiedName((QualifiedName)v)).put((Object)"LocalizedText", (w, v) -> w.writeLocalizedText((LocalizedText)v)).put((Object)"ExtensionObject", (w, v) -> w.writeExtensionObject((ExtensionObject)v)).put((Object)"DataValue", (w, v) -> w.writeDataValue((DataValue)v)).put((Object)"Variant", (w, v) -> w.writeVariant((Variant)v)).put((Object)"DiagnosticInfo", (w, v) -> w.writeDiagnosticInfo((DiagnosticInfo)v)).put((Object)"Bit", (w, v) -> w.writeBit(((Integer)v).intValue())).put((Object)"Char", (w, v) -> w.writeCharacter((Character)v)).put((Object)"CharArray", (w, v) -> w.writeUtf8CharArray((String)v)).put((Object)"WideChar", (w, v) -> w.writeWideChar((Character)v)).put((Object)"WideCharArray", (w, v) -> w.writeUtf16CharArray((String)v)).put((Object)"WideString", (w, v) -> w.writeUtf16CharArray((String)v)).build();
    private static final ImmutableMap<String, Class<?>> TYPE_CLASS_MAP = ImmutableMap.builder().put((Object)"Boolean", (Object)BuiltinDataType.Boolean.getBackingClass()).put((Object)"SByte", (Object)BuiltinDataType.SByte.getBackingClass()).put((Object)"Int16", (Object)BuiltinDataType.Int16.getBackingClass()).put((Object)"Int32", (Object)BuiltinDataType.Int32.getBackingClass()).put((Object)"Int64", (Object)BuiltinDataType.Int64.getBackingClass()).put((Object)"Byte", (Object)BuiltinDataType.Byte.getBackingClass()).put((Object)"UInt16", (Object)BuiltinDataType.UInt16.getBackingClass()).put((Object)"UInt32", (Object)BuiltinDataType.UInt32.getBackingClass()).put((Object)"UInt64", (Object)BuiltinDataType.UInt64.getBackingClass()).put((Object)"Float", (Object)BuiltinDataType.Float.getBackingClass()).put((Object)"Double", (Object)BuiltinDataType.Double.getBackingClass()).put((Object)"String", (Object)BuiltinDataType.String.getBackingClass()).put((Object)"DateTime", (Object)BuiltinDataType.DateTime.getBackingClass()).put((Object)"Guid", (Object)BuiltinDataType.Guid.getBackingClass()).put((Object)"ByteString", (Object)BuiltinDataType.ByteString.getBackingClass()).put((Object)"XmlElement", (Object)BuiltinDataType.XmlElement.getBackingClass()).put((Object)"NodeId", (Object)BuiltinDataType.NodeId.getBackingClass()).put((Object)"ExpandedNodeId", (Object)BuiltinDataType.ExpandedNodeId.getBackingClass()).put((Object)"StatusCode", (Object)BuiltinDataType.StatusCode.getBackingClass()).put((Object)"QualifiedName", (Object)BuiltinDataType.QualifiedName.getBackingClass()).put((Object)"LocalizedText", (Object)BuiltinDataType.LocalizedText.getBackingClass()).put((Object)"ExtensionObject", (Object)BuiltinDataType.ExtensionObject.getBackingClass()).put((Object)"DataValue", (Object)BuiltinDataType.DataValue.getBackingClass()).put((Object)"Variant", (Object)BuiltinDataType.Variant.getBackingClass()).put((Object)"DiagnosticInfo", (Object)BuiltinDataType.DiagnosticInfo.getBackingClass()).put((Object)"Bit", Integer.class).put((Object)"Char", Character.class).put((Object)"CharArray", String.class).put((Object)"WideChar", Character.class).put((Object)"WideCharArray", String.class).put((Object)"WideString", String.class).build();
    private final StructuredType structuredType;

    protected AbstractCodec(StructuredType structuredType) {
        this.structuredType = structuredType;
    }

    public StructureT decode(SerializationContext context, OpcUaBinaryStreamDecoder decoder) throws UaSerializationException {
        LinkedHashMap<String, MemberT> members = new LinkedHashMap<String, MemberT>();
        PeekingIterator fieldIterator = Iterators.peekingIterator(this.structuredType.getField().iterator());
        while (fieldIterator.hasNext()) {
            Object value;
            int i;
            FieldType field = (FieldType)fieldIterator.next();
            String fieldName = field.getName();
            String typeName = field.getTypeName().getLocalPart();
            String typeNamespace = field.getTypeName().getNamespaceURI();
            if (!this.fieldIsPresent(field, members)) continue;
            if (AbstractCodec.fieldIsScalar(field)) {
                if ("http://opcfoundation.org/UA/".equals(typeNamespace) || "http://opcfoundation.org/BinarySchema/".equals(typeNamespace)) {
                    Object value2 = ((Function)READERS.get((Object)typeName)).apply(decoder);
                    members.put(fieldName, this.opcUaToMemberTypeScalar(fieldName, value2, typeName));
                    continue;
                }
                Object value3 = context.decode(typeNamespace, typeName, decoder);
                members.put(fieldName, this.opcUaToMemberTypeScalar(fieldName, value3, typeName));
                continue;
            }
            if (field.isIsLengthInBytes()) {
                throw new UaSerializationException(0x80070000L, "IsLengthInBytes=true not supported");
            }
            int length = this.fieldLength(field, members);
            if ("Bit".equals(typeName) && ("http://opcfoundation.org/UA/".equals(typeNamespace) || "http://opcfoundation.org/BinarySchema/".equals(typeNamespace))) {
                BigInteger bitAccumulation = BigInteger.valueOf(0L);
                for (i = 0; i < length; ++i) {
                    BigInteger bitValue = BigInteger.valueOf(decoder.readBit());
                    bitAccumulation = bitAccumulation.or(bitValue.shiftLeft(i));
                }
                members.put(fieldName, this.opcUaToMemberTypeArray(fieldName, bitAccumulation.intValue(), typeName));
                continue;
            }
            Object[] values = new Object[length];
            if ("http://opcfoundation.org/UA/".equals(typeNamespace) || "http://opcfoundation.org/BinarySchema/".equals(typeNamespace)) {
                for (i = 0; i < length; ++i) {
                    value = ((Function)READERS.get((Object)typeName)).apply(decoder);
                    values[i] = value;
                }
            } else {
                for (i = 0; i < length; ++i) {
                    value = context.decode(typeNamespace, typeName, decoder);
                    values[i] = value;
                }
            }
            members.put(fieldName, this.opcUaToMemberTypeArray(fieldName, values, typeName));
        }
        return this.createStructure(this.structuredType.getName(), members);
    }

    public void encode(SerializationContext context, StructureT structure, OpcUaBinaryStreamEncoder encoder) throws UaSerializationException {
        LinkedHashMap<String, MemberT> members = new LinkedHashMap<String, MemberT>(this.getMembers(structure));
        PeekingIterator fieldIterator = Iterators.peekingIterator(this.structuredType.getField().iterator());
        while (fieldIterator.hasNext()) {
            FieldType field = (FieldType)fieldIterator.next();
            if (!this.fieldIsPresent(field, members)) continue;
            String typeName = field.getTypeName().getLocalPart();
            String typeNamespace = field.getTypeName().getNamespaceURI();
            MemberT member = members.get(field.getName());
            if (AbstractCodec.fieldIsScalar(field)) {
                Object scalarValue = this.memberTypeToOpcUaScalar(member, typeName);
                if ("http://opcfoundation.org/UA/".equals(typeNamespace) || "http://opcfoundation.org/BinarySchema/".equals(typeNamespace)) {
                    ((BiConsumer)WRITERS.get((Object)typeName)).accept(encoder, scalarValue);
                    continue;
                }
                context.encode(typeNamespace, typeName, scalarValue, encoder);
                continue;
            }
            if (field.isIsLengthInBytes()) {
                throw new UaSerializationException(0x80060000L, "IsLengthInBytes=true not supported");
            }
            int length = this.fieldLength(field, members);
            if ("Bit".equals(typeName) && ("http://opcfoundation.org/UA/".equals(typeNamespace) || "http://opcfoundation.org/BinarySchema/".equals(typeNamespace))) {
                Number number = (Number)this.memberTypeToOpcUaArray(member, typeName);
                BigInteger bi = BigInteger.valueOf(number.longValue());
                for (int i = 0; i < length; ++i) {
                    encoder.writeBit(bi.shiftRight(i).and(BigInteger.ONE).intValue());
                }
                continue;
            }
            Object[] valueArray = (Object[])this.memberTypeToOpcUaArray(member, typeName);
            if (valueArray == null) continue;
            if ("http://opcfoundation.org/UA/".equals(typeNamespace) || "http://opcfoundation.org/BinarySchema/".equals(typeNamespace)) {
                for (int i = 0; i < length; ++i) {
                    Object value = valueArray[i];
                    ((BiConsumer)WRITERS.get((Object)typeName)).accept(encoder, value);
                }
                continue;
            }
            for (int i = 0; i < length; ++i) {
                Object value = valueArray[i];
                context.encode(typeNamespace, typeName, value, encoder);
            }
        }
    }

    protected abstract StructureT createStructure(String var1, LinkedHashMap<String, MemberT> var2);

    protected abstract Map<String, MemberT> getMembers(StructureT var1);

    protected abstract MemberT opcUaToMemberTypeScalar(String var1, Object var2, String var3);

    protected abstract MemberT opcUaToMemberTypeArray(String var1, Object var2, String var3);

    protected abstract Object memberTypeToOpcUaScalar(MemberT var1, String var2);

    protected abstract Object memberTypeToOpcUaArray(MemberT var1, String var2);

    private int fieldLength(FieldType field, LinkedHashMap<String, MemberT> members) {
        MemberT lengthMember;
        int length = 1;
        if (field.getLength() != null) {
            length = field.getLength().intValue();
        } else if (field.getLengthField() != null && (lengthMember = members.get(field.getLengthField())) != null) {
            String lengthTypeName = this.structuredType.getField().stream().filter(f -> f.getName().equals(field.getLengthField())).findFirst().map(f -> f.getTypeName().getLocalPart()).orElse("Int32");
            length = ((Number)this.memberTypeToOpcUaScalar(lengthMember, lengthTypeName)).intValue();
        }
        return length;
    }

    private boolean fieldIsPresent(FieldType field, Map<String, MemberT> members) {
        if (field.getSwitchField() == null) {
            return true;
        }
        MemberT controlField = members.get(field.getSwitchField());
        String controlTypeName = this.structuredType.getField().stream().filter(f -> f.getName().equals(field.getSwitchField())).findFirst().map(f -> f.getTypeName().getLocalPart()).orElse("Int32");
        long controlValue = ((Number)this.memberTypeToOpcUaScalar(controlField, controlTypeName)).longValue();
        long switchValue = field.getSwitchValue() != null ? field.getSwitchValue() : 1L;
        SwitchOperand switchOperand = field.getSwitchOperand() != null ? field.getSwitchOperand() : SwitchOperand.EQUALS;
        return AbstractCodec.compareToSwitchValue(controlValue, switchOperand, switchValue);
    }

    private static boolean compareToSwitchValue(long controlValue, SwitchOperand switchOperand, long switchValue) {
        switch (switchOperand) {
            case EQUALS: {
                return controlValue == switchValue;
            }
            case NOT_EQUAL: {
                return controlValue != switchValue;
            }
            case GREATER_THAN: {
                return controlValue > switchValue;
            }
            case GREATER_THAN_OR_EQUAL: {
                return controlValue >= switchValue;
            }
            case LESS_THAN: {
                return controlValue < switchValue;
            }
            case LESS_THAN_OR_EQUAL: {
                return controlValue <= switchValue;
            }
        }
        throw new UaSerializationException(0x80020000L, "unknown SwitchOperand: " + (Object)((Object)switchOperand));
    }

    private static boolean fieldIsScalar(FieldType field) {
        return field.getLengthField() == null && field.getLength() == null;
    }
}

