/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.core;

import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;

public enum AccessLevel {
    CurrentRead(1),
    CurrentWrite(2),
    HistoryRead(4),
    HistoryWrite(8),
    SemanticChange(16),
    StatusWrite(32),
    TimestampWrite(64);

    public static final ImmutableSet<AccessLevel> NONE;
    public static final ImmutableSet<AccessLevel> READ_ONLY;
    public static final ImmutableSet<AccessLevel> READ_WRITE;
    public static final ImmutableSet<AccessLevel> HISTORY_READ_ONLY;
    public static final ImmutableSet<AccessLevel> HISTORY_READ_WRITE;
    private final int value;

    private AccessLevel(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static int getMask(AccessLevel ... levels) {
        int result = 0;
        for (AccessLevel level : levels) {
            result = (short)(result | level.value);
        }
        return result;
    }

    public static int getMask(Set<AccessLevel> levels) {
        int result = 0;
        for (AccessLevel level : levels) {
            result |= level.value;
        }
        return result;
    }

    public static EnumSet<AccessLevel> fromMask(int accessLevel) {
        EnumSet<AccessLevel> e = EnumSet.noneOf(AccessLevel.class);
        for (AccessLevel al : AccessLevel.values()) {
            if ((al.value & accessLevel) == 0) continue;
            e.add(al);
        }
        return e;
    }

    public static EnumSet<AccessLevel> fromMask(UByte accessLevel) {
        return AccessLevel.fromMask(accessLevel.intValue());
    }

    static {
        NONE = ImmutableSet.of();
        READ_ONLY = ImmutableSet.of((Object)((Object)CurrentRead));
        READ_WRITE = ImmutableSet.of((Object)((Object)CurrentRead), (Object)((Object)CurrentWrite));
        HISTORY_READ_ONLY = ImmutableSet.of((Object)((Object)HistoryRead));
        HISTORY_READ_WRITE = ImmutableSet.of((Object)((Object)HistoryRead), (Object)((Object)HistoryWrite));
    }
}

