/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client.config;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.stack.client.config.UaTcpStackClientConfigBuilder;
import org.eclipse.milo.opcua.stack.core.application.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.channel.ChannelConfig;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;

public interface UaTcpStackClientConfig {
    public Optional<String> getEndpointUrl();

    public Optional<EndpointDescription> getEndpoint();

    public Optional<KeyPair> getKeyPair();

    public Optional<X509Certificate> getCertificate();

    public Optional<X509Certificate[]> getCertificateChain();

    public CertificateValidator getCertificateValidator();

    public LocalizedText getApplicationName();

    public String getApplicationUri();

    public String getProductUri();

    public ChannelConfig getChannelConfig();

    public UInteger getChannelLifetime();

    public ExecutorService getExecutor();

    public NioEventLoopGroup getEventLoop();

    public HashedWheelTimer getWheelTimer();

    public static UaTcpStackClientConfigBuilder builder() {
        return new UaTcpStackClientConfigBuilder();
    }

    public static UaTcpStackClientConfigBuilder copy(UaTcpStackClientConfig config) {
        UaTcpStackClientConfigBuilder builder = new UaTcpStackClientConfigBuilder();
        config.getEndpointUrl().ifPresent(builder::setEndpointUrl);
        config.getEndpoint().ifPresent(builder::setEndpoint);
        config.getKeyPair().ifPresent(builder::setKeyPair);
        config.getCertificate().ifPresent(builder::setCertificate);
        config.getCertificateChain().ifPresent(builder::setCertificateChain);
        builder.setCertificateValidator(config.getCertificateValidator());
        builder.setApplicationName(config.getApplicationName());
        builder.setApplicationUri(config.getApplicationUri());
        builder.setProductUri(config.getProductUri());
        builder.setChannelConfig(config.getChannelConfig());
        builder.setChannelLifetime(config.getChannelLifetime());
        builder.setExecutor(config.getExecutor());
        builder.setEventLoop(config.getEventLoop());
        builder.setWheelTimer(config.getWheelTimer());
        return builder;
    }

    public static UaTcpStackClientConfig copy(UaTcpStackClientConfig config, Consumer<UaTcpStackClientConfigBuilder> consumer) {
        UaTcpStackClientConfigBuilder builder = UaTcpStackClientConfig.copy(config);
        consumer.accept(builder);
        return builder.build();
    }
}

