/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

public enum AttributeId {
    NodeId(1),
    NodeClass(2),
    BrowseName(3),
    DisplayName(4),
    Description(5),
    WriteMask(6),
    UserWriteMask(7),
    IsAbstract(8),
    Symmetric(9),
    InverseName(10),
    ContainsNoLoops(11),
    EventNotifier(12),
    Value(13),
    DataType(14),
    ValueRank(15),
    ArrayDimensions(16),
    AccessLevel(17),
    UserAccessLevel(18),
    MinimumSamplingInterval(19),
    Historizing(20),
    Executable(21),
    UserExecutable(22);

    public static final ImmutableSet<AttributeId> BASE_NODE_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> DATA_TYPE_NODE_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> METHOD_NODE_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> OBJECT_NODE_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> OBJECT_TYPE_NODE_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> REFERENCE_TYPE_NODE_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> VARIABLE_NODE_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> VARIABLE_TYPE_NODE_ATTRIBUTES;
    public static final ImmutableSet<AttributeId> VIEW_NODE_ATTRIBUTES;
    private final int id;

    private AttributeId(int id) {
        this.id = id;
    }

    public final int id() {
        return this.id;
    }

    public final UInteger uid() {
        return Unsigned.uint(this.id);
    }

    public static Optional<AttributeId> from(UInteger attributeId) {
        return AttributeId.from(attributeId.intValue());
    }

    public static Optional<AttributeId> from(int attributeId) {
        if (attributeId > 0 && attributeId <= AttributeId.values().length) {
            return Optional.of(AttributeId.values()[attributeId - 1]);
        }
        return Optional.empty();
    }

    public boolean isEqual(UInteger attributeId) {
        return attributeId != null && this.isEqual(attributeId.intValue());
    }

    public boolean isEqual(int attributeId) {
        return this.id == attributeId;
    }

    public static boolean isValid(UInteger attributeId) {
        return AttributeId.from(attributeId).isPresent();
    }

    public static boolean isValid(int attributeId) {
        return AttributeId.from(attributeId).isPresent();
    }

    static {
        BASE_NODE_ATTRIBUTES = ImmutableSet.copyOf(EnumSet.of(NodeId, new AttributeId[]{NodeClass, BrowseName, DisplayName, Description, WriteMask, UserWriteMask}));
        DATA_TYPE_NODE_ATTRIBUTES = ImmutableSet.copyOf((Collection)Sets.union(BASE_NODE_ATTRIBUTES, EnumSet.of(IsAbstract)));
        METHOD_NODE_ATTRIBUTES = ImmutableSet.copyOf((Collection)Sets.union(BASE_NODE_ATTRIBUTES, EnumSet.of(Executable, UserExecutable)));
        OBJECT_NODE_ATTRIBUTES = ImmutableSet.copyOf((Collection)Sets.union(BASE_NODE_ATTRIBUTES, EnumSet.of(EventNotifier)));
        OBJECT_TYPE_NODE_ATTRIBUTES = ImmutableSet.copyOf((Collection)Sets.union(BASE_NODE_ATTRIBUTES, EnumSet.of(IsAbstract)));
        REFERENCE_TYPE_NODE_ATTRIBUTES = ImmutableSet.copyOf((Collection)Sets.union(BASE_NODE_ATTRIBUTES, EnumSet.of(IsAbstract, Symmetric, InverseName)));
        VARIABLE_NODE_ATTRIBUTES = ImmutableSet.copyOf((Collection)Sets.union(BASE_NODE_ATTRIBUTES, EnumSet.of(Value, new AttributeId[]{DataType, ValueRank, ArrayDimensions, AccessLevel, UserAccessLevel, MinimumSamplingInterval, Historizing})));
        VARIABLE_TYPE_NODE_ATTRIBUTES = ImmutableSet.copyOf((Collection)Sets.union(BASE_NODE_ATTRIBUTES, EnumSet.of(Value, DataType, ValueRank, ArrayDimensions, IsAbstract)));
        VIEW_NODE_ATTRIBUTES = ImmutableSet.copyOf((Collection)Sets.union(BASE_NODE_ATTRIBUTES, EnumSet.of(ContainsNoLoops, EventNotifier)));
    }
}

