/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.application;

import java.security.cert.X509Certificate;
import java.util.List;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.application.CertificateValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsecureCertificateValidator
implements CertificateValidator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void validate(X509Certificate certificate) throws UaException {
        this.logger.warn("Skipping validation for certificate: {}", (Object)certificate.getSubjectX500Principal());
    }

    @Override
    public void verifyTrustChain(List<X509Certificate> certificateChain) throws UaException {
        X509Certificate certificate = certificateChain.get(0);
        this.logger.warn("Skipping trust chain verification for certificate: {}", (Object)certificate.getSubjectX500Principal());
    }
}

